/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterPoolName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterPoolReferenceAdapter
extends AbstractSystemViewAdapter {
    protected String translatedType;
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        Object element = selection.getFirstElement();
        ISystemFilterPool pool = this.getFilterPool(element);
        ISubSystemConfiguration ssFactory = this.getSubSystemConfiguration(pool);
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter(ISubSystemConfigurationAdapter.class);
        if (adapter != null) {
            IAction action;
            int idx;
            IAction[] actions = adapter.getFilterPoolActions(menu, selection, shell, menuGroup, ssFactory, pool);
            if (actions != null) {
                idx = 0;
                while (idx < actions.length) {
                    action = actions[idx];
                    menu.add(menuGroup, action);
                    ++idx;
                }
            }
            if ((actions = adapter.getFilterPoolReferenceActions(menu, selection, shell, menuGroup, ssFactory, (ISystemFilterPoolReference)element)) != null) {
                idx = 0;
                while (idx < actions.length) {
                    action = actions[idx];
                    menu.add(menuGroup, action);
                    ++idx;
                }
            }
        }
    }

    private ISubSystemConfiguration getSubSystemConfiguration(ISystemFilterPool pool) {
        return SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilterPool)pool);
    }

    public ISubSystem getSubSystem(Object element) {
        ISystemFilterPoolReference ref = (ISystemFilterPoolReference)element;
        return (ISubSystem)ref.getProvider();
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ISubSystemConfigurationAdapter adapter;
        ISystemFilterPoolManagerProvider provider;
        ImageDescriptor poolImage = null;
        ISystemFilterPool pool = this.getFilterPool(element);
        if (pool != null && (provider = pool.getProvider()) != null && (adapter = (ISubSystemConfigurationAdapter)provider.getAdapter(ISubSystemConfigurationAdapter.class)) != null) {
            poolImage = adapter.getSystemFilterPoolImage(pool);
        }
        if (poolImage == null) {
            poolImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
        }
        return poolImage;
    }

    private ISystemFilterPool getFilterPool(Object element) {
        ISystemFilterPoolReference ref = (ISystemFilterPoolReference)element;
        ISystemFilterPool pool = ref.getReferencedFilterPool();
        return pool;
    }

    public String getText(Object element) {
        ISystemFilterPoolReference reference = (ISystemFilterPoolReference)element;
        String result = reference.getName();
        ISystemFilterPool pool = this.getFilterPool(element);
        if (pool != null) {
            result = pool.getName();
        }
        return result;
    }

    public String getName(Object element) {
        return this.getFilterPool(element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilterPoolReference filterPoolRef = (ISystemFilterPoolReference)element;
        ISystemFilterPoolReferenceManagerProvider subSystem = filterPoolRef.getProvider();
        ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(subSystem);
        String parentAbsoluteName = adapter != null ? adapter.getAbsoluteName(subSystem) : "";
        String referenceName = filterPoolRef.getName();
        String managerName = filterPoolRef.getReferencedFilterPoolManagerName();
        String absoluteName = String.valueOf(parentAbsoluteName) + "." + managerName + "." + referenceName;
        return absoluteName;
    }

    public String getType(Object element) {
        if (this.translatedType == null) {
            this.translatedType = SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_TYPE_VALUE;
        }
        return this.translatedType;
    }

    public Object getParent(Object element) {
        ISystemFilterPoolReference fpr = (ISystemFilterPoolReference)element;
        return SubSystemHelpers.getParentSubSystem((ISystemFilterPoolReference)fpr);
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        ISystemFilterPoolReference fpRef = (ISystemFilterPoolReference)element;
        ISubSystem ss = this.getSubSystem(element);
        return fpRef.getSystemFilterReferences(ss);
    }

    public boolean hasChildren(IAdaptable element) {
        ISystemFilterPool filterPool;
        int count = 0;
        ISystemFilterPoolReference fpRef = (ISystemFilterPoolReference)element;
        if (fpRef != null && (filterPool = fpRef.getReferencedFilterPool()) != null) {
            count = filterPool.getSystemFilterCount();
        }
        return count > 0;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[3];
            int idx = 0;
            SystemViewFilterPoolReferenceAdapter.propertyDescriptorArray[idx] = SystemViewFilterPoolReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPOOL_TOOLTIP);
            SystemViewFilterPoolReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterPoolReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.profile", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPROFILE_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPROFILE_TOOLTIP);
            SystemViewFilterPoolReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterPoolReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterRelatedConnection", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_RELATEDCONNECTION_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_RELATEDCONNECTION_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilterPool pool = this.getFilterPool(this.propertySourceInput);
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            return pool.getName();
        }
        if (name.equals("org.eclipse.rse.ui.profile")) {
            return pool.getSystemFilterPoolManager().getName();
        }
        if (name.equals("org.eclipse.rse.ui.filterRelatedConnection")) {
            return pool.getOwningParentName() == null ? this.getTranslatedNotApplicable() : pool.getOwningParentName();
        }
        return null;
    }

    public boolean canDelete(Object element) {
        ISystemFilterPool fp = this.getFilterPool(element);
        return fp.isDeletable();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        ISystemFilterPool fp = this.getFilterPool(element);
        ISystemFilterPoolManager fpMgr = fp.getSystemFilterPoolManager();
        fpMgr.deleteSystemFilterPool(fp);
        return true;
    }

    public boolean canRename(Object element) {
        if (!this.canDelete(element)) {
            return false;
        }
        ISystemFilterPool fp = this.getFilterPool(element);
        return !fp.isNonRenamable();
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) throws Exception {
        ISystemFilterPool fp = this.getFilterPool(element);
        ISystemFilterPoolManager fpMgr = fp.getSystemFilterPoolManager();
        fpMgr.renameSystemFilterPool(fp, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        ISystemFilterPool fp = null;
        if (element instanceof ISystemFilterPoolReference) {
            fp = this.getFilterPool(element);
        } else if (element instanceof ISystemFilterPool) {
            fp = (ISystemFilterPool)element;
        } else {
            throw new IllegalArgumentException();
        }
        ISystemFilterPoolManager mgr = fp.getSystemFilterPoolManager();
        String[] names = mgr.getSystemFilterPoolNames();
        ValidatorFilterPoolName nameValidator = new ValidatorFilterPoolName(names);
        return nameValidator;
    }

    public String getCanonicalNewName(Object element, String newName) {
        String mgrName = ((ISystemFilterPoolReference)element).getReferencedFilterPoolManagerName();
        return (String.valueOf(mgrName) + "." + newName).toUpperCase();
    }

    public String getMementoHandle(Object element) {
        ISystemFilterPoolReference fpRef = (ISystemFilterPoolReference)element;
        return fpRef.getFullName();
    }

    public String getInputMementoHandle(Object element) {
        Object parent = this.getParent(element);
        return String.valueOf(SystemAdapterHelpers.getViewAdapter(parent, this.getViewer()).getInputMementoHandle(parent)) + "///" + this.getMementoHandle(element);
    }

    public String getMementoHandleKey(Object element) {
        return "FPoolRef";
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

