/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.operations;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.ResolutionResult;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class PlanAnalyzer {
    public static IStatus getStatus(int statusCode, IInstallableUnit affectedIU) {
        switch (statusCode) {
            case 10000: {
                return new Status(1, "org.eclipse.equinox.p2.operations", statusCode, Messages.PlanAnalyzer_NoUpdates, null);
            }
            case 10001: {
                return new MultiStatus("org.eclipse.equinox.p2.operations", statusCode, Messages.PlanAnalyzer_RequestAltered, null);
            }
            case 10003: {
                return new Status(1, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_ImpliedUpdate, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10013: {
                return new Status(2, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_LockedImpliedUpdate0, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10004: {
                return new Status(2, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_IgnoringImpliedDowngrade, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10005: {
                return new Status(2, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_AlreadyInstalled, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10006: {
                return new Status(1, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_PartialInstall, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10007: {
                return new Status(1, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_PartialUninstall, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10050: {
                return new Status(4, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_NothingToDo, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10052: {
                return new Status(4, "org.eclipse.equinox.p2.operations", statusCode, Messages.PlanAnalyzer_AnotherOperationInProgress, null);
            }
        }
        return new Status(4, "org.eclipse.equinox.p2.operations", statusCode, NLS.bind((String)Messages.PlanAnalyzer_UnexpectedError, (Object)new Integer(statusCode), (Object)PlanAnalyzer.getIUString(affectedIU)), null);
    }

    public static MultiStatus getProfileChangeAlteredStatus() {
        return (MultiStatus)PlanAnalyzer.getStatus(10001, null);
    }

    public static ResolutionResult computeResolutionResult(ProfileChangeRequest originalRequest, IProvisioningPlan plan, MultiStatus originalStatus) {
        RequestStatus rs;
        PlannerStatus plannerStatus;
        Assert.isNotNull((Object)originalRequest);
        Assert.isNotNull((Object)plan);
        Assert.isNotNull((Object)originalStatus);
        ResolutionResult report = new ResolutionResult();
        if (plan.getStatus().getSeverity() == 8) {
            report.addSummaryStatus(plan.getStatus());
            return report;
        }
        if (PlanAnalyzer.nothingToDo(originalRequest)) {
            report.addSummaryStatus(PlanAnalyzer.getStatus(10050, null));
            IStatus[] details = originalStatus.getChildren();
            int i = 0;
            while (i < details.length) {
                report.addSummaryStatus(details[i]);
                ++i;
            }
            return report;
        }
        if (originalStatus != null && originalStatus.getChildren().length > 0) {
            report.addSummaryStatus((IStatus)originalStatus);
        }
        if (!plan.getStatus().isOK()) {
            report.addSummaryStatus(plan.getStatus());
        }
        PlannerStatus plannerStatus2 = plannerStatus = plan.getStatus() instanceof PlannerStatus ? (PlannerStatus)plan.getStatus() : null;
        if (plannerStatus == null) {
            return report;
        }
        if (plan.getStatus().getSeverity() != 4) {
            Collection iusAdded = originalRequest.getAdditions();
            for (IInstallableUnit added : iusAdded) {
                rs = (RequestStatus)plannerStatus.getRequestChanges().get(added);
                if (rs.getSeverity() != 4) continue;
                Status fail = new Status(4, "org.eclipse.equinox.p2.operations", 10011, NLS.bind((String)Messages.PlanAnalyzer_IgnoringInstall, (Object)PlanAnalyzer.getIUString(added)), null);
                report.addStatus(added, (IStatus)fail);
                report.addSummaryStatus((IStatus)fail);
            }
            Collection iusRemoved = originalRequest.getRemovals();
            for (IInstallableUnit removed : iusRemoved) {
                RequestStatus rs2 = (RequestStatus)plannerStatus.getRequestChanges().get(removed);
                if (rs2.getSeverity() != 4) continue;
                Status fail = new Status(1, "org.eclipse.equinox.p2.operations", 10007, NLS.bind((String)Messages.PlanAnalyzer_PartialUninstall, (Object)PlanAnalyzer.getIUString(removed)), null);
                report.addStatus(removed, (IStatus)fail);
                report.addSummaryStatus((IStatus)fail);
            }
        }
        if (plannerStatus.getRequestSideEffects() != null) {
            for (Map.Entry entry : plannerStatus.getRequestSideEffects().entrySet()) {
                IInstallableUnit iu = (IInstallableUnit)entry.getKey();
                rs = (RequestStatus)entry.getValue();
                if (rs.getInitialRequestType() == 0) {
                    report.addStatus(iu, (IStatus)new Status(rs.getSeverity(), "org.eclipse.equinox.p2.operations", 10010, NLS.bind((String)Messages.PlanAnalyzer_SideEffectInstall, (Object)PlanAnalyzer.getIUString(iu)), null));
                    continue;
                }
                report.addStatus(iu, (IStatus)new Status(rs.getSeverity(), "org.eclipse.equinox.p2.operations", 10009, NLS.bind((String)Messages.PlanAnalyzer_SideEffectUninstall, (Object)PlanAnalyzer.getIUString(iu)), null));
            }
        }
        return report;
    }

    private static String getIUString(IInstallableUnit iu) {
        if (iu == null) {
            return Messages.PlanAnalyzer_Items;
        }
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (name != null) {
            return name;
        }
        return iu.getId();
    }

    private static boolean nothingToDo(ProfileChangeRequest request) {
        return request.getAdditions().size() == 0 && request.getRemovals().size() == 0 && request.getInstallableUnitProfilePropertiesToAdd().size() == 0 && request.getInstallableUnitProfilePropertiesToRemove().size() == 0;
    }
}

