/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.ImportFromInstallationPage_c;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.ProvUIMessages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFromInstallationWizard_c
extends InstallWizard
implements IImportWizard {
    private IProfile toImportFrom;
    private URI[] reposToMigrate;
    private List<URI> addedRepos = new ArrayList<URI>();

    public ImportFromInstallationWizard_c() {
        this(ProvisioningUI.getDefaultUI(), null, null, null);
    }

    public ImportFromInstallationWizard_c(IProfile toImportFrom, URI[] reposToMigrate) {
        this(ProvisioningUI.getDefaultUI(), null, null, null);
        this.toImportFrom = toImportFrom;
        this.reposToMigrate = reposToMigrate;
        this.addRepos();
    }

    public ImportFromInstallationWizard_c(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, operation, initialSelections, preloadJob);
        IDialogSettings workbenchSettings = ProvUIActivator.getDefault().getDialogSettings();
        String sectionName = "ImportFromInstallationWizard";
        IDialogSettings section = workbenchSettings.getSection(sectionName);
        if (section == null) {
            section = workbenchSettings.addNewSection(sectionName);
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ProvUIMessages.ImportWizard_WINDOWTITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.equinox.p2.ui").getEntry("icons/install_wiz.gif")));
        this.setNeedsProgressMonitor(true);
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        if (this.toImportFrom != null) {
            return new ImportFromInstallationPage_c(this.ui, this, this.toImportFrom);
        }
        return new ImportFromInstallationPage_c(this.ui, (ProvisioningOperationWizard)this);
    }

    protected ProvisioningContext getProvisioningContext() {
        return ((ImportFromInstallationPage_c)this.mainPage).getProvisioningContext();
    }

    public boolean performFinish() {
        this.cleanupProfileRegistry();
        boolean finished = super.performFinish();
        if (finished) {
            this.rememberMigrationCompleted();
        }
        return finished;
    }

    private void addRepos() {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        List<URI> currentMetaRepos = Arrays.asList(metaManager.getKnownRepositories(0));
        if (this.reposToMigrate != null && metaManager != null && artifactManager != null) {
            int i = 0;
            while (i < this.reposToMigrate.length) {
                if (!currentMetaRepos.contains(this.reposToMigrate[i])) {
                    metaManager.addRepository(this.reposToMigrate[i]);
                    artifactManager.addRepository(this.reposToMigrate[i]);
                    this.addedRepos.add(this.reposToMigrate[i]);
                }
                ++i;
            }
        }
    }

    private void removeRepos() {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (metaManager != null && artifactManager != null) {
            int i = 0;
            while (i < this.addedRepos.size()) {
                metaManager.removeRepository(this.reposToMigrate[i]);
                artifactManager.removeRepository(this.reposToMigrate[i]);
                ++i;
            }
        }
    }

    private void rememberMigrationCompleted() {
        AutomaticUpdatePlugin.getDefault().rememberMigrationCompleted(this.toImportFrom.getProfileId());
    }

    private void cleanupProfileRegistry() {
        IProfileRegistry registry = (IProfileRegistry)ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        long[] history = registry.listProfileTimestamps(this.toImportFrom.getProfileId());
        int i = 0;
        while (i < history.length) {
            if (history[i] < this.toImportFrom.getTimestamp()) {
                try {
                    registry.removeProfile(this.toImportFrom.getProfileId(), history[i]);
                }
                catch (ProvisionException provisionException) {}
            }
            ++i;
        }
    }

    public boolean performCancel() {
        boolean result = false;
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, ProvUIMessages.ImportFromInstallationPag_LATER_BUTTON, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(this.getShell(), ProvUIMessages.ImportFromInstallationPage_CONFIRMATION_TITLE, null, ProvUIMessages.ImportFromInstallationPage_CONFIRMATION_DIALOG, 3, buttons, 2);
        int answer = dialog.open();
        switch (answer) {
            case -1: {
                break;
            }
            case 0: {
                result = true;
                this.removeRepos();
                this.rememberMigrationCompleted();
                break;
            }
            case 1: {
                result = true;
                this.removeRepos();
                break;
            }
            case 2: {
                result = false;
            }
        }
        return result;
    }
}

