/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.framework.Bundle;

public final class LuaDocumentationHelper {
    public static final String BACKGROUND_COLOR_ID = "org.eclipse.koneki.ldt.ui.docbackground";
    public static final String FOREGROUND_COLOR_ID = "org.eclipse.koneki.ldt.ui.docforeground";
    private static final String CSS_FILE_PATH = "/resources/css/lua_documentation.css";
    private static String styleSheet;

    private LuaDocumentationHelper() {
    }

    private static ColorRegistry getColorRegistry() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        return currentTheme.getColorRegistry();
    }

    public static Color getForegroundColor() {
        return LuaDocumentationHelper.getColorRegistry().get(FOREGROUND_COLOR_ID);
    }

    public static Color getBackgroundColor() {
        return LuaDocumentationHelper.getColorRegistry().get(BACKGROUND_COLOR_ID);
    }

    public static String getStyleSheet() {
        if (styleSheet == null) {
            styleSheet = LuaDocumentationHelper.initStyleSheet();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
        String styleSheetWithPreference = HTMLPrinter.convertTopLevelFont((String)styleSheet, (FontData)fontData);
        RGB bgColor = LuaDocumentationHelper.getBackgroundColor().getRGB();
        RGB fgColor = LuaDocumentationHelper.getForegroundColor().getRGB();
        styleSheetWithPreference = "body {color:" + LuaDocumentationHelper.toHtmlColor(fgColor) + "; background-color:" + LuaDocumentationHelper.toHtmlColor(bgColor) + ";}" + styleSheetWithPreference;
        return styleSheetWithPreference;
    }

    protected static String initStyleSheet() {
        Bundle bundle = Activator.getDefault().getBundle();
        URL styleSheetURL = bundle.getEntry(CSS_FILE_PATH);
        if (styleSheetURL == null) {
            String errorMessage = MessageFormat.format("No css found on the path: {1}", CSS_FILE_PATH);
            Activator.logError(errorMessage, new NullPointerException());
        }
        try {
            styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
            File cssFile = FileUtils.toFile((URL)styleSheetURL);
            return FileUtils.readFileToString((File)cssFile);
        }
        catch (IOException ex) {
            Activator.logError("Unable to open CSS file for luadoc view", ex);
            return null;
        }
    }

    protected static String toHtmlColor(RGB color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('#');
        LuaDocumentationHelper.appendHex(color.red, buffer);
        LuaDocumentationHelper.appendHex(color.green, buffer);
        LuaDocumentationHelper.appendHex(color.blue, buffer);
        return buffer.toString();
    }

    protected static void appendHex(int color, StringBuffer buffer) {
        String string = Integer.toHexString(color).toUpperCase();
        if (string.length() == 1) {
            buffer.append("0");
        }
        buffer.append(string);
    }

    public static String generatePage(String htmlContent) {
        return LuaDocumentationHelper.generatePage(LuaDocumentationHelper.getStyleSheet(), htmlContent);
    }

    public static String generatePage(String cssStyle, String htmlContent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append(cssStyle);
        buffer.append("</style></head><body>");
        buffer.append(htmlContent);
        buffer.append("</body></html>");
        return buffer.toString();
    }
}

