/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.text.HTMLPrinter;
import org.eclipse.dltk.internal.ui.text.hover.DocumentationHover;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationTitleAdapter;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.koneki.ldt.ui.internal.LuaDocumentationHelper;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaHoverControlCreator;

public class LuaDocumentationHover
extends DocumentationHover {
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x20L | 0x4000L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final IScriptDocumentationTitleAdapter TITLE_ADAPTER = new IScriptDocumentationTitleAdapter(){
        private ScriptElementImageProvider fImageProvider = new ScriptElementImageProvider();

        public String getTitle(Object element) {
            if (element instanceof IModelElement) {
                IModelElement member = (IModelElement)element;
                long flags = member.getElementType() == 13 ? LOCAL_VARIABLE_FLAGS : LABEL_FLAGS;
                String label = ScriptElementLabels.getDefault().getElementLabel(member, flags);
                return label;
            }
            return null;
        }

        public ImageDescriptor getImage(Object element) {
            if (element instanceof IModelElement) {
                IModelElement modelElement = (IModelElement)element;
                if (this.fImageProvider == null) {
                    this.fImageProvider = new ScriptElementImageProvider();
                }
                return this.fImageProvider.getScriptImageDescriptor(modelElement, 3);
            }
            return null;
        }
    };
    private IInformationControlCreator fHoverControlCreator;

    protected String getHoverInfo(String nature, Object[] result) {
        String htmlContent = null;
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults > 0) {
            Object element = result[0];
            IDocumentationResponse response = ScriptDocumentationAccess.getDocumentation((String)nature, (Object)element, (Object)TITLE_ADAPTER);
            if (response != null) {
                try {
                    htmlContent = HTMLPrinter.read((Reader)response.getReader());
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            if (htmlContent == null || htmlContent.isEmpty()) {
                throw new RuntimeException("Exception to avoid to create a tooltip, currently a workaround for dltk");
            }
            return LuaDocumentationHelper.generatePage(htmlContent);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new LuaHoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }
}

