/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.clientserver.messages.SystemUnsupportedOperationException;

public class ArchiveHandlerManager {
    public static final String VIRTUAL_SEPARATOR = "#virtual#/";
    public static final String VIRTUAL_CANONICAL_SEPARATOR = "#virtual#";
    public static final String VIRTUAL_FOLDER_SEPARATOR = "/";
    public static final String EXTENSION_SEPARATOR = ".";
    protected static ArchiveHandlerManager _instance = new ArchiveHandlerManager();
    protected HashMap _handlers = new HashMap();
    protected HashMap _handlerTypes = new HashMap();

    public static ArchiveHandlerManager getInstance() {
        return _instance;
    }

    public VirtualChild[] getContents(File file, String virtualpath) throws SystemMessageException {
        ISystemArchiveHandler handler;
        if (virtualpath == null) {
            virtualpath = "";
        }
        if ((handler = this.getRegisteredHandler(file)) == null || !handler.exists()) {
            throw new SystemUnsupportedOperationException("org.eclipse.rse.services", "No archive handler for " + file);
        }
        return handler.getVirtualChildren(virtualpath, null);
    }

    public VirtualChild[] getFolderContents(File file, String virtualpath) throws SystemMessageException {
        ISystemArchiveHandler handler;
        if (virtualpath == null) {
            virtualpath = "";
        }
        if ((handler = this.getRegisteredHandler(file)) == null) {
            return null;
        }
        return handler.getVirtualChildFolders(virtualpath, null);
    }

    public boolean isArchive(File file) {
        if (this._handlers.containsKey(file)) {
            return true;
        }
        return this.getRegisteredExtension(file) != null;
    }

    public boolean isRegisteredArchive(String filename) {
        return this.getRegisteredExtension(filename) != null;
    }

    protected String getRegisteredExtension(File file) {
        String fileName = file.getName();
        return this.getRegisteredExtension(fileName);
    }

    protected String getRegisteredExtension(String fileName) {
        fileName = fileName.toLowerCase();
        Iterator itor = this._handlerTypes.keySet().iterator();
        while (itor.hasNext()) {
            String ext = ((String)itor.next()).toLowerCase();
            if (!fileName.endsWith(EXTENSION_SEPARATOR + ext)) continue;
            return ext;
        }
        return null;
    }

    protected String getExtension(File file) {
        String filename = file.getName();
        int i = filename.lastIndexOf(EXTENSION_SEPARATOR);
        if (i == -1) {
            return "";
        }
        return filename.substring(i + 1).toLowerCase();
    }

    protected String getExtension(String filename) {
        int i = filename.lastIndexOf(EXTENSION_SEPARATOR);
        if (i == -1) {
            return "";
        }
        return filename.substring(i + 1).toLowerCase();
    }

    public VirtualChild getVirtualObject(String fullyQualifiedName) throws SystemMessageException {
        String cleanName = ArchiveHandlerManager.cleanUpVirtualPath(fullyQualifiedName);
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(cleanName);
        if (!avp.isVirtual()) {
            return new VirtualChild("", new File(avp.getContainingArchiveString()));
        }
        String zipfile = avp.getContainingArchiveString();
        File file = new File(zipfile);
        ISystemArchiveHandler handler = this.getRegisteredHandler(file);
        if (handler == null) {
            return new VirtualChild(avp.getVirtualPart(), new File(avp.getContainingArchiveString()));
        }
        VirtualChild vc = handler.getVirtualFile(avp.getVirtualPart(), null);
        return vc;
    }

    public ISystemArchiveHandler getRegisteredHandler(File file) throws SystemMessageException {
        ISystemArchiveHandler handler = null;
        if (this._handlers.containsKey(file)) {
            handler = (ISystemArchiveHandler)this._handlers.get(file);
        }
        if (handler != null && handler.exists()) {
            return handler;
        }
        String ext = this.getRegisteredExtension(file);
        if (ext == null) {
            return null;
        }
        Class handlerType = (Class)this._handlerTypes.get(ext);
        Constructor newHandlerType = this.getProperConstructor(handlerType);
        Object[] files = new Object[]{file};
        try {
            handler = (ISystemArchiveHandler)newHandlerType.newInstance(files);
        }
        catch (InvocationTargetException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Failed to instantiate handler for " + file.getName(), e);
        }
        catch (Exception e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Failed to instantiate handler for " + file.getName(), e);
        }
        this._handlers.put(file, handler);
        return handler;
    }

    public Constructor getProperConstructor(Class handlerType) {
        Constructor<?>[] constructors = handlerType.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 1 && constructors[i].getParameterTypes()[0].equals(File.class)) {
                return constructors[i];
            }
            ++i;
        }
        return null;
    }

    public boolean setRegisteredHandler(String ext, Class handlerType) {
        if (!this.handlerHasProperConstructor(handlerType)) {
            System.out.println("Cannot register archive handler " + handlerType);
            System.out.println(handlerType + " does not contain a constructor whose signature is 'Constructor(File file)'");
            return false;
        }
        if (this.handlerImplementsISystemArchiveHandler(handlerType)) {
            if (this._handlerTypes.containsKey(ext)) {
                this._handlerTypes.remove(ext);
            }
            this._handlerTypes.put(ext, handlerType);
            return true;
        }
        System.out.println("Cannot register archive handler " + handlerType);
        System.out.println("Neither " + handlerType + ", nor any of its superclasses implements ISystemArchiveHandler.");
        return false;
    }

    protected boolean handlerHasProperConstructor(Class handlerType) {
        Constructor<?>[] constructors = handlerType.getConstructors();
        boolean ok = false;
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 1 && constructors[i].getParameterTypes()[0].equals(File.class)) {
                ok = true;
                break;
            }
            ++i;
        }
        return ok;
    }

    protected boolean handlerImplementsISystemArchiveHandler(Class handlerType) {
        Class<?>[] interfaces = handlerType.getInterfaces();
        boolean okay = false;
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(ISystemArchiveHandler.class.getName())) {
                okay = true;
            }
            ++i;
        }
        if (!okay) {
            Class superclass = handlerType.getSuperclass();
            if (superclass.getName().equals(Object.class.getName())) {
                return false;
            }
            return this.handlerImplementsISystemArchiveHandler(superclass);
        }
        return true;
    }

    public void disposeOfRegisteredHandlerFor(File file) {
        this._handlers.remove(file);
    }

    public static boolean isVirtual(String path) {
        return path.indexOf(VIRTUAL_CANONICAL_SEPARATOR) != -1;
    }

    public static String cleanUpVirtualPath(String fullVirtualName) {
        int j = fullVirtualName.indexOf(VIRTUAL_CANONICAL_SEPARATOR);
        if (j == -1 && (fullVirtualName.indexOf(":") != -1 || fullVirtualName.trim().startsWith("\\"))) {
            return fullVirtualName;
        }
        String realPart = "";
        String newPath = fullVirtualName;
        if (j != -1) {
            try {
                realPart = String.valueOf(fullVirtualName.substring(0, j)) + VIRTUAL_SEPARATOR;
                newPath = j + VIRTUAL_SEPARATOR.length() < fullVirtualName.length() ? fullVirtualName.substring(j + VIRTUAL_SEPARATOR.length()) : "";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        newPath = newPath.replace('\\', '/');
        int i = newPath.indexOf("//");
        while (i != -1) {
            newPath = String.valueOf(newPath.substring(0, i)) + newPath.substring(i + 1);
            i = newPath.indexOf("//");
        }
        if (j != -1 && newPath.startsWith(VIRTUAL_FOLDER_SEPARATOR)) {
            newPath = newPath.substring(1);
        }
        if (newPath.endsWith(VIRTUAL_FOLDER_SEPARATOR)) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        return String.valueOf(realPart) + newPath;
    }

    public void dispose() {
        this._handlers.clear();
    }

    public void createEmptyArchive(File newFile) throws SystemMessageException {
        if (!this.isRegisteredArchive(newFile.getName())) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create new archive, because " + newFile + " is not a registered type of archive.");
        }
        if (newFile.exists()) {
            if (!newFile.isFile()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create new archive." + newFile + " is not a file.");
            }
            if (!newFile.delete()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create new archive." + newFile + " could not be deleted.");
            }
        }
        try {
            if (!newFile.createNewFile()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create new archive." + newFile + " could not be created.");
            }
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create new archive: " + newFile, e);
        }
        ISystemArchiveHandler handler = this.getRegisteredHandler(newFile);
        handler.create();
    }

    public String[] getRegisteredExtensions() {
        Object[] exts = this._handlerTypes.keySet().toArray();
        String[] extensions = new String[exts.length];
        int i = 0;
        while (i < exts.length) {
            extensions[i] = (String)exts[i];
            ++i;
        }
        return extensions;
    }

    public String getComment(File archive) throws SystemMessageException {
        ISystemArchiveHandler handler = this.getRegisteredHandler(archive);
        if (handler == null || !handler.exists()) {
            return "";
        }
        return handler.getArchiveComment();
    }

    public long getExpandedSize(File archive) throws SystemMessageException {
        ISystemArchiveHandler handler = this.getRegisteredHandler(archive);
        if (handler == null || !handler.exists()) {
            return 0L;
        }
        VirtualChild[] allEntries = handler.getVirtualChildrenList(null);
        int total = 0;
        int i = 0;
        while (i < allEntries.length) {
            total = (int)((long)total + allEntries[i].getSize());
            ++i;
        }
        return total;
    }

    public String getClassification(File file, String virtualPath) throws SystemMessageException {
        if (file == null || !file.exists()) {
            return null;
        }
        ISystemArchiveHandler handler = this.getRegisteredHandler(file);
        if (handler == null || !handler.exists()) {
            return null;
        }
        return handler.getClassification(virtualPath);
    }
}

