/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimBarLayout;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimBarRenderer
extends SWTPartRenderer {
    private MApplication application;
    private LayoutJob layoutJob = null;

    private synchronized void layoutTrim(MTrimBar trimBar) {
        Composite comp = (Composite)trimBar.getWidget();
        if (comp == null || comp.isDisposed()) {
            return;
        }
        if (this.layoutJob == null) {
            this.layoutJob = new LayoutJob();
            this.layoutJob.barsToLayout.add(trimBar);
            comp.getDisplay().asyncExec((Runnable)this.layoutJob);
        } else if (!this.layoutJob.barsToLayout.contains(trimBar)) {
            this.layoutJob.barsToLayout.add(trimBar);
        }
    }

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MTrimBar) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComp = (Composite)parent;
        Composite trimComposite = null;
        final MTrimBar trimModel = (MTrimBar)element;
        if (parentComp.getLayout() instanceof TrimmedPartLayout) {
            TrimmedPartLayout tpl = (TrimmedPartLayout)parentComp.getLayout();
            switch (trimModel.getSide().getValue()) {
                case 0: {
                    trimComposite = tpl.getTrimComposite(parentComp, 128);
                    break;
                }
                case 1: {
                    trimComposite = tpl.getTrimComposite(parentComp, 1024);
                    break;
                }
                case 2: {
                    trimComposite = tpl.getTrimComposite(parentComp, 16384);
                    break;
                }
                case 3: {
                    trimComposite = tpl.getTrimComposite(parentComp, 131072);
                    break;
                }
                default: {
                    return null;
                }
            }
            trimComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TrimBarRenderer.this.cleanUp(trimModel);
                }
            });
        } else {
            trimComposite = new Composite(parentComp, 0);
            trimComposite.setLayout((Layout)new TrimBarLayout(true));
        }
        return trimComposite;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        MElementContainer<MUIElement> downCast = parentElement;
        this.layoutTrim((MTrimBar)downCast);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        if (!(me instanceof MTrimBar)) {
            return;
        }
        super.processContents(me);
        IEclipseContext ctx = this.getContext((MUIElement)me);
        ExpressionContext eContext = new ExpressionContext(ctx);
        MElementContainer<MUIElement> trimObj = me;
        MTrimBar trimModel = (MTrimBar)trimObj;
        ArrayList<MTrimContribution> toContribute = new ArrayList<MTrimContribution>();
        ContributionsAnalyzer.gatherTrimContributions((MTrimBar)trimModel, (List)this.application.getTrimContributions(), (String)trimModel.getElementId(), toContribute, (ExpressionContext)eContext);
        this.addTrimContributions(trimModel, toContribute, ctx, eContext);
    }

    private void addTrimContributions(final MTrimBar trimModel, ArrayList<MTrimContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext) {
        HashSet<String> existingToolbarIds = new HashSet<String>();
        MTrimmedWindow topWin = (MTrimmedWindow)this.modelService.getTopLevelWindowFor((MUIElement)trimModel);
        for (MTrimBar bar : topWin.getTrimBars()) {
            for (MTrimElement item : bar.getChildren()) {
                String id = item.getElementId();
                if (id == null) continue;
                existingToolbarIds.add(id);
            }
        }
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MTrimContribution> curList = new ArrayList<MTrimContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (final MTrimContribution contribution : curList) {
                ArrayList toRemove;
                if (!ContributionsAnalyzer.processAddition((MTrimBar)trimModel, (MTrimContribution)contribution, toRemove = new ArrayList(), existingToolbarIds)) {
                    toContribute.add(contribution);
                    continue;
                }
                if (contribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!trimModel.isToBeRendered() || !trimModel.isVisible() || trimModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MTrimContribution)contribution, (ExpressionContext)eContext);
                            for (MTrimElement child : toRemove) {
                                child.setToBeRendered(rc);
                            }
                            return true;
                        }
                    });
                }
                trimModel.getPendingCleanup().addAll(toRemove);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    protected void cleanUp(MTrimBar element) {
        for (MTrimElement child : element.getPendingCleanup()) {
            element.getChildren().remove(child);
        }
        element.getPendingCleanup().clear();
    }

    private class LayoutJob
    implements Runnable {
        public List<MTrimBar> barsToLayout = new ArrayList<MTrimBar>();

        private LayoutJob() {
        }

        public void run() {
            TrimBarRenderer.this.layoutJob = null;
            if (this.barsToLayout.size() == 0) {
                return;
            }
            for (MTrimBar bar : this.barsToLayout) {
                Composite trimCtrl = (Composite)bar.getWidget();
                if (trimCtrl == null || trimCtrl.isDisposed()) continue;
                trimCtrl.layout();
            }
        }
    }
}

