/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUPatternFilter;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractPage_c
extends WizardPage
implements Listener {
    protected String currentMessage;
    protected CheckboxTreeViewer viewer = null;
    protected Exception finishException;
    protected boolean entryChanged = false;
    protected static IProfileRegistry profileRegistry = null;
    static IProvisioningAgent agent = null;
    public static final String REMIND_ME_LATER = "remindMeToMigrateLater";
    protected static final int COMBO_HISTORY_LENGTH = 5;

    static {
        BundleContext context = Platform.getBundle((String)"org.eclipse.equinox.p2.ui").getBundleContext();
        ServiceTracker tracker = new ServiceTracker(context, IProvisioningAgent.class, null);
        tracker.open();
        agent = (IProvisioningAgent)tracker.getService();
        tracker.close();
        if (agent != null) {
            profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        }
    }

    public AbstractPage_c(String pageName) {
        super(pageName);
    }

    public AbstractPage_c(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected IProfile getSelfProfile() {
        if (profileRegistry != null) {
            String selfID = System.getProperty("eclipse.p2.profile");
            if (selfID == null) {
                selfID = "_SELF_";
            }
            return profileRegistry.getProfile(selfID);
        }
        return null;
    }

    private void createColumns(TreeViewer treeViewer) {
        String[] titles = new String[]{ProvUIMessages.Column_Name, ProvUIMessages.Column_Version, ProvUIMessages.Column_Id};
        int i = 0;
        while (i < titles.length) {
            TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            if (ProvUIMessages.Column_Name.equals(titles[i])) {
                this.updateTableSorting(i);
            }
            final int columnIndex = i++;
            column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPage_c.this.updateTableSorting(columnIndex);
                }
            });
        }
    }

    protected void updateTableSorting(int columnIndex) {
        TreeViewerComparator comparator = (TreeViewerComparator)this.viewer.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(columnIndex));
        this.viewer.getTree().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.viewer.refresh(false);
    }

    protected abstract void createContents(Composite var1);

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.createContents(composite);
        if (!this.validateOptionsGroup()) {
            this.setPageComplete(false);
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected IUColumnConfig[] getColumnConfig() {
        return new IUColumnConfig[]{new IUColumnConfig(org.eclipse.equinox.internal.p2.ui.ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(org.eclipse.equinox.internal.p2.ui.ProvUIMessages.ProvUI_VersionColumnTitle, 2, 20), new IUColumnConfig(org.eclipse.equinox.internal.p2.ui.ProvUIMessages.ProvUI_IdColumnTitle, 0, 40)};
    }

    protected void createInstallationTable(final Composite parent) {
        Group group = new Group(parent, 0);
        GridData griddata = new GridData(4, 4, true, true);
        griddata.horizontalSpan = 0;
        griddata.verticalSpan = 0;
        group.setLayoutData((Object)griddata);
        group.setLayout((Layout)new GridLayout(1, false));
        PatternFilter filter = this.getPatternFilter();
        filter.setIncludeLeadingWildcard(true);
        final ImportExportFilteredTree filteredTree = new ImportExportFilteredTree((Composite)group, 68354, filter, true);
        this.viewer = (CheckboxTreeViewer)filteredTree.getViewer();
        final Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        this.viewer.setComparator((ViewerComparator)new TreeViewerComparator());
        this.viewer.setComparer((IElementComparer)new ProvElementComparer());
        this.createColumns((TreeViewer)this.viewer);
        final ITreeContentProvider contentProvider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked() && filteredTree.checkState != null) {
                    ArrayList<Object> toRemove = new ArrayList<Object>(1);
                    if (contentProvider.hasChildren(event.getElement())) {
                        HashSet<Object> unchecked = new HashSet<Object>();
                        Object[] children = contentProvider.getChildren(event.getElement());
                        int i = 0;
                        while (i < children.length) {
                            unchecked.add(children[i]);
                            ++i;
                        }
                        for (Object current : filteredTree.checkState) {
                            if (current == null || !unchecked.contains(current)) continue;
                            toRemove.add(current);
                        }
                    } else {
                        for (Object element : filteredTree.checkState) {
                            if (!AbstractPage_c.this.viewer.getComparer().equals(element, event.getElement())) continue;
                            toRemove.add(element);
                        }
                    }
                    filteredTree.checkState.removeAll(toRemove);
                }
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){
            private final int[] columnRate = new int[]{6, 2, 2};

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point size = tree.computeSize(-1, -1);
                ScrollBar vBar = tree.getVerticalBar();
                int width = area.width - tree.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + tree.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tree.getSize();
                TreeColumn[] columns = tree.getColumns();
                int hasUsed = 0;
                int i = 0;
                if (oldSize.x > area.width) {
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                    tree.setSize(area.width, area.height);
                } else {
                    tree.setSize(area.width, area.height);
                    while (i < columns.length - 1) {
                        columns[i].setWidth(width * this.columnRate[i] / 10);
                        hasUsed += columns[i].getWidth();
                        ++i;
                    }
                    columns[columns.length - 1].setWidth(width - hasUsed);
                }
            }
        });
        ICheckStateProvider provider = this.getViewerDefaultState();
        if (provider != null) {
            this.viewer.setCheckStateProvider(provider);
        } else {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractPage_c.this.updatePageCompletion();
                }
            });
        }
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getControl().setSize(300, 200);
        this.viewer.setInput(this.getInput());
        Composite buttons = new Composite((Composite)group, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        buttons.setLayout((Layout)new RowLayout(256));
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(ProvUIMessages.AbstractPage_ButtonSelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = AbstractPage_c.this.viewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (!item.getChecked()) {
                        item.setChecked(true);
                        Event event = new Event();
                        event.widget = item.getParent();
                        event.detail = 32;
                        event.item = item;
                        event.type = 13;
                        AbstractPage_c.this.viewer.getTree().notifyListeners(13, event);
                    }
                    ++n2;
                }
                AbstractPage_c.this.updatePageCompletion();
            }
        });
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(ProvUIMessages.AbstractPage_ButtonDeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = AbstractPage_c.this.viewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    AbstractPage_c.this.viewer.setSubtreeChecked(item.getData(), false);
                    ++n2;
                }
                AbstractPage_c.this.updatePageCompletion();
            }
        });
    }

    protected PatternFilter getPatternFilter() {
        return new AvailableIUPatternFilter(this.getColumnConfig());
    }

    protected ICheckStateProvider getViewerDefaultState() {
        return null;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new IUDetailsLabelProvider(null, this.getColumnConfig(), null);
    }

    protected ITreeContentProvider getContentProvider() {
        ProvElementContentProvider provider = new ProvElementContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof InstalledIUElement) {
                    return false;
                }
                return super.hasChildren(element);
            }

            public Object[] getChildren(Object parent) {
                if (parent instanceof InstalledIUElement) {
                    return new Object[0];
                }
                return super.getChildren(parent);
            }
        };
        return provider;
    }

    protected boolean determinePageCompletion() {
        this.currentMessage = null;
        boolean complete = this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    protected abstract void doFinish() throws Exception;

    protected int getBrowseDialogStyle() {
        return 4096;
    }

    protected abstract String getDialogTitle();

    protected abstract Object getInput();

    protected abstract String getInvalidDestinationMessage();

    protected String getNoOptionsMessage() {
        return ProvUIMessages.PAGE_NOINSTALLTION_ERROR;
    }

    public void handleEvent(Event event) {
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
    }

    protected boolean validateOptionsGroup() {
        if (this.viewer == null || this.viewer.getCheckedElements().length > 0) {
            return true;
        }
        this.currentMessage = this.getNoOptionsMessage();
        return false;
    }

    final class ImportExportFilteredTree
    extends FilteredTree {
        ArrayList<Object> checkState;

        ImportExportFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
            super(parent, treeStyle, filter, useNewLook);
            this.checkState = new ArrayList();
        }

        protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
            return new CheckboxTreeViewer(composite, style);
        }

        protected WorkbenchJob doCreateRefreshJob() {
            WorkbenchJob job = super.doCreateRefreshJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void aboutToRun(IJobChangeEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            Object[] checked = ((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer.getCheckedElements();
                            if ((this).ImportExportFilteredTree.this.checkState == null) {
                                (this).ImportExportFilteredTree.this.checkState = new ArrayList(checked.length);
                            }
                            int i = 0;
                            while (i < checked.length) {
                                if (!((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer.getGrayed(checked[i]) && !(this).ImportExportFilteredTree.this.checkState.contains(checked[i])) {
                                    (this).ImportExportFilteredTree.this.checkState.add(checked[i]);
                                }
                                ++i;
                            }
                        }
                    });
                }

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer == null || ((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer.getTree().isDisposed()) {
                                    return;
                                }
                                if ((this).ImportExportFilteredTree.this.checkState == null) {
                                    return;
                                }
                                ((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer.setCheckedElements(new Object[0]);
                                ((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer.setGrayedElements(new Object[0]);
                                Iterator<Object> iter = (this).ImportExportFilteredTree.this.checkState.iterator();
                                while (iter.hasNext()) {
                                    ((ImportExportFilteredTree)(this).ImportExportFilteredTree.this).AbstractPage_c.this.viewer.setChecked(iter.next(), true);
                                }
                                AbstractPage_c.this.updatePageCompletion();
                            }
                        });
                    }
                }
            });
            return job;
        }
    }

    class TreeViewerComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int lastSortColumn = 0;
        private boolean ascending = false;
        private boolean lastAscending = false;

        TreeViewerComparator() {
        }

        public int compare(Viewer viewer1, Object e1, Object e2) {
            IInstallableUnit iu1 = (IInstallableUnit)ProvUI.getAdapter((Object)e1, IInstallableUnit.class);
            IInstallableUnit iu2 = (IInstallableUnit)ProvUI.getAdapter((Object)e2, IInstallableUnit.class);
            if (iu1 != null && iu2 != null) {
                TreeViewer treeViewer;
                IBaseLabelProvider baseLabel;
                if (viewer1 instanceof TreeViewer && (baseLabel = (treeViewer = (TreeViewer)viewer1).getLabelProvider()) instanceof ITableLabelProvider) {
                    ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                    String e1p = tableProvider.getColumnText(e1, this.getSortColumn());
                    String e2p = tableProvider.getColumnText(e2, this.getSortColumn());
                    int result = this.getComparator().compare(e1p, e2p);
                    if (result == 0) {
                        e1p = tableProvider.getColumnText(e1, this.lastSortColumn);
                        e2p = tableProvider.getColumnText(e2, this.lastSortColumn);
                        int result2 = this.getComparator().compare(e1p, e2p);
                        return this.lastAscending ? result2 : -1 * result2;
                    }
                    return this.isAscending() ? result : -1 * result;
                }
                return 0;
            }
            return super.compare(viewer1, e1, e2);
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            if (this.sortColumn != sortColumn) {
                this.lastSortColumn = this.sortColumn;
                this.lastAscending = this.ascending;
                this.sortColumn = sortColumn;
            }
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

