/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.core.internal.lua;

import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;

public class LuaSubSystem
extends SubSystem
implements ISubSystem {
    public static final String LUACOMMAND_PROPERTY_KEY = "lua_command";
    public static final String LUAPATH_PROPERTY_KEY = "lua_path";
    public static final String LUACPATH_PROPERTY_KEY = "lua_cpath";
    public static final String LDLIBRARYPATH_PROPERTY_KEY = "ld_library_path";
    public static final String OUTPUTDIRECTORY_PROPERTY_KEY = "output_dir";
    private static final String LUA_PROPERTY_SET_KEY = "luaSet";
    private static final PropertySet DEFAULT_PROPERTY_SET = new PropertySet("defaultLuaPropertySet");
    private static final String DEFAULT_LUACOMMAND_PROPERTY_VALUE = "lua";
    private static final String DEFAULT_OUTPUTDIRECTORY_PROPERTY_VALUE = "/tmp";

    static {
        DEFAULT_PROPERTY_SET.addProperty(LUACOMMAND_PROPERTY_KEY, DEFAULT_LUACOMMAND_PROPERTY_VALUE);
        DEFAULT_PROPERTY_SET.addProperty(OUTPUTDIRECTORY_PROPERTY_KEY, DEFAULT_OUTPUTDIRECTORY_PROPERTY_VALUE);
    }

    protected LuaSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
        this.createPropertySet(LUA_PROPERTY_SET_KEY);
    }

    public boolean hasChildren() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        IAdapterManager manager = Platform.getAdapterManager();
        if (1 == manager.queryAdapter((Object)this, adapter.getName())) {
            return manager.loadAdapter((Object)this, adapter.getName());
        }
        return super.getAdapter(adapter);
    }

    public String getLuaCommand() {
        return this.getLuaPropertyValue(LUACOMMAND_PROPERTY_KEY);
    }

    public String getLuaPath() {
        return this.getLuaPropertyValue(LUAPATH_PROPERTY_KEY);
    }

    public String getCLuaPath() {
        return this.getLuaPropertyValue(LUACPATH_PROPERTY_KEY);
    }

    public String getLDLibraryPath() {
        return this.getLuaPropertyValue(LDLIBRARYPATH_PROPERTY_KEY);
    }

    public String getOutputDirectory() {
        return this.getLuaPropertyValue(OUTPUTDIRECTORY_PROPERTY_KEY);
    }

    public void setLuaPropertyValue(String key, String value) {
        IPropertySet propertySet = this.getPropertySet(LUA_PROPERTY_SET_KEY);
        IProperty property = propertySet.getProperty(key);
        if (property == null) {
            propertySet.addProperty(key, value, PropertyType.getStringPropertyType());
            this.commit();
        } else {
            property.setValue(value);
            this.commit();
        }
    }

    public String getLuaPropertyValue(String key) {
        String propertyValue;
        IRSESystemType systemType;
        String propertyValue2;
        IPropertySet propertySet = this.getPropertySet(LUA_PROPERTY_SET_KEY);
        if (propertySet != null && (propertyValue2 = propertySet.getPropertyValue(key)) != null) {
            return propertyValue2;
        }
        IHost host = this.getHost();
        if (host != null && (systemType = host.getSystemType()) != null && (propertyValue = systemType.getProperty(key)) != null) {
            return propertyValue;
        }
        String propertyValue3 = DEFAULT_PROPERTY_SET.getPropertyValue(key);
        if (propertyValue3 != null) {
            return propertyValue3;
        }
        return "";
    }
}

