/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.LazyDownloadJob;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class SystemViewDataDragAdapter
extends DragSourceAdapter {
    ISelectionProvider _selectionProvider;
    private ISelection _selection = null;
    public static final char CONNECTION_DELIMITER = ':';
    public static final char RESOURCE_SEPARATOR = '|';

    public SystemViewDataDragAdapter(ISelectionProvider provider) {
        this._selectionProvider = provider;
    }

    public void dragFinished(DragSourceEvent event) {
        this._selection = null;
        if (!event.doit) {
            return;
        }
    }

    private void serializeObject(Object dragObject, ISystemDragDropAdapter adapter, StringBuffer dataStream) {
        ISubSystem subSystem = null;
        if (dragObject instanceof ISubSystem) {
            subSystem = (ISubSystem)dragObject;
            String subSystemId = RSECorePlugin.getTheSystemRegistry().getAbsoluteNameForSubSystem(subSystem);
            dataStream.append(subSystemId);
        } else if (dragObject instanceof IHost) {
            IHost connection = (IHost)dragObject;
            String connectionId = RSECorePlugin.getTheSystemRegistry().getAbsoluteNameForConnection(connection);
            dataStream.append(connectionId);
        } else {
            subSystem = adapter.getSubSystem(dragObject);
            if (subSystem != null) {
                String subSystemId = RSECorePlugin.getTheSystemRegistry().getAbsoluteNameForSubSystem(subSystem);
                dataStream.append(subSystemId);
            }
            String objectId = adapter.getAbsoluteName(dragObject);
            dataStream.append(":");
            dataStream.append(objectId);
        }
    }

    public void dragStart(DragSourceEvent event) {
        this._selection = this._selectionProvider.getSelection();
        if (this._selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)this._selection;
            for (Object dragObject : ss) {
                if (dragObject instanceof IAdaptable) {
                    ISystemDragDropAdapter adapter = (ISystemDragDropAdapter)((IAdaptable)dragObject).getAdapter(ISystemDragDropAdapter.class);
                    if (adapter == null || !adapter.canDrag(dragObject)) {
                        event.doit = false;
                        event.detail = 0;
                        continue;
                    }
                    if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                        if (!(adapter instanceof ISystemRemoteElementAdapter)) continue;
                        if (((ISystemRemoteElementAdapter)adapter).canEdit(dragObject)) {
                            event.doit = true;
                            continue;
                        }
                        event.doit = false;
                        event.detail = 0;
                        return;
                    }
                    event.doit = true;
                    event.detail = 1;
                    continue;
                }
                event.doit = false;
                event.detail = 0;
                return;
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (this._selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)this._selection;
            if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
                StringBuffer dataStream = new StringBuffer("");
                Iterator iterator = ss.iterator();
                while (iterator.hasNext()) {
                    ISystemDragDropAdapter adapter;
                    Object dragObject = iterator.next();
                    if (!(dragObject instanceof IAdaptable) || (adapter = (ISystemDragDropAdapter)((IAdaptable)dragObject).getAdapter(ISystemDragDropAdapter.class)) == null || !adapter.canDrag(dragObject)) continue;
                    this.serializeObject(dragObject, adapter, dataStream);
                    if (!iterator.hasNext()) continue;
                    dataStream.append('|');
                }
                byte[] bytes = null;
                try {
                    bytes = dataStream.toString().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bytes = dataStream.toString().getBytes();
                }
                PluginTransferData data = new PluginTransferData("org.eclipse.rse.ui.view.DropActions", bytes);
                event.data = data;
                if (dataStream.length() > 0) {
                    event.doit = true;
                    event.detail = 1;
                } else {
                    event.doit = false;
                    event.detail = 2000;
                }
            } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                String[] fileNames = new String[ss.size()];
                Iterator iterator = ss.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String fileName;
                    IResource resource;
                    ISystemViewElementAdapter adapter;
                    Object dragObject = iterator.next();
                    if (!(dragObject instanceof IAdaptable) || !(adapter = (ISystemViewElementAdapter)((IAdaptable)dragObject).getAdapter(ISystemViewElementAdapter.class)).canDrag(dragObject) || (resource = this.getResource((IAdaptable)dragObject)) == null) continue;
                    fileNames[i] = fileName = resource.getLocation().toOSString();
                    ++i;
                }
                if (i > 0) {
                    event.data = fileNames;
                }
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                String[] texts = new String[ss.size()];
                Iterator iterator = ss.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    ISystemViewElementAdapter adapter;
                    Object dragObject = iterator.next();
                    if (!(dragObject instanceof IAdaptable) || (adapter = (ISystemViewElementAdapter)((IAdaptable)dragObject).getAdapter(ISystemViewElementAdapter.class)) == null) continue;
                    texts[i] = adapter.getText(dragObject);
                    ++i;
                }
                if (i > 0) {
                    event.data = texts;
                }
            } else if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                EditorInputTransfer.EditorInputData[] inputData = new EditorInputTransfer.EditorInputData[ss.size()];
                Iterator iterator = ss.iterator();
                int i = 0;
                IEditorRegistry editRegistry = RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
                while (iterator.hasNext()) {
                    ISystemEditableRemoteObject editable;
                    ISystemRemoteElementAdapter adapter;
                    Object dragObject = iterator.next();
                    Object adapterObj = ((IAdaptable)dragObject).getAdapter(ISystemRemoteElementAdapter.class);
                    if (adapterObj == null || !(adapter = (ISystemRemoteElementAdapter)adapterObj).canEdit(dragObject) || (editable = adapter.getEditableRemoteObject(dragObject)) == null) continue;
                    try {
                        Shell shell = event.display.getActiveShell();
                        if (!editable.download(shell)) continue;
                        editable.addAsListener();
                        editable.setLocalResourceProperties();
                        IFile theFile = editable.getLocalResource();
                        IEditorDescriptor preferredEditor = editRegistry.getDefaultEditor(theFile.getName());
                        if (preferredEditor == null || preferredEditor.isOpenExternal()) {
                            preferredEditor = this.getDefaultTextEditor();
                        }
                        FileEditorInput fileInput = new FileEditorInput(theFile);
                        inputData[i] = EditorInputTransfer.createEditorInputData((String)preferredEditor.getId(), (IEditorInput)fileInput);
                        ++i;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (i > 0) {
                    event.data = inputData;
                } else {
                    event.data = new EditorInputTransfer.EditorInputData[0];
                    event.detail = 0;
                }
            }
        }
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    private IResource getResource(IAdaptable dragObject) {
        IFile resource = null;
        ISystemViewElementAdapter viewAdapter = (ISystemViewElementAdapter)dragObject.getAdapter(ISystemViewElementAdapter.class);
        ISystemRemoteElementAdapter remoteAdapter = (ISystemRemoteElementAdapter)dragObject.getAdapter(ISystemRemoteElementAdapter.class);
        if (remoteAdapter != null) {
            if (remoteAdapter.canEdit(dragObject)) {
                ISystemEditableRemoteObject editable = remoteAdapter.getEditableRemoteObject(dragObject);
                IFile file = editable.getLocalResource();
                if (!file.exists()) {
                    LazyDownloadJob job = new LazyDownloadJob(editable);
                    job.run((IProgressMonitor)new NullProgressMonitor());
                }
                resource = file;
            } else if (viewAdapter != null && viewAdapter.hasChildren(dragObject)) {
                IContainer parentFolder = null;
                Object[] children = viewAdapter.getChildren(dragObject, (IProgressMonitor)new NullProgressMonitor());
                int i = 0;
                while (i < children.length) {
                    IAdaptable child = (IAdaptable)children[i];
                    IResource childResource = this.getResource(child);
                    if (childResource != null && !(parentFolder = childResource.getParent()).exists()) {
                        try {
                            parentFolder.touch((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
                resource = parentFolder;
            }
        }
        return resource;
    }
}

