/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.util.Vector;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemPageCompleteListener;
import org.eclipse.rse.ui.ISystemVerifyListener;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.ISystemConnectionWizardErrorUpdater;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemBaseForm
implements Listener,
ISystemConnectionWizardErrorUpdater {
    private ISystemMessageLine msgLine;
    private Shell shell;
    private Object inputObject;
    private Object outputObject;
    private Vector pageCompleteListeners;
    private boolean complete;
    protected Vector verifyListeners;
    protected boolean alreadyNotified;

    public SystemBaseForm(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    public SystemBaseForm(Shell shell, ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
        this.shell = shell;
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    public ISystemMessageLine getMessageLine() {
        return this.msgLine;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setInputObject(Object inputObject) {
        this.inputObject = inputObject;
    }

    protected Object getInputObject() {
        return this.inputObject;
    }

    protected void setOutputObject(Object outputObject) {
        this.outputObject = outputObject;
    }

    public Object getOutputObject() {
        return this.outputObject;
    }

    public void handleEvent(Event evt) {
    }

    public void addPageCompleteListener(ISystemPageCompleteListener l) {
        if (this.pageCompleteListeners == null) {
            this.pageCompleteListeners = new Vector();
        }
        this.pageCompleteListeners.add(l);
    }

    public void removePageCompleteListener(ISystemPageCompleteListener l) {
        if (this.pageCompleteListeners != null) {
            this.pageCompleteListeners.remove(l);
        }
    }

    protected void setPageComplete(boolean complete) {
        this.complete = complete;
        if (this.pageCompleteListeners != null) {
            int idx = 0;
            while (idx < this.pageCompleteListeners.size()) {
                ISystemPageCompleteListener l = (ISystemPageCompleteListener)this.pageCompleteListeners.elementAt(idx);
                l.setPageComplete(complete);
                ++idx;
            }
        }
    }

    public boolean isPageComplete() {
        return this.complete;
    }

    public abstract Control createContents(Composite var1);

    protected void showErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            if (msg != null) {
                this.msgLine.setErrorMessage(msg);
            } else {
                this.msgLine.clearErrorMessage();
            }
        }
    }

    protected Label addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Label addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
        return filler;
    }

    protected Label addGrowableFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        filler.setLayoutData((Object)data);
        return filler;
    }

    public void addVerifyListener(ISystemVerifyListener l) {
        if (this.verifyListeners == null) {
            this.verifyListeners = new Vector();
        }
        this.verifyListeners.add(l);
    }

    protected void notifyVerifyListeners() {
        if (this.alreadyNotified) {
            return;
        }
        if (this.verifyListeners == null) {
            return;
        }
        this.alreadyNotified = true;
        int i = 0;
        while (i < this.verifyListeners.size()) {
            ((ISystemVerifyListener)this.verifyListeners.get(i)).handleVerifyComplete();
            ++i;
        }
        this.alreadyNotified = false;
    }

    public void removePageCompleteListener(ISystemVerifyListener l) {
        if (this.verifyListeners != null) {
            this.verifyListeners.remove(l);
        }
    }

    public String getTheErrorMessage() {
        return null;
    }
}

