/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkEditableTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    static final Hashtable Accessibles = new Hashtable(9);
    static final Hashtable Factories = new Hashtable(9);
    static final String SWT_TYPE_PREFIX = "SWTAccessible";
    static final String CHILD_TYPENAME = "Child";
    static final String FACTORY_TYPENAME = "SWTFactory";
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45, 62, 52, 1027, 1073};
    static final int[] editableTextRoles = new int[]{42, 46, 1054, 15};
    static final int[] hypertextRoles = new int[]{42, 30, 1054};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42, 23, 1054, 15};
    static final int[] tableRoles = new int[]{24, 35};
    static final int[] valueRoles = new int[]{3, 52, 48};
    static final Callback AtkActionCB_do_action = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_do_action", 2);
    static final Callback AtkActionCB_get_n_actions = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_get_n_actions", 1);
    static final Callback AtkActionCB_get_description = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_get_description", 2);
    static final Callback AtkActionCB_get_keybinding = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_get_keybinding", 2);
    static final Callback AtkActionCB_get_name = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_get_name", 2);
    static final Callback AtkComponentCB_get_extents = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_get_extents", 6);
    static final Callback AtkComponentCB_get_position = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_get_position", 4);
    static final Callback AtkComponentCB_get_size = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_get_size", 4);
    static final Callback AtkComponentCB_ref_accessible_at_point = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_ref_accessible_at_point", 4);
    static final Callback AtkEditableTextCB_set_run_attributes = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_set_run_attributes", 4);
    static final Callback AtkEditableTextCB_set_text_contents = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_set_text_contents", 2);
    static final Callback AtkEditableTextCB_insert_text = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_insert_text", 4);
    static final Callback AtkEditableTextCB_copy_text = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_copy_text", 3);
    static final Callback AtkEditableTextCB_cut_text = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_cut_text", 3);
    static final Callback AtkEditableTextCB_delete_text = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_delete_text", 3);
    static final Callback AtkEditableTextCB_paste_text = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkEditableText_paste_text", 2);
    static final Callback AtkHypertextCB_get_link = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkHypertext_get_link", 2);
    static final Callback AtkHypertextCB_get_n_links = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkHypertext_get_n_links", 1);
    static final Callback AtkHypertextCB_get_link_index = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkHypertext_get_link_index", 2);
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkObjectCB_get_attributes;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTableCB_ref_at;
    static final Callback AtkTableCB_get_index_at;
    static final Callback AtkTableCB_get_column_at_index;
    static final Callback AtkTableCB_get_row_at_index;
    static final Callback AtkTableCB_get_n_columns;
    static final Callback AtkTableCB_get_n_rows;
    static final Callback AtkTableCB_get_column_extent_at;
    static final Callback AtkTableCB_get_row_extent_at;
    static final Callback AtkTableCB_get_summary;
    static final Callback AtkTableCB_get_caption;
    static final Callback AtkTableCB_get_column_description;
    static final Callback AtkTableCB_get_row_description;
    static final Callback AtkTableCB_get_column_header;
    static final Callback AtkTableCB_get_row_header;
    static final Callback AtkTableCB_get_selected_columns;
    static final Callback AtkTableCB_get_selected_rows;
    static final Callback AtkTableCB_is_column_selected;
    static final Callback AtkTableCB_is_row_selected;
    static final Callback AtkTableCB_is_selected;
    static final Callback AtkTableCB_add_column_selection;
    static final Callback AtkTableCB_add_row_selection;
    static final Callback AtkTableCB_remove_column_selection;
    static final Callback AtkTableCB_remove_row_selection;
    static final Callback AtkTextCB_get_character_extents;
    static final Callback AtkTextCB_get_range_extents;
    static final Callback AtkTextCB_get_run_attributes;
    static final Callback AtkTextCB_get_offset_at_point;
    static final Callback AtkTextCB_add_selection;
    static final Callback AtkTextCB_remove_selection;
    static final Callback AtkTextCB_set_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_set_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback AtkTextCB_get_bounded_ranges;
    static final Callback AtkValueCB_get_current_value;
    static final Callback AtkValueCB_get_maximum_value;
    static final Callback AtkValueCB_get_minimum_value;
    static final Callback AtkValueCB_set_current_value;
    static final Callback GObjectClass_finalize;
    static final Callback AtkObjectFactoryCB_create_accessible;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitEditableTextIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTableIfaceCB;
    static final Callback InitTextIfaceCB;
    static final Callback InitValueIfaceCB;
    static final Callback GTypeInfo_base_init_factory;
    static final int ActionIfaceDefinition;
    static final int ComponentIfaceDefinition;
    static final int EditableTextIfaceDefinition;
    static final int HypertextIfaceDefinition;
    static final int SelectionIfaceDefinition;
    static final int TableIfaceDefinition;
    static final int TextIfaceDefinition;
    static final int ValueIfaceDefinition;
    static /* synthetic */ Class class$org$eclipse$swt$accessibility$AccessibleObject;
    static /* synthetic */ Class class$org$eclipse$swt$accessibility$AccessibleFactory;

    AccessibleFactory() {
    }

    private static Callback newCallback(Object object, String method, int argCount) {
        Callback callback = new Callback(object, method, argCount);
        if (callback.getAddress() == 0) {
            SWT.error(3);
        }
        return callback;
    }

    static String getTypeName(int type) {
        int typeName = OS.g_type_name(type);
        int widgetTypeNameLength = OS.strlen(typeName);
        byte[] buffer = new byte[widgetTypeNameLength];
        OS.memmove(buffer, typeName, widgetTypeNameLength);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    static int getParentType(int widgetType) {
        LONG type = null;
        while (widgetType != 0 && (type = (LONG)Factories.get(new LONG(widgetType))) == null) {
            widgetType = OS.g_type_parent(widgetType);
        }
        if (type == null) {
            return 0;
        }
        return type.value;
    }

    static int atkObjectFactory_create_accessible(int widget) {
        AccessibleObject object;
        Accessible accessible = (Accessible)Accessibles.get(new LONG(widget));
        if (accessible == null) {
            int result = OS.g_object_new(AccessibleFactory.getParentType(OS.G_OBJECT_TYPE(widget)), 0);
            ATK.atk_object_initialize(result, widget);
            return result;
        }
        if (accessible.accessibleObject != null) {
            return accessible.accessibleObject.handle;
        }
        int widgetType = OS.G_OBJECT_TYPE(widget);
        int parentType = AccessibleFactory.getParentType(widgetType);
        if (parentType == 0) {
            parentType = ATK.GTK_TYPE_ACCESSIBLE();
        }
        int type = AccessibleFactory.getType(AccessibleFactory.getTypeName(widgetType), accessible, parentType, -1);
        accessible.accessibleObject = object = new AccessibleObject(type, widget, accessible, false);
        accessible.addRelations();
        return object.handle;
    }

    static AccessibleObject createChildAccessible(Accessible accessible, int childId) {
        int childType = AccessibleFactory.getType(CHILD_TYPENAME, accessible, ATK.GTK_TYPE_ACCESSIBLE(), childId);
        return new AccessibleObject(childType, 0, accessible, true);
    }

    static void createAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        OS.gtk_widget_get_accessible(controlHandle);
    }

    static int getType(String widgetTypeName, Accessible accessible, int parentType, int childId) {
        byte[] nameBytes;
        int type;
        AccessibleControlEvent event = new AccessibleControlEvent(accessible);
        event.childID = childId;
        Vector listeners = accessible.accessibleControlListeners;
        int length = listeners.size();
        for (int i = 0; i < length; ++i) {
            AccessibleControlListener listener = (AccessibleControlListener)listeners.elementAt(i);
            listener.getRole(event);
        }
        boolean action = false;
        boolean editableText = false;
        boolean hypertext = false;
        boolean selection = false;
        boolean table = false;
        boolean text = false;
        boolean value = false;
        if (event.detail != 0) {
            int i;
            for (i = 0; i < actionRoles.length; ++i) {
                if (event.detail != actionRoles[i]) continue;
                action = true;
                break;
            }
            for (i = 0; i < editableTextRoles.length; ++i) {
                if (event.detail != editableTextRoles[i]) continue;
                editableText = true;
                break;
            }
            for (i = 0; i < hypertextRoles.length; ++i) {
                if (event.detail != hypertextRoles[i]) continue;
                hypertext = true;
                break;
            }
            for (i = 0; i < selectionRoles.length; ++i) {
                if (event.detail != selectionRoles[i]) continue;
                selection = true;
                break;
            }
            for (i = 0; i < tableRoles.length; ++i) {
                if (event.detail != tableRoles[i]) continue;
                table = true;
                break;
            }
            for (i = 0; i < textRoles.length; ++i) {
                if (event.detail != textRoles[i]) continue;
                text = true;
                break;
            }
            for (i = 0; i < valueRoles.length; ++i) {
                if (event.detail != valueRoles[i]) continue;
                value = true;
                break;
            }
        } else {
            value = true;
            text = true;
            table = true;
            selection = true;
            hypertext = true;
            editableText = true;
            action = true;
        }
        String swtTypeName = SWT_TYPE_PREFIX + widgetTypeName;
        if (action) {
            swtTypeName = swtTypeName + "Action";
        }
        if (editableText) {
            swtTypeName = swtTypeName + "EditableText";
        }
        if (hypertext) {
            swtTypeName = swtTypeName + "Hypertext";
        }
        if (selection) {
            swtTypeName = swtTypeName + "Selection";
        }
        if (table) {
            swtTypeName = swtTypeName + "Table";
        }
        if (text) {
            swtTypeName = swtTypeName + "Text";
        }
        if (value) {
            swtTypeName = swtTypeName + "Value";
        }
        if ((type = OS.g_type_from_name(nameBytes = Converter.wcsToMbcs(null, swtTypeName, true))) == 0) {
            if (AccessibleObject.DEBUG) {
                AccessibleObject.print("-->New Type=" + swtTypeName);
            }
            int queryPtr = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(parentType, queryPtr);
            GTypeQuery query = new GTypeQuery();
            OS.memmove(query, queryPtr, GTypeQuery.sizeof);
            OS.g_free(queryPtr);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            typeInfo.class_size = (short)query.class_size;
            typeInfo.instance_size = (short)query.instance_size;
            int definition = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(definition, typeInfo, GTypeInfo.sizeof);
            type = OS.g_type_register_static(parentType, nameBytes, definition, 0);
            OS.g_type_add_interface_static(type, ATK.ATK_TYPE_COMPONENT(), ComponentIfaceDefinition);
            if (action) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_ACTION(), ActionIfaceDefinition);
            }
            if (editableText) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_EDITABLE_TEXT(), EditableTextIfaceDefinition);
            }
            if (hypertext) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_HYPERTEXT(), HypertextIfaceDefinition);
            }
            if (selection) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_SELECTION(), SelectionIfaceDefinition);
            }
            if (table) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_TABLE(), TableIfaceDefinition);
            }
            if (text) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_TEXT(), TextIfaceDefinition);
            }
            if (value) {
                OS.g_type_add_interface_static(type, ATK.ATK_TYPE_VALUE(), ValueIfaceDefinition);
            }
        }
        return type;
    }

    static int gTypeInfo_base_init_factory(int klass) {
        AtkObjectFactoryClass objectClass = new AtkObjectFactoryClass();
        ATK.memmove(objectClass, klass);
        objectClass.create_accessible = AtkObjectFactoryCB_create_accessible.getAddress();
        ATK.memmove(klass, objectClass);
        return 0;
    }

    static int gTypeInfo_base_init_type(int klass) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, klass);
        objectClass.get_name = AtkObjectCB_get_name.getAddress();
        objectClass.get_description = AtkObjectCB_get_description.getAddress();
        objectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        objectClass.get_role = AtkObjectCB_get_role.getAddress();
        objectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        objectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        objectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        objectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        objectClass.get_attributes = AtkObjectCB_get_attributes.getAddress();
        int gObjectClass = OS.G_OBJECT_CLASS(klass);
        GObjectClass objectClassStruct = new GObjectClass();
        OS.memmove(objectClassStruct, gObjectClass);
        objectClassStruct.finalize = GObjectClass_finalize.getAddress();
        OS.memmove(gObjectClass, objectClassStruct);
        ATK.memmove(klass, objectClass);
        return 0;
    }

    static int initActionIfaceCB(int iface) {
        AtkActionIface inter = new AtkActionIface();
        ATK.memmove(inter, iface);
        inter.do_action = AtkActionCB_do_action.getAddress();
        inter.get_n_actions = AtkActionCB_get_n_actions.getAddress();
        inter.get_description = AtkActionCB_get_description.getAddress();
        inter.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        inter.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initComponentIfaceCB(int iface) {
        AtkComponentIface inter = new AtkComponentIface();
        ATK.memmove(inter, iface);
        inter.get_extents = AtkComponentCB_get_extents.getAddress();
        inter.get_position = AtkComponentCB_get_position.getAddress();
        inter.get_size = AtkComponentCB_get_size.getAddress();
        inter.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initEditableTextIfaceCB(int iface) {
        AtkEditableTextIface inter = new AtkEditableTextIface();
        ATK.memmove(inter, iface);
        inter.set_run_attributes = AtkEditableTextCB_set_run_attributes.getAddress();
        inter.set_text_contents = AtkEditableTextCB_set_text_contents.getAddress();
        inter.insert_text = AtkEditableTextCB_insert_text.getAddress();
        inter.copy_text = AtkEditableTextCB_copy_text.getAddress();
        inter.cut_text = AtkEditableTextCB_cut_text.getAddress();
        inter.delete_text = AtkEditableTextCB_delete_text.getAddress();
        inter.paste_text = AtkEditableTextCB_paste_text.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initHypertextIfaceCB(int iface) {
        AtkHypertextIface inter = new AtkHypertextIface();
        ATK.memmove(inter, iface);
        inter.get_link = AtkHypertextCB_get_link.getAddress();
        inter.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        inter.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initSelectionIfaceCB(int iface) {
        AtkSelectionIface inter = new AtkSelectionIface();
        ATK.memmove(inter, iface);
        inter.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        inter.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initTableIfaceCB(int iface) {
        AtkTableIface inter = new AtkTableIface();
        ATK.memmove(inter, iface);
        inter.ref_at = AtkTableCB_ref_at.getAddress();
        inter.get_index_at = AtkTableCB_get_index_at.getAddress();
        inter.get_column_at_index = AtkTableCB_get_column_at_index.getAddress();
        inter.get_row_at_index = AtkTableCB_get_row_at_index.getAddress();
        inter.get_n_columns = AtkTableCB_get_n_columns.getAddress();
        inter.get_n_rows = AtkTableCB_get_n_rows.getAddress();
        inter.get_column_extent_at = AtkTableCB_get_column_extent_at.getAddress();
        inter.get_row_extent_at = AtkTableCB_get_row_extent_at.getAddress();
        inter.get_caption = AtkTableCB_get_caption.getAddress();
        inter.get_summary = AtkTableCB_get_summary.getAddress();
        inter.get_column_description = AtkTableCB_get_column_description.getAddress();
        inter.get_row_description = AtkTableCB_get_row_description.getAddress();
        inter.get_column_header = AtkTableCB_get_column_header.getAddress();
        inter.get_row_header = AtkTableCB_get_row_header.getAddress();
        inter.get_selected_columns = AtkTableCB_get_selected_columns.getAddress();
        inter.get_selected_rows = AtkTableCB_get_selected_rows.getAddress();
        inter.is_column_selected = AtkTableCB_is_column_selected.getAddress();
        inter.is_row_selected = AtkTableCB_is_row_selected.getAddress();
        inter.is_selected = AtkTableCB_is_selected.getAddress();
        inter.add_column_selection = AtkTableCB_add_column_selection.getAddress();
        inter.add_row_selection = AtkTableCB_add_row_selection.getAddress();
        inter.remove_column_selection = AtkTableCB_remove_column_selection.getAddress();
        inter.remove_row_selection = AtkTableCB_remove_row_selection.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initTextIfaceCB(int iface) {
        AtkTextIface inter = new AtkTextIface();
        ATK.memmove(inter, iface);
        inter.get_range_extents = AtkTextCB_get_range_extents.getAddress();
        inter.get_character_extents = AtkTextCB_get_character_extents.getAddress();
        inter.get_run_attributes = AtkTextCB_get_run_attributes.getAddress();
        inter.get_offset_at_point = AtkTextCB_get_offset_at_point.getAddress();
        inter.add_selection = AtkTextCB_add_selection.getAddress();
        inter.remove_selection = AtkTextCB_remove_selection.getAddress();
        inter.set_selection = AtkTextCB_set_selection.getAddress();
        inter.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        inter.set_caret_offset = AtkTextCB_set_caret_offset.getAddress();
        inter.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        inter.get_character_count = AtkTextCB_get_character_count.getAddress();
        inter.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        inter.get_selection = AtkTextCB_get_selection.getAddress();
        inter.get_text = AtkTextCB_get_text.getAddress();
        inter.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        inter.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        inter.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        inter.get_bounded_ranges = AtkTextCB_get_bounded_ranges.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static int initValueIfaceCB(int iface) {
        AtkValueIface inter = new AtkValueIface();
        ATK.memmove(inter, iface);
        inter.get_current_value = AtkValueCB_get_current_value.getAddress();
        inter.get_maximum_value = AtkValueCB_get_maximum_value.getAddress();
        inter.get_minimum_value = AtkValueCB_get_minimum_value.getAddress();
        inter.set_current_value = AtkValueCB_set_current_value.getAddress();
        ATK.memmove(iface, inter);
        return 0;
    }

    static void registerAccessible(Accessible accessible) {
        int widget = accessible.getControlHandle();
        int widgetType = OS.G_OBJECT_TYPE(widget);
        int registry = ATK.atk_get_default_registry();
        int factory = ATK.atk_registry_get_factory(registry, widgetType);
        if (ATK.ATK_IS_NO_OP_OBJECT_FACTORY(factory)) {
            return;
        }
        String name = FACTORY_TYPENAME + AccessibleFactory.getTypeName(widgetType);
        byte[] factoryName = Converter.wcsToMbcs(null, name, true);
        if (OS.g_type_from_name(factoryName) == 0) {
            if (AccessibleObject.DEBUG) {
                AccessibleObject.print("-->New Factory=" + name);
            }
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_factory.getAddress();
            typeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            typeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            int info = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(info, typeInfo, GTypeInfo.sizeof);
            int swtFactoryType = OS.g_type_register_static(ATK.ATK_TYPE_OBJECT_FACTORY(), factoryName, info, 0);
            int parentType = ATK.atk_object_factory_get_accessible_type(factory);
            ATK.atk_registry_set_factory_type(registry, widgetType, swtFactoryType);
            Factories.put(new LONG(widgetType), new LONG(parentType));
        }
        if (AccessibleObject.DEBUG) {
            AccessibleObject.print("-->Register=" + accessible.control + " " + widget);
        }
        Accessibles.put(new LONG(widget), accessible);
    }

    static void unregisterAccessible(Accessible accessible) {
        int widget = accessible.getControlHandle();
        Accessibles.remove(new LONG(widget));
        if (AccessibleObject.DEBUG) {
            AccessibleObject.print("-->Deregister=" + accessible.control + " " + widget);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AtkObjectCB_get_name = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_name", 1);
        AtkObjectCB_get_description = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_description", 1);
        AtkObjectCB_get_n_children = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_n_children", 1);
        AtkObjectCB_get_role = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_role", 1);
        AtkObjectCB_get_parent = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_parent", 1);
        AtkObjectCB_ref_state_set = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_ref_state_set", 1);
        AtkObjectCB_get_index_in_parent = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_index_in_parent", 1);
        AtkObjectCB_ref_child = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_ref_child", 2);
        AtkObjectCB_get_attributes = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_attributes", 1);
        AtkSelectionCB_is_child_selected = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkSelection_is_child_selected", 2);
        AtkSelectionCB_ref_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkSelection_ref_selection", 2);
        AtkTableCB_ref_at = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_ref_at", 3);
        AtkTableCB_get_index_at = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_index_at", 3);
        AtkTableCB_get_column_at_index = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_column_at_index", 2);
        AtkTableCB_get_row_at_index = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_row_at_index", 2);
        AtkTableCB_get_n_columns = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_n_columns", 1);
        AtkTableCB_get_n_rows = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_n_rows", 1);
        AtkTableCB_get_column_extent_at = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_column_extent_at", 3);
        AtkTableCB_get_row_extent_at = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_row_extent_at", 3);
        AtkTableCB_get_caption = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_caption", 1);
        AtkTableCB_get_summary = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_summary", 1);
        AtkTableCB_get_column_description = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_column_description", 2);
        AtkTableCB_get_row_description = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_row_description", 2);
        AtkTableCB_get_column_header = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_column_header", 2);
        AtkTableCB_get_row_header = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_row_header", 2);
        AtkTableCB_get_selected_columns = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_selected_columns", 2);
        AtkTableCB_get_selected_rows = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_get_selected_rows", 2);
        AtkTableCB_is_column_selected = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_is_column_selected", 2);
        AtkTableCB_is_row_selected = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_is_row_selected", 2);
        AtkTableCB_is_selected = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_is_selected", 3);
        AtkTableCB_add_column_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_add_column_selection", 2);
        AtkTableCB_add_row_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_add_row_selection", 2);
        AtkTableCB_remove_column_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_remove_column_selection", 2);
        AtkTableCB_remove_row_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkTable_remove_row_selection", 2);
        AtkTextCB_get_character_extents = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_character_extents", 7);
        AtkTextCB_get_range_extents = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_range_extents", 5);
        AtkTextCB_get_run_attributes = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_run_attributes", 4);
        AtkTextCB_get_offset_at_point = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_offset_at_point", 4);
        AtkTextCB_add_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_add_selection", 3);
        AtkTextCB_remove_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_remove_selection", 2);
        AtkTextCB_set_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_set_selection", 4);
        AtkTextCB_get_caret_offset = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_caret_offset", 1);
        AtkTextCB_set_caret_offset = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_set_caret_offset", 2);
        AtkTextCB_get_n_selections = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_n_selections", 1);
        AtkTextCB_get_selection = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_selection", 4);
        AtkTextCB_get_text = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text", 3);
        AtkTextCB_get_text_after_offset = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text_after_offset", 5);
        AtkTextCB_get_text_at_offset = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text_at_offset", 5);
        AtkTextCB_get_text_before_offset = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text_before_offset", 5);
        AtkTextCB_get_character_at_offset = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_character_at_offset", 2);
        AtkTextCB_get_character_count = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_character_count", 1);
        AtkTextCB_get_bounded_ranges = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_bounded_ranges", 5);
        AtkValueCB_get_current_value = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkValue_get_current_value", 2);
        AtkValueCB_get_maximum_value = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkValue_get_maximum_value", 2);
        AtkValueCB_get_minimum_value = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkValue_get_minimum_value", 2);
        AtkValueCB_set_current_value = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkValue_set_current_value", 2);
        GObjectClass_finalize = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "gObjectClass_finalize", 1);
        GTypeInfo_base_init_type = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "gTypeInfo_base_init_type", 1);
        GTypeInfo_base_init_factory = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "gTypeInfo_base_init_factory", 1);
        AtkObjectFactoryCB_create_accessible = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "atkObjectFactory_create_accessible", 1);
        InitActionIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initActionIfaceCB", 1);
        GInterfaceInfo interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ActionIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitComponentIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initComponentIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ComponentIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitEditableTextIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initEditableTextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitEditableTextIfaceCB.getAddress();
        EditableTextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(EditableTextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitHypertextIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initHypertextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(HypertextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitSelectionIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initSelectionIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(SelectionIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitTableIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initTableIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTableIfaceCB.getAddress();
        TableIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TableIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitTextIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initTextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitValueIfaceCB = AccessibleFactory.newCallback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initValueIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitValueIfaceCB.getAddress();
        ValueIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ValueIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
    }
}

