/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.PromptDialog;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsIAuthInformation;
import org.eclipse.swt.internal.mozilla.nsIAuthPrompt2;
import org.eclipse.swt.internal.mozilla.nsIChannel;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.widgets.Shell;

class PromptAuth2 {
    XPCOMObject supports;
    XPCOMObject promptAuth;
    int refCount = 0;
    int parent;

    PromptAuth2() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public int method0(int[] args) {
                return PromptAuth2.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return PromptAuth2.this.AddRef();
            }

            public int method2(int[] args) {
                return PromptAuth2.this.Release();
            }
        };
        this.promptAuth = new XPCOMObject(new int[]{2, 0, 0, 4, 6}){

            public int method0(int[] args) {
                return PromptAuth2.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return PromptAuth2.this.AddRef();
            }

            public int method2(int[] args) {
                return PromptAuth2.this.Release();
            }

            public int method3(int[] args) {
                return PromptAuth2.this.PromptAuth(args[0], args[1], args[2], args[3]);
            }

            public int method4(int[] args) {
                return PromptAuth2.this.AsyncPromptAuth(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.promptAuth != null) {
            this.promptAuth.dispose();
            this.promptAuth = null;
        }
    }

    int getAddress() {
        return this.promptAuth.getAddress();
    }

    int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIAuthPrompt2.NS_IAUTHPROMPT2_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.promptAuth.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser() {
        if (this.parent == 0) {
            return null;
        }
        return Mozilla.getBrowser(this.parent);
    }

    void setParent(int aParent) {
        this.parent = aParent;
    }

    int PromptAuth(int aChannel, int level, int authInfo, int _retval) {
        int host;
        nsIURI nsURI;
        nsIAuthInformation auth = new nsIAuthInformation(authInfo);
        Browser browser = this.getBrowser();
        if (browser != null) {
            Mozilla mozilla = (Mozilla)browser.webBrowser;
            if (mozilla.authCount++ < 3) {
                for (int i = 0; i < mozilla.authenticationListeners.length; ++i) {
                    AuthenticationEvent event = new AuthenticationEvent(browser);
                    event.location = mozilla.lastNavigateURL;
                    mozilla.authenticationListeners[i].authenticate(event);
                    if (!event.doit) {
                        XPCOM.memmove(_retval, new boolean[]{false});
                        return 0;
                    }
                    if (event.user == null || event.password == null) continue;
                    nsEmbedString string = new nsEmbedString(event.user);
                    int rc = auth.SetUsername(string.getAddress());
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    string.dispose();
                    string = new nsEmbedString(event.password);
                    rc = auth.SetPassword(string.getAddress());
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    string.dispose();
                    XPCOM.memmove(_retval, new boolean[]{true});
                    return 0;
                }
            }
        }
        String checkLabel = null;
        boolean[] checkValue = new boolean[1];
        String[] userLabel = new String[1];
        String[] passLabel = new String[1];
        String title = SWT.getMessage("SWT_Authentication_Required");
        int ptr = XPCOM.nsEmbedString_new();
        int rc = auth.GetUsername(ptr);
        if (rc != 0) {
            SWT.error(rc);
        }
        int length = XPCOM.nsEmbedString_Length(ptr);
        int buffer = XPCOM.nsEmbedString_get(ptr);
        char[] chars = new char[length];
        XPCOM.memmove(chars, buffer, length * 2);
        userLabel[0] = new String(chars);
        XPCOM.nsEmbedString_delete(ptr);
        ptr = XPCOM.nsEmbedString_new();
        rc = auth.GetPassword(ptr);
        if (rc != 0) {
            SWT.error(rc);
        }
        length = XPCOM.nsEmbedString_Length(ptr);
        buffer = XPCOM.nsEmbedString_get(ptr);
        chars = new char[length];
        XPCOM.memmove(chars, buffer, length * 2);
        passLabel[0] = new String(chars);
        XPCOM.nsEmbedString_delete(ptr);
        ptr = XPCOM.nsEmbedString_new();
        rc = auth.GetRealm(ptr);
        if (rc != 0) {
            SWT.error(rc);
        }
        length = XPCOM.nsEmbedString_Length(ptr);
        buffer = XPCOM.nsEmbedString_get(ptr);
        chars = new char[length];
        XPCOM.memmove(chars, buffer, length * 2);
        String realm = new String(chars);
        XPCOM.nsEmbedString_delete(ptr);
        nsIChannel channel = new nsIChannel(aChannel);
        int[] uri = new int[1];
        rc = channel.GetURI(uri);
        if (rc != 0) {
            SWT.error(rc);
        }
        if (uri[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (nsURI = new nsIURI(uri[0])).GetHost(host = XPCOM.nsEmbedCString_new())) != 0) {
            SWT.error(rc);
        }
        length = XPCOM.nsEmbedCString_Length(host);
        buffer = XPCOM.nsEmbedCString_get(host);
        byte[] bytes = new byte[length];
        XPCOM.memmove(bytes, buffer, length);
        String hostString = new String(bytes);
        XPCOM.nsEmbedCString_delete(host);
        nsURI.Release();
        String message = realm.length() > 0 && hostString.length() > 0 ? Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{realm, hostString}) : "";
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog dialog = new PromptDialog(shell);
        boolean[] result = new boolean[1];
        dialog.promptUsernameAndPassword(title, message, checkLabel, userLabel, passLabel, checkValue, result);
        XPCOM.memmove(_retval, result);
        if (result[0]) {
            nsEmbedString string = new nsEmbedString(userLabel[0]);
            rc = auth.SetUsername(string.getAddress());
            if (rc != 0) {
                SWT.error(rc);
            }
            string.dispose();
            string = new nsEmbedString(passLabel[0]);
            rc = auth.SetPassword(string.getAddress());
            if (rc != 0) {
                SWT.error(rc);
            }
            string.dispose();
        }
        return 0;
    }

    int AsyncPromptAuth(int aChannel, int aCallback, int aContext, int level, int authInfo, int _retval) {
        return -2147467263;
    }
}

