/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.CommandElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class CommandProvider
extends QuickAccessProvider {
    private IEvaluationContext currentSnapshot;
    private Map idToElement;
    private IHandlerService handlerService;

    void setSnapshot(IEvaluationContext c) {
        this.reset();
        this.currentSnapshot = c;
    }

    public String getId() {
        return "org.eclipse.ui.commands";
    }

    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return (CommandElement)this.idToElement.get(id);
    }

    public QuickAccessElement[] getElements() {
        if (this.idToElement == null) {
            this.idToElement = new HashMap();
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Collection commandIds = commandService.getDefinedCommandIds();
            for (String currentCommandId : commandIds) {
                Command command = commandService.getCommand(currentCommandId);
                if (command == null || !command.isHandled() || !command.isEnabled()) continue;
                try {
                    Collection combinations = ParameterizedCommand.generateCombinations((Command)command);
                    for (ParameterizedCommand pc : combinations) {
                        String id = pc.serialize();
                        this.idToElement.put(id, new CommandElement(pc, id, this));
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.values().size()]);
    }

    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    public String getName() {
        return QuickAccessMessages.QuickAccess_Commands;
    }

    IHandlerService getHandlerService() {
        if (this.handlerService == null) {
            this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        }
        return this.handlerService;
    }

    IEvaluationContext getContextSnapshot() {
        return this.currentSnapshot;
    }

    protected void doReset() {
        this.idToElement = null;
        if (this.currentSnapshot instanceof ExpressionContext) {
            ((ExpressionContext)this.currentSnapshot).eclipseContext.dispose();
        }
        this.currentSnapshot = null;
    }
}

