/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.validators.core.AbstractValidator;
import org.eclipse.dltk.validators.core.IResourceValidator;
import org.eclipse.dltk.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalResourceWorker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalSourceModuleWorker;
import org.eclipse.dltk.validators.internal.externalchecker.core.Rule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalChecker
extends AbstractValidator {
    private static final String EXTENSIONS = "scriptPattrn";
    private static final String ARGUMENTS = "arguments";
    private static final String INTERPRETER_ENVIRONMENT_VARS = "interpreterEnvironmentVars";
    private static final String PATH_TAG = "path";
    private static final String ENVIRONMENT_ATTR = "environment";
    private static final String PATH_ATTR = "path";
    private String arguments = "%f";
    private Map<IEnvironment, String> paths;
    private List<Rule> rules = new ArrayList<Rule>();
    private String extensions = "*";
    private boolean passInterpreterEnvironmentVars;

    public void setCommand(Map<IEnvironment, String> command) {
        this.paths = command;
        this.fireChanged();
    }

    public void setRules(Vector<Rule> list) {
        this.rules.clear();
        this.rules.addAll(list);
        this.fireChanged();
    }

    public Map<IEnvironment, String> getCommand() {
        return this.paths;
    }

    public ExternalChecker(String id, String name, IValidatorType type) {
        super(id, name, type);
        this.paths = this.newEmptyPath();
    }

    private Map<IEnvironment, String> newEmptyPath() {
        HashMap<IEnvironment, String> result = new HashMap<IEnvironment, String>();
        IEnvironment[] environments = EnvironmentManager.getEnvironments();
        int i = 0;
        while (i < environments.length) {
            result.put(environments[i], "");
            ++i;
        }
        return result;
    }

    protected void load(Element element) {
        super.load(element);
        this.paths = this.newEmptyPath();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element elementNode;
            Node item = childNodes.item(i);
            if (item.getNodeType() == 1 && (elementNode = (Element)item).getTagName().equalsIgnoreCase("path")) {
                String environment = elementNode.getAttribute(ENVIRONMENT_ATTR);
                String path = elementNode.getAttribute("path");
                IEnvironment env = EnvironmentManager.getEnvironmentById((String)environment);
                if (env != null) {
                    this.paths.put(env, path);
                }
            }
            ++i;
        }
        this.arguments = element.getAttribute(ARGUMENTS);
        this.extensions = element.getAttribute(EXTENSIONS);
        this.passInterpreterEnvironmentVars = Boolean.valueOf(element.getAttribute(INTERPRETER_ENVIRONMENT_VARS));
        NodeList nodes = element.getChildNodes();
        this.rules.clear();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            if (nodes.item(i2).getNodeName() == "rule") {
                NamedNodeMap map = nodes.item(i2).getAttributes();
                String ruletext = map.getNamedItem("TEXT").getNodeValue();
                String ruletype = map.getNamedItem("TYPE").getNodeValue();
                Rule r = new Rule(ruletext, ruletype);
                this.rules.add(r);
            }
            ++i2;
        }
    }

    public void storeTo(Document doc, Element element) {
        super.storeTo(doc, element);
        element.setAttribute(ARGUMENTS, this.arguments);
        element.setAttribute(EXTENSIONS, this.extensions);
        element.setAttribute(INTERPRETER_ENVIRONMENT_VARS, Boolean.toString(this.passInterpreterEnvironmentVars));
        int i = 0;
        while (i < this.rules.size()) {
            Element elem = doc.createElement("rule");
            elem.setAttribute("TEXT", this.rules.get(i).getDescription());
            elem.setAttribute("TYPE", this.rules.get(i).getType());
            element.appendChild(elem);
            ++i;
        }
        for (IEnvironment env : this.paths.keySet()) {
            if (env == null) continue;
            Element elem = doc.createElement("path");
            elem.setAttribute(ENVIRONMENT_ATTR, env.getId());
            elem.setAttribute("path", this.paths.get(env));
            element.appendChild(elem);
        }
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
        this.fireChanged();
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setNewRule(Rule s) {
        this.rules.add(s);
    }

    public Rule getRule(int index) {
        if (index < this.rules.size()) {
            return this.rules.get(index);
        }
        return null;
    }

    public int getNRules() {
        return this.rules.size();
    }

    public boolean isValidatorValid(IScriptProject project) {
        IEnvironment environment = this.getEnvrironment(project);
        String path = this.paths.get(environment);
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        IFileHandle file = environment.getFile((IPath)new Path(path));
        return file.exists();
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String scriptPattern) {
        this.extensions = scriptPattern;
        this.fireChanged();
    }

    public boolean isPassInterpreterEnvironmentVars() {
        return this.passInterpreterEnvironmentVars;
    }

    public void setPassInterpreterEnvironmentVars(boolean useInterpreterEnvironmentVars) {
        this.passInterpreterEnvironmentVars = useInterpreterEnvironmentVars;
        this.fireChanged();
    }

    public Object getValidator(IScriptProject project, Class validatorType) {
        if (validatorType == IResourceValidator.class) {
            return new ExternalResourceWorker(this.getEnvrironment(project), this);
        }
        if (validatorType == ISourceModuleValidator.class) {
            return new ExternalSourceModuleWorker(this.getEnvrironment(project), this);
        }
        return null;
    }

    protected Object clone() {
        try {
            ExternalChecker clone = (ExternalChecker)((Object)super.clone());
            clone.paths = new HashMap<IEnvironment, String>(this.paths);
            clone.rules = new ArrayList<Rule>(this.rules);
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

