/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Parameter;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.completion.Messages;

public class LuaCompletionEngine
extends ScriptCompletionEngine {
    public void complete(IModuleSource module, int position, int k) {
        IModelElement modelElement = module.getModelElement();
        if (!(modelElement instanceof ISourceModule)) {
            Activator.logWarning("Unable to perform completion proposal. Module [" + module.getFileName() + "] has not source module associated.");
            return;
        }
        ISourceModule sourceModule = (ISourceModule)modelElement;
        String start = this.getWordStarting(module.getSourceContents(), position);
        this.requestor.beginReporting();
        if (start.contains(".") || start.contains(":")) {
            ArrayList<String> ids = new ArrayList<String>();
            Character lastOperator = this.getExpressionIdentifiers(start, ids);
            this.addFields(sourceModule, ids, position, lastOperator, start);
        } else {
            this.addLocalDeclarations(sourceModule, start, position);
            this.addGlobalDeclarations(sourceModule, start, position);
            this.addKeywords(start, position);
        }
    }

    private void addGlobalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        List globalvars = LuaASTUtils.getAllGlobalVarsDefinition((ISourceModule)sourceModule, (String)start);
        for (LuaASTUtils.Definition definition : globalvars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
        }
    }

    private void addKeywords(String start, int cursorPosition) {
        String[] keywords = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"};
        int j = 0;
        while (j < keywords.length) {
            if (start.isEmpty() || keywords[j].startsWith(start)) {
                this.createKeyWordProposal(keywords[j], cursorPosition - start.length(), cursorPosition);
            }
            ++j;
        }
    }

    private void addLocalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
        if (luaSourceRoot == null) {
            return;
        }
        Collection localVars = LuaASTUtils.getLocalVars((LuaSourceRoot)luaSourceRoot, (int)(cursorPosition - start.length()), (String)start);
        for (Item var : localVars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)sourceModule, (Item)var);
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
        }
    }

    private void addFields(ISourceModule initialSourceModule, List<String> ids, int position, Character lastOperator, String start) {
        LuaASTUtils.TypeResolution typeResolution;
        if (ids.size() < 2) {
            return;
        }
        String rootIdentifierName = ids.get(0);
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)initialSourceModule);
        Item rootItem = LuaASTUtils.getClosestLocalVar((LuaSourceRoot)luaSourceRoot, (String)rootIdentifierName, (int)(position - start.length()));
        ISourceModule itemSourceModule = initialSourceModule;
        if (rootItem == null) {
            LuaASTUtils.Definition globalVarDefinition = LuaASTUtils.getGlobalVarDefinition((ISourceModule)initialSourceModule, (String)rootIdentifierName);
            if (globalVarDefinition == null) {
                return;
            }
            rootItem = globalVarDefinition.getItem();
            itemSourceModule = globalVarDefinition.getModule();
        }
        if ((typeResolution = LuaASTUtils.resolveType((ISourceModule)itemSourceModule, (TypeRef)rootItem.getType())) == null || !(typeResolution.getTypeDef() instanceof RecordTypeDef)) {
            return;
        }
        LuaASTUtils.TypeResolution currentTypeResolution = typeResolution;
        RecordTypeDef currentRecordTypeDef = (RecordTypeDef)typeResolution.getTypeDef();
        ISourceModule currentSourceModule = typeResolution.getModule();
        int i = 1;
        while (i < ids.size() - 1) {
            String fieldname = ids.get(i);
            Item item = (Item)currentRecordTypeDef.getFields().get(fieldname);
            if (item == null) {
                return;
            }
            currentTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)item.getType());
            if (currentTypeResolution == null || !(currentTypeResolution.getTypeDef() instanceof RecordTypeDef)) {
                return;
            }
            currentRecordTypeDef = (RecordTypeDef)currentTypeResolution.getTypeDef();
            currentSourceModule = currentTypeResolution.getModule();
            ++i;
        }
        String fieldName = ids.get(ids.size() - 1);
        for (Map.Entry entry : currentRecordTypeDef.getFields().entrySet()) {
            LuaASTUtils.TypeResolution parameterTypeResolution;
            List parameters;
            LuaASTUtils.TypeResolution fieldTypeResolution;
            Item item = (Item)entry.getValue();
            boolean goodStart = item.getName().toLowerCase().startsWith(fieldName.toLowerCase());
            boolean nostart = fieldName.isEmpty();
            if (!goodStart && !nostart) continue;
            if (lastOperator.charValue() == '.') {
                this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, false);
                continue;
            }
            if (lastOperator.charValue() != ':' || (fieldTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)item.getType())) == null || !(fieldTypeResolution.getTypeDef() instanceof FunctionTypeDef) || (parameters = ((FunctionTypeDef)fieldTypeResolution.getTypeDef()).getParameters()).size() == 0) continue;
            Parameter firstParamter = (Parameter)parameters.get(0);
            if ("self".equals(firstParamter.getName()) && firstParamter.getType() == null) {
                this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, true);
            }
            if (!currentTypeResolution.equals((Object)(parameterTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)firstParamter.getType())))) continue;
            this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, true);
        }
    }

    private String getWordStarting(String content, int position) {
        if (position <= 0 || position > content.length()) {
            return "";
        }
        int currentPosition = position;
        int lastValidPosition = position;
        boolean lastCharIsIndex = false;
        boolean finish = false;
        do {
            boolean isIdentifierPart;
            char currentChar;
            boolean isInvokeChar = (currentChar = content.charAt(--currentPosition)) == ':';
            boolean isIndexChar = currentChar == '.';
            boolean bl = isIdentifierPart = Character.isLetterOrDigit(currentChar) || currentChar == '_';
            if (lastCharIsIndex && isIndexChar) {
                ++lastValidPosition;
                finish = true;
                continue;
            }
            if (isIdentifierPart || isIndexChar || isInvokeChar) {
                lastValidPosition = currentPosition;
                lastCharIsIndex = isIndexChar;
                continue;
            }
            finish = true;
        } while (!finish && currentPosition > 0);
        if (lastValidPosition >= position) {
            return "";
        }
        return content.substring(lastValidPosition, position);
    }

    private Character getExpressionIdentifiers(String composedId, List<String> result) {
        StringBuffer stringToParse = new StringBuffer(composedId);
        StringBuffer nextId = new StringBuffer();
        Character lastOperator = Character.valueOf('\u0000');
        int i = 0;
        while (i < stringToParse.length()) {
            Character character = Character.valueOf(stringToParse.charAt(i));
            if (character.charValue() != '.' && character.charValue() != ':') {
                nextId.append(character);
            } else {
                if (nextId.length() == 0) {
                    return null;
                }
                if (lastOperator.charValue() == ':' && character.charValue() == ':') {
                    return null;
                }
                lastOperator = character;
                result.add(nextId.toString());
                nextId = new StringBuffer();
            }
            ++i;
        }
        result.add(nextId.toString());
        return lastOperator;
    }

    private void createKeyWordProposal(String keyword, int startIndex, int endIndex) {
        CompletionProposal proposal = CompletionProposal.create((int)2, (int)0);
        proposal.setRelevance(1);
        proposal.setName(keyword);
        proposal.setCompletion(keyword);
        proposal.setReplaceRange(startIndex, endIndex);
        this.requestor.accept(proposal);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex) {
        this.createMemberProposal(member, startIndex, endIndex, false);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex, boolean invocation) {
        try {
            CompletionProposal proposal = null;
            if (member == null) {
                NullPointerException e = new NullPointerException("the given IMember is null");
                Activator.logWarning("Unable to perform completion", e);
                return;
            }
            switch (member.getElementType()) {
                case 9: {
                    proposal = CompletionProposal.create((int)5, (int)0);
                    IMethod method = (IMethod)member;
                    if (invocation) {
                        String[] parameterNames = method.getParameterNames();
                        if (parameterNames.length == 0) {
                            return;
                        }
                        String[] parameterNamesWithoutFirstOne = Arrays.copyOfRange(parameterNames, 1, parameterNames.length);
                        proposal.setParameterNames(parameterNamesWithoutFirstOne);
                        break;
                    }
                    proposal.setParameterNames(method.getParameterNames());
                    break;
                }
                case 8: {
                    proposal = CompletionProposal.create((int)1, (int)0);
                    break;
                }
                case 7: {
                    proposal = CompletionProposal.create((int)7, (int)0);
                    break;
                }
                default: {
                    return;
                }
            }
            proposal.setFlags(member.getFlags());
            proposal.setModelElement((IModelElement)member);
            proposal.setName(member.getElementName());
            proposal.setCompletion(member.getElementName());
            proposal.setReplaceRange(startIndex, endIndex);
            proposal.setRelevance(2);
            this.requestor.accept(proposal);
        }
        catch (ModelException e) {
            Activator.logWarning(Messages.LuaCompletionEngineProblemProcessingGlobals, e);
            return;
        }
    }
}

