/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;
    static final char[] EDIT = new char[]{'E', 'D', 'I', 'T', '\u0000'};
    static final char[] COMBOBOX = new char[]{'C', 'O', 'M', 'B', 'O', 'B', 'O', 'X', '\u0000'};
    static final char[] BUTTON = new char[]{'B', 'U', 'T', 'T', 'O', 'N', '\u0000'};
    static final char[] PROGRESS = new char[]{'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\u0000'};
    static final char[] SCROLLBAR = new char[]{'S', 'C', 'R', 'O', 'L', 'L', 'B', 'A', 'R', '\u0000'};
    static final char[] TAB = new char[]{'T', 'A', 'B', '\u0000'};
    static final char[] TRACKBAR = new char[]{'T', 'R', 'A', 'C', 'K', 'B', 'A', 'R', '\u0000'};
    static final char[] TOOLBAR = new char[]{'T', 'O', 'O', 'L', 'B', 'A', 'R', '\u0000'};
    static final char[] TREEVIEW = new char[]{'T', 'R', 'E', 'E', 'V', 'I', 'E', 'W', '\u0000'};

    Rectangle computeTrim(Theme theme, GC gc) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
    }

    void drawImage(Theme theme, Image image, GC gc, Rectangle bounds) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Rectangle rect = image.getBounds();
            gc.drawImage(image, 0, 0, rect.width, rect.height, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    void drawText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int hTheme = OS.OpenThemeData(0, this.getClassId());
            char[] chars = new char[text.length()];
            text.getChars(0, chars.length, chars, 0);
            int textFlags = 32;
            if ((flags & 0x10) != 0) {
                textFlags |= 0;
            }
            if ((flags & 0x100) != 0) {
                textFlags |= 1;
            }
            if ((flags & 0x40) != 0) {
                textFlags |= 2;
            }
            if ((flags & 0x20) != 0) {
                textFlags |= 0;
            }
            if ((flags & 0x80) != 0) {
                textFlags |= 8;
            }
            if ((flags & 0x200) != 0) {
                textFlags |= 4;
            }
            RECT rect = new RECT();
            rect.left = bounds.x;
            rect.right = bounds.x + bounds.width;
            rect.top = bounds.y;
            rect.bottom = bounds.y + bounds.height;
            int[] part = this.getPartId(0);
            int iPartId = part[0];
            int iStateId = part[1];
            OS.DrawThemeText(hTheme, gc.handle, iPartId, iStateId, chars, chars.length, textFlags, 0, rect);
            OS.CloseThemeData(hTheme);
        }
    }

    char[] getClassId() {
        return BUTTON;
    }

    int[] getPartId(int part) {
        return new int[]{0, 0};
    }

    Rectangle getBounds(int part, Rectangle bounds) {
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return -1;
    }

    Rectangle measureText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hTheme = OS.OpenThemeData(0, this.getClassId());
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        int textFlags = 0;
        if ((this.style & 0x4000) != 0) {
            textFlags |= 0;
        }
        if ((this.style & 0x1000000) != 0) {
            textFlags |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            textFlags |= 2;
        }
        RECT extent = new RECT();
        RECT rect = null;
        if (bounds != null) {
            rect = new RECT();
            rect.left = bounds.x;
            rect.right = bounds.x + bounds.width;
            rect.top = bounds.y;
            rect.bottom = bounds.y + bounds.height;
        }
        int[] part = this.getPartId(0);
        int iPartId = part[0];
        int iStateId = part[1];
        OS.GetThemeTextExtent(hTheme, gc.handle, iPartId, iStateId, chars, chars.length, textFlags, rect, extent);
        OS.CloseThemeData(hTheme);
        return new Rectangle(extent.left, extent.top, extent.right - extent.left, extent.bottom - extent.top);
    }
}

