/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.internal.theme;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.widgets.Display;

public class ThemeEngineManager
implements IThemeManager {
    private static final String KEY = "org.eclipse.e4.ui.css.swt.theme";

    public IThemeEngine getEngineForDisplay(Display display) {
        IThemeEngine engine = (IThemeEngine)display.getData(KEY);
        if (engine == null) {
            engine = new ThemeEngine(display);
            engine.addCSSEngine(this.getCSSSWTEngine(display));
            display.setData(KEY, (Object)engine);
        }
        return engine;
    }

    private CSSEngine getCSSSWTEngine(Display display) {
        CSSEngine cssEngine = WidgetElement.getEngine((Display)display);
        if (cssEngine != null) {
            return cssEngine;
        }
        cssEngine = new CSSSWTEngineImpl(display, true);
        cssEngine.setErrorHandler(new CSSErrorHandler(){

            public void error(Exception e) {
                e.printStackTrace();
            }
        });
        WidgetElement.setEngine((Display)display, (CSSEngine)cssEngine);
        return cssEngine;
    }
}

