/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text;

import java.text.MessageFormat;
import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaHeuristicScanner;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class LuaBracketInserter
extends BracketInserter {
    private IPreferenceStore preferences;

    public LuaBracketInserter(ScriptEditor editor, IPreferenceStore preferenceStore) {
        super(editor);
        this.preferences = preferenceStore;
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ScriptEditor.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '(': 
            case '[': {
                if (this.isClosingBrackets()) break;
                return;
            }
            case '{': {
                if (this.isClosingBraces()) break;
                return;
            }
            case '\"': 
            case '\'': {
                if (this.isClosingStrings()) break;
                return;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            if (!this.editor.validateEditorInputState()) {
                return;
            }
            if (!LuaBracketInserter.validatePartitioning((IDocument)document, (int)offset, (String)"__lua_partitioning", (String[])new String[0])) {
                return;
            }
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            LuaHeuristicScanner scanner = new LuaHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            switch (event.character) {
                case '(': {
                    if (nextToken == 5) {
                        return;
                    }
                }
                case '[': 
                case '{': {
                    switch (nextToken) {
                        case 1: 
                        case 15: 
                        case 20: 
                        case 25: 
                        case 26: 
                        case 1021: 
                        case 1022: 
                        case 1023: 
                        case 1024: 
                        case 2000: {
                            return;
                        }
                    }
                    break;
                }
                case '\"': 
                case '\'': {
                    if (nextToken == 2000) {
                        return;
                    }
                    int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                    if (prevToken != 2000) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.insertBrackets(document, offset, length, event.character, LuaBracketInserter.getPeerCharacter((char)event.character));
        }
        catch (BadLocationException e) {
            Activator.logWarning((String)MessageFormat.format("Problem when trying to do autoclose for char {0}", Character.valueOf(event.character)), (Throwable)e);
            return;
        }
        catch (BadPositionCategoryException e) {
            Activator.logWarning((String)MessageFormat.format("Problem when trying to do autoclose for char {0}", Character.valueOf(event.character)), (Throwable)e);
            return;
        }
        event.doit = false;
    }

    private IPreferenceStore getPreferenceStore() {
        return this.preferences;
    }

    private boolean isClosingBrackets() {
        return this.getPreferenceStore().getBoolean("closeBrackets");
    }

    private boolean isClosingStrings() {
        return this.getPreferenceStore().getBoolean("closeStrings");
    }

    private boolean isClosingBraces() {
        return this.getPreferenceStore().getBoolean("closeBraces");
    }
}

