/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.buildpath;

import com.naef.jnlua.LuaException;
import com.naef.jnlua.LuaState;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathContainer;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.koneki.ldt.core.internal.buildpath.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public final class LuaExecutionEnvironmentManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.koneki.ldt.executionEnvironment";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_RESOURCEDIRECTORY = "resourcedirectory";
    private static final String MANIFEST_NAME = "package";
    private static final String MANIFEST_VERSION = "version";
    private static final String MANIFEST_TEMPLATES = "templates";
    private static final String INSTALLATION_FOLDER = "ee";

    private LuaExecutionEnvironmentManager() {
    }

    public static String check(LuaExecutionEnvironment ee) {
        if (!(ee.getTemplatesPath() == null || ee.getDefaultTemplatePath() != null && ee.getDefaultTemplatePath().toFile().exists())) {
            return NLS.bind((String)Messages.LuaExecutionEnvironmentManagerNoDefaultTemplate, (Object)ee.getEEIdentifier());
        }
        if (ee.getOldTemplatePath() != null) {
            return NLS.bind((String)Messages.LuaExecutionEnvironmentManagerLegacyTemplateFolder, (Object)ee.getEEIdentifier());
        }
        return null;
    }

    public static LuaExecutionEnvironment getExecutionEnvironmentFromCompressedFile(String filePath) throws CoreException {
        String manifestString;
        block17: {
            ZipFile zipFile = null;
            manifestString = null;
            try {
                try {
                    zipFile = new ZipFile(filePath);
                    Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                    while (zipEntries.hasMoreElements()) {
                        ZipEntry zipEntry = zipEntries.nextElement();
                        if (zipEntry.getName().contains("/") || !zipEntry.getName().endsWith(".rockspec")) continue;
                        if (manifestString != null) {
                            LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Invalid Execution Environment : more than one \"{0}\" file.", ".rockspec"), null, 4);
                        }
                        InputStream input = zipFile.getInputStream(zipEntry);
                        manifestString = IOUtils.toString((InputStream)input);
                    }
                }
                catch (IOException e) {
                    LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract manifest from zip file {0}", filePath), e, 4);
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning(MessageFormat.format("Unable to close zip file {0}", filePath), e2);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close zip file {0}", filePath), e);
                    }
                }
                throw throwable;
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close zip file {0}", filePath), e);
                }
            }
        }
        if (manifestString == null) {
            LuaExecutionEnvironmentManager.throwException(MessageFormat.format("No manifest \"{0}\" file found", ".rockspec"), null, 4);
        }
        return LuaExecutionEnvironmentManager.getLuaExecutionEnvironmentFromManifest(manifestString, null);
    }

    private static LuaExecutionEnvironment getExecutionEnvironmentFromDir(File executionEnvironmentDirectory) throws CoreException {
        String manifestString;
        block16: {
            if (!executionEnvironmentDirectory.exists() || !executionEnvironmentDirectory.isDirectory()) {
                return null;
            }
            manifestString = null;
            File[] manifests = executionEnvironmentDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".rockspec");
                }
            });
            if (manifests == null || manifests.length != 1) {
                String message = MessageFormat.format("0 or more than 1 \"{0}\" file in given file.", ".rockspec");
                LuaExecutionEnvironmentManager.throwException(message, null, 4);
            }
            InputStream manifestInputStream = null;
            try {
                try {
                    manifestInputStream = new FileInputStream(manifests[0]);
                    manifestString = IOUtils.toString((InputStream)manifestInputStream);
                }
                catch (IOException e) {
                    LuaExecutionEnvironmentManager.throwException("Unable to read manifest file.", e, 4);
                    if (manifestInputStream != null) {
                        try {
                            manifestInputStream.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", manifests[0]), e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (manifestInputStream != null) {
                    try {
                        manifestInputStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", manifests[0]), e);
                    }
                }
                throw throwable;
            }
            if (manifestInputStream != null) {
                try {
                    manifestInputStream.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", manifests[0]), e);
                }
            }
        }
        return LuaExecutionEnvironmentManager.getLuaExecutionEnvironmentFromManifest(manifestString, (IPath)new Path(executionEnvironmentDirectory.getPath()));
    }

    private static Map<?, ?> createJavaCopy(Map<?, ?> mapToCopy) {
        HashMap result = new HashMap();
        for (Map.Entry<?, ?> entry : mapToCopy.entrySet()) {
            Object key = entry.getKey();
            Map<?, ?> newKey = null;
            if (key instanceof String || key instanceof Number || key instanceof Character) {
                newKey = (Map<?, ?>)key;
            } else if (key instanceof Map) {
                newKey = LuaExecutionEnvironmentManager.createJavaCopy((Map)key);
            }
            Object value = entry.getValue();
            Map<?, ?> newValue = null;
            if (value instanceof String || value instanceof Number || value instanceof Character) {
                newValue = (Map<?, ?>)value;
            } else if (value instanceof Map) {
                newValue = LuaExecutionEnvironmentManager.createJavaCopy((Map)value);
            }
            if (newKey == null || newValue == null) {
                Activator.logWarning(MessageFormat.format("An execution environment contains invalid map in manifest : unexpected key/value {0}/{1}", key, value));
                continue;
            }
            result.put(newKey, newValue);
        }
        return result;
    }

    private static LuaExecutionEnvironment getLuaExecutionEnvironmentFromManifest(String manifestString, IPath installDirectory) throws CoreException {
        LuaState luaState = new LuaState();
        try {
            luaState.load(manifestString, "Lua error:");
            luaState.call(0, 0);
            luaState.getGlobal(MANIFEST_NAME);
            String name = luaState.toString(-1);
            luaState.getGlobal("version");
            String version = luaState.toString(-1);
            if (name == null || version == null) {
                LuaExecutionEnvironmentManager.throwException("Manifest from given file has no package name or version.", null, 4);
            }
            Map<?, ?> templates = null;
            luaState.getGlobal(MANIFEST_TEMPLATES);
            Map luatemplates = (Map)luaState.toJavaObject(-1, Map.class);
            if (luatemplates != null) {
                templates = LuaExecutionEnvironmentManager.createJavaCopy(luatemplates);
            }
            LuaExecutionEnvironment luaExecutionEnvironment = new LuaExecutionEnvironment(name, version, templates, installDirectory);
            return luaExecutionEnvironment;
        }
        catch (LuaException e) {
            luaState.close();
            LuaExecutionEnvironmentManager.throwException("Error while loading the manifest", e, 4);
        }
        catch (ClassCastException e) {
            LuaExecutionEnvironmentManager.throwException("Unable to parse the templates attribute in the EE manifest", e, 4);
        }
        finally {
            luaState.close();
        }
        return null;
    }

    private static LuaExecutionEnvironment getExecutionEnvironmentFromContribution(IConfigurationElement contribution) throws CoreException {
        String resourceDirectory = contribution.getAttribute(ATTRIBUTE_RESOURCEDIRECTORY);
        String contributor = contribution.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)contributor);
        if (bundle != null && resourceDirectory != null) {
            URL entry = bundle.getEntry(resourceDirectory);
            try {
                URL fileURL = FileLocator.toFileURL((URL)entry);
                File file = new File(fileURL.getFile());
                if (file.exists()) {
                    LuaExecutionEnvironment embeddedEE = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromDir(file);
                    embeddedEE.setEmbedded(true);
                    return embeddedEE;
                }
            }
            catch (IOException e) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract embedded execution environment from {0} - {1}", bundle, resourceDirectory), e, 4);
            }
            catch (CoreException e) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract embedded execution environment from {0} - {1}", bundle, resourceDirectory), e, 4);
            }
        }
        return null;
    }

    public static void uninstallLuaExecutionEnvironment(LuaExecutionEnvironment ee) throws CoreException {
        File eeInstallationDir;
        IPath pathToEE;
        if (ee == null) {
            LuaExecutionEnvironmentManager.throwException("No Execution Environment provided.", null, 4);
        }
        if (ee.isEmbedded()) {
            LuaExecutionEnvironmentManager.throwException("Embedded Execution Environment could not be uninstalled.", null, 4);
        }
        if ((pathToEE = ee.getPath()) == null) {
            LuaExecutionEnvironmentManager.throwException("The install path should not be null", null, 4);
        }
        if ((eeInstallationDir = pathToEE.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)eeInstallationDir);
                LuaExecutionEnvironmentManager.refreshDLTKModel(ee);
            }
            catch (IOException e) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to delete install directory : {0}", pathToEE.toOSString()), e, 4);
            }
        }
    }

    public static LuaExecutionEnvironment installLuaExecutionEnvironment(String zipPath) throws CoreException {
        LuaExecutionEnvironment ee;
        block44: {
            IPath eePath;
            File installDirectory;
            ee = null;
            ee = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromCompressedFile(zipPath);
            if (ee == null) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract execution environment information from {0}.", zipPath), null, 4);
            }
            if (LuaExecutionEnvironmentManager.getInstalledExecutionEnvironments().contains(ee)) {
                LuaExecutionEnvironmentManager.throwException("Execution environment is already installed.", null, 4);
            }
            if ((installDirectory = (eePath = LuaExecutionEnvironmentManager.getInstallDirectory().append(ee.getEEIdentifier())).toFile()).exists()) {
                if (installDirectory.isFile()) {
                    if (!installDirectory.delete()) {
                        LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to clean installation directory : {0}", eePath.toOSString()), null, 4);
                    }
                } else {
                    try {
                        FileUtils.deleteDirectory((File)installDirectory);
                    }
                    catch (IOException e) {
                        LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to clean installation directory : {0}", eePath.toOSString()), e, 4);
                    }
                }
            }
            if (!installDirectory.mkdirs()) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to create installation directory : {0}", eePath.toOSString()), null, 4);
            }
            ZipInputStream zipStream = null;
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(zipPath);
                    zipStream = new ZipInputStream(new BufferedInputStream(input));
                    ZipEntry entry = zipStream.getNextEntry();
                    while (entry != null) {
                        File outputFile = new File(installDirectory, entry.getName());
                        if (entry.isDirectory()) {
                            if (!outputFile.mkdir()) {
                                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to create install directory {0}", outputFile.toString()), null, 4);
                            }
                        } else {
                            FileOutputStream fileOutputStream = null;
                            try {
                                fileOutputStream = new FileOutputStream(outputFile);
                                IOUtils.copy((InputStream)zipStream, (OutputStream)fileOutputStream);
                                fileOutputStream.flush();
                            }
                            catch (Throwable throwable) {
                                if (fileOutputStream != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (IOException e) {
                                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", outputFile), e);
                                    }
                                }
                                throw throwable;
                            }
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException e) {
                                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", outputFile), e);
                                }
                            }
                        }
                        entry = zipStream.getNextEntry();
                    }
                }
                catch (IOException e) {
                    LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract zip file : {0}", zipPath), e, 4);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e2);
                        }
                    }
                    if (zipStream != null) {
                        try {
                            zipStream.close();
                        }
                        catch (IOException e3) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e3);
                        }
                    }
                    break block44;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                    }
                }
                if (zipStream != null) {
                    try {
                        zipStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                }
            }
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                }
            }
        }
        ee = LuaExecutionEnvironmentManager.getInstalledExecutionEnvironment(ee.getID(), ee.getVersion());
        LuaExecutionEnvironmentManager.refreshDLTKModel(ee);
        return ee;
    }

    private static IPath getInstallDirectory() {
        return Activator.getDefault().getStateLocation().append(INSTALLATION_FOLDER);
    }

    public static List<LuaExecutionEnvironment> getInstalledExecutionEnvironments() {
        ArrayList<LuaExecutionEnvironment> result = new ArrayList<LuaExecutionEnvironment>();
        IPath installDirectoryPath = LuaExecutionEnvironmentManager.getInstallDirectory();
        File installDirectory = installDirectoryPath.toFile();
        if (installDirectory.exists() && installDirectory.isDirectory()) {
            File[] content;
            File[] fileArray = content = installDirectory.listFiles();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                File executionEnvironmentDirectory = fileArray[n2];
                if (executionEnvironmentDirectory.exists() && executionEnvironmentDirectory.isDirectory()) {
                    try {
                        LuaExecutionEnvironment executionEnvironment = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromDir(executionEnvironmentDirectory);
                        if (executionEnvironment != null) {
                            result.add(executionEnvironment);
                        }
                    }
                    catch (CoreException e) {
                        Activator.logWarning(MessageFormat.format("Unable to extract execution environment from {0}", executionEnvironmentDirectory), e);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static List<LuaExecutionEnvironment> getEmbeddedExecutionEnvironments() {
        ArrayList<LuaExecutionEnvironment> result = new ArrayList<LuaExecutionEnvironment>();
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < contributions.length) {
            try {
                LuaExecutionEnvironment embeddedEE = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromContribution(contributions[i]);
                result.add(embeddedEE);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
            ++i;
        }
        return result;
    }

    public static List<LuaExecutionEnvironment> getAvailableExecutionEnvironments() {
        List<LuaExecutionEnvironment> availableExecutionEnvironments = LuaExecutionEnvironmentManager.getInstalledExecutionEnvironments();
        List<LuaExecutionEnvironment> embeddedExecutionEnvironments = LuaExecutionEnvironmentManager.getEmbeddedExecutionEnvironments();
        for (LuaExecutionEnvironment luaExecutionEnvironment : embeddedExecutionEnvironments) {
            if (availableExecutionEnvironments.contains(luaExecutionEnvironment)) continue;
            availableExecutionEnvironments.add(luaExecutionEnvironment);
        }
        return availableExecutionEnvironments;
    }

    private static IPath getLuaExecutionEnvironmentPath(String id, String version) {
        return LuaExecutionEnvironmentManager.getInstallDirectory().append(NLS.bind((String)"{0}-{1}", (Object)id, (Object)version));
    }

    public static LuaExecutionEnvironment getInstalledExecutionEnvironment(String name, String version) throws CoreException {
        IPath luaExecutionEnvironmentPath = LuaExecutionEnvironmentManager.getLuaExecutionEnvironmentPath(name, version);
        return LuaExecutionEnvironmentManager.getExecutionEnvironmentFromDir(luaExecutionEnvironmentPath.toFile());
    }

    public static LuaExecutionEnvironment getEmbeddedExecutionEnvironment(String name, String version) throws CoreException {
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < contributions.length) {
            LuaExecutionEnvironment embeddedEE;
            String embeddedID = contributions[i].getAttribute(ATTRIBUTE_ID);
            String embeddedVersion = contributions[i].getAttribute("version");
            if (name != null && name.equals(embeddedID) && version != null && version.equals(embeddedVersion) && (embeddedEE = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromContribution(contributions[i])) != null) {
                return embeddedEE;
            }
            ++i;
        }
        return null;
    }

    public static LuaExecutionEnvironment getAvailableExecutionEnvironment(String name, String version) throws CoreException {
        LuaExecutionEnvironment ee = LuaExecutionEnvironmentManager.getInstalledExecutionEnvironment(name, version);
        if (ee != null) {
            return ee;
        }
        return LuaExecutionEnvironmentManager.getEmbeddedExecutionEnvironment(name, version);
    }

    private static void refreshDLTKModel(LuaExecutionEnvironment ee) {
        try {
            IPath containerPath = LuaExecutionEnvironmentBuildpathUtil.getLuaExecutionEnvironmentContainerPath(ee);
            IScriptProject[] scriptProjects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
            ArrayList<IScriptProject> affectedProjects = new ArrayList<IScriptProject>();
            int i = 0;
            while (i < scriptProjects.length) {
                IScriptProject scriptProject = scriptProjects[i];
                IBuildpathEntry[] entries = scriptProject.getRawBuildpath();
                int j = 0;
                while (j < entries.length) {
                    IBuildpathEntry entry = entries[j];
                    if (entry.getEntryKind() == 5 && containerPath.equals((Object)entry.getPath())) {
                        affectedProjects.add(scriptProject);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            int length = affectedProjects.size();
            if (length == 0) {
                return;
            }
            IScriptProject[] projects = new IScriptProject[length];
            affectedProjects.toArray(projects);
            IBuildpathContainer[] containers = new IBuildpathContainer[length];
            if (ee != null) {
                LuaExecutionEnvironmentBuildpathContainer container = new LuaExecutionEnvironmentBuildpathContainer(ee.getID(), ee.getVersion(), containerPath);
                int i2 = 0;
                while (i2 < length) {
                    containers[i2] = container;
                    ++i2;
                }
            }
            DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])projects, (IBuildpathContainer[])containers, null);
        }
        catch (ModelException e) {
            Activator.logError("Unable to refresh Model after Execution Environment change.", e);
        }
    }

    private static void throwException(String message, Throwable t, int severity) throws CoreException {
        throw new CoreException((IStatus)new Status(severity, "org.eclipse.koneki.ldt", message, t));
    }
}

