/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.terminals.core;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.terminals.AbstractDelegatingTerminalService;
import org.eclipse.rse.services.terminals.ITerminalService;

public class DelegatingTerminalService
extends AbstractDelegatingTerminalService {
    private IHost _host;
    private ITerminalService _realService;

    public DelegatingTerminalService(IHost host) {
        this._host = host;
    }

    public ITerminalService getRealTerminalService() {
        ISubSystem[] subSystems;
        if (this._host != null && this._realService == null && (subSystems = this._host.getSubSystems()) != null) {
            int i = 0;
            while (i < subSystems.length && this._realService == null) {
                ITerminalService tsvc;
                ISubSystem subsys = subSystems[i];
                IService svc = subsys.getSubSystemConfiguration().getService(this._host);
                if (svc != null && (tsvc = (ITerminalService)svc.getAdapter(ITerminalService.class)) != null && tsvc != this) {
                    this._realService = tsvc;
                }
                ++i;
            }
        }
        return this._realService;
    }
}

