/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native int getAWTHandle(Object var0);

    static final native void setDebug(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        OS.gdk_error_trap_push();
        try {
            Class[] emptyClass = new Class[]{};
            Object[] emptyObject = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", emptyClass);
            if (method != null) {
                method.invoke(clazz, emptyObject);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        int handle = parent.embeddedHandle;
        Class<?> clazz = null;
        try {
            String className = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.X11.XEmbeddedFrame";
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            SWT.error(20, e, " [need JDK 1.5 or greater]");
        }
        SWT_AWT.initializeSwing();
        Object value = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            value = constructor.newInstance(new Integer(handle), Boolean.TRUE);
        }
        catch (Throwable throwable) {
            try {
                constructor = clazz.getConstructor(Long.TYPE, Boolean.TYPE);
                value = constructor.newInstance(new Long(handle), Boolean.TRUE);
            }
            catch (Throwable e2) {
                SWT.error(20, e2);
            }
        }
        final Frame frame = value;
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        if (Device.DEBUG) {
            SWT_AWT.loadLibrary();
            SWT_AWT.setDebug(frame, true);
        }
        try {
            Method method = clazz.getMethod("registerListeners", null);
            if (method != null) {
                method.invoke(value, null);
            }
        }
        catch (Throwable throwable) {}
        final AWTEventListener awtListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                Window window;
                if (event.getID() == 200 && (window = (Window)event.getSource()).getParent() == frame) {
                    parent.getDisplay().asyncExec(new Runnable(this, parent, window){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Composite val$parent;
                        private final /* synthetic */ Window val$window;
                        {
                            this.this$1 = var1_1;
                            this.val$parent = composite;
                            this.val$window = window;
                        }

                        public void run() {
                            if (this.val$parent.isDisposed()) {
                                return;
                            }
                            Shell shell = this.val$parent.getShell();
                            SWT_AWT.loadLibrary();
                            int awtHandle = SWT_AWT.getAWTHandle(this.val$window);
                            if (awtHandle == 0) {
                                return;
                            }
                            int xWindow = OS.GTK3 ? OS.gdk_x11_window_get_xid(OS.gtk_widget_get_window(shell.handle)) : (OS.GTK_VERSION >= OS.VERSION(2, 14, 0) ? OS.gdk_x11_drawable_get_xid(OS.gtk_widget_get_window(OS.gtk_widget_get_toplevel(shell.handle))) : OS.gdk_x11_drawable_get_xid(OS.GTK_WIDGET_WINDOW(OS.gtk_widget_get_toplevel(shell.handle))));
                            OS.XSetTransientForHint(OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default()), awtHandle, xWindow);
                        }
                    });
                }
            }
        };
        frame.getToolkit().addAWTEventListener(awtListener, 64L);
        final Listener shellListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        Shell shell = parent.getShell();
                        shell.removeListener(20, shellListener);
                        shell.removeListener(19, shellListener);
                        parent.setVisible(false);
                        EventQueue.invokeLater(new Runnable(this, frame, awtListener){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ Frame val$frame;
                            private final /* synthetic */ AWTEventListener val$awtListener;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                                this.val$awtListener = aWTEventListener;
                            }

                            public void run() {
                                this.val$frame.getToolkit().removeAWTEventListener(this.val$awtListener);
                                this.val$frame.dispose();
                            }
                        });
                        break;
                    }
                    case 11: {
                        if (Library.JAVA_VERSION < Library.JAVA_VERSION(1, 6, 0)) break;
                        Rectangle clientArea = parent.getClientArea();
                        EventQueue.invokeLater(new Runnable(this, frame, clientArea){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ Frame val$frame;
                            private final /* synthetic */ Rectangle val$clientArea;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                                this.val$clientArea = rectangle;
                            }

                            public void run() {
                                ((Component)this.val$frame).setSize(this.val$clientArea.width, this.val$clientArea.height);
                            }
                        });
                    }
                }
            }
        };
        parent.addListener(12, listener);
        parent.addListener(11, listener);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (parent.isDisposed()) {
                    return;
                }
                Rectangle clientArea = parent.getClientArea();
                EventQueue.invokeLater(new Runnable(this, frame, clientArea){
                    final /* synthetic */ 9 this$1;
                    private final /* synthetic */ Frame val$frame;
                    private final /* synthetic */ Rectangle val$clientArea;
                    {
                        this.this$1 = var1_1;
                        this.val$frame = frame;
                        this.val$clientArea = rectangle;
                    }

                    public void run() {
                        ((Component)this.val$frame).setSize(this.val$clientArea.width, this.val$clientArea.height);
                        this.val$frame.validate();
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        int handle = 0;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        if (handle == 0) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.gtk_new(display, handle);
        final ComponentAdapter listener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                display.syncExec(new Runnable(this, shell, parent){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ Canvas val$parent;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$parent = canvas;
                    }

                    public void run() {
                        if (this.val$shell.isDisposed()) {
                            return;
                        }
                        Dimension dim = this.val$parent.getSize();
                        this.val$shell.setSize(dim.width, dim.height);
                    }
                });
            }
        };
        parent.addComponentListener(listener);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                parent.removeComponentListener(listener);
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

