/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    private static final String TEXT_UNICODE = "text/unicode";
    private static final String TEXT_XMOZURL = "text/x-moz-url";
    private static final int TEXT_UNICODE_ID = Transfer.registerType("text/unicode");
    private static final int TEXT_XMOZURL_ID = Transfer.registerType("text/x-moz-url");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int charCount = string.length();
        char[] chars = new char[charCount + 1];
        string.getChars(0, charCount, chars, 0);
        int byteCount = chars.length * 2;
        int pValue = OS.g_malloc(byteCount);
        if (pValue == 0) {
            return;
        }
        C.memmove(pValue, chars, byteCount);
        transferData.length = byteCount;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int size = transferData.format * transferData.length / 8 / 2 * 2;
        if (size <= 0) {
            return null;
        }
        char[] chars = new char[size / 2];
        C.memmove(chars, transferData.pValue, size);
        String string = new String(chars);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected int[] getTypeIds() {
        return new int[]{TEXT_XMOZURL_ID, TEXT_UNICODE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TEXT_XMOZURL, TEXT_UNICODE};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

