/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.widgets;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;

public class ImageBasedFrame
extends Canvas {
    private Control framedControl;
    private boolean draggable = true;
    private boolean vertical = true;
    private int w1;
    private int w2;
    private int w3;
    private int h1;
    private int h2;
    private int h3;
    private Image imageCache;
    private Image handle;
    private int handleWidth;
    private int handleHeight;
    protected String id;

    public ImageBasedFrame(Composite parent, Control toWrap, boolean vertical, boolean draggable) {
        super(parent, 0);
        this.framedControl = toWrap;
        this.vertical = vertical;
        this.draggable = draggable;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageBasedFrame.this.drawFrame(e);
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                ImageBasedFrame frame = (ImageBasedFrame)event.widget;
                frame.setCursor(null);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Rectangle handleRect = ImageBasedFrame.this.getHandleRect();
                ImageBasedFrame frame = (ImageBasedFrame)e.widget;
                if (handleRect.contains(e.x, e.y)) {
                    frame.setCursor(frame.getDisplay().getSystemCursor(5));
                } else {
                    frame.setCursor(null);
                }
            }
        });
        toWrap.setParent((Composite)this);
        toWrap.pack(true);
        toWrap.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ImageBasedFrame.this.pack(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        if (vertical) {
            toWrap.setLocation(this.w1, this.h1 + this.handleHeight);
        } else {
            toWrap.setLocation(this.w1 + this.handleWidth, this.h1);
        }
        this.setSize(this.computeSize(-1, -1));
        if (toWrap instanceof ToolBar) {
            this.id = "TB";
        }
    }

    public Rectangle getHandleRect() {
        Rectangle handleRect = new Rectangle(0, 0, 0, 0);
        if (!this.draggable) {
            return handleRect;
        }
        if (this.vertical) {
            handleRect.x = this.w1;
            handleRect.y = this.h1;
            handleRect.width = this.framedControl.getSize().x;
            handleRect.height = this.handle.getBounds().height;
        } else {
            handleRect.x = this.w1;
            handleRect.y = this.h1;
            handleRect.width = this.handle.getBounds().width;
            handleRect.height = this.framedControl.getSize().y;
        }
        return handleRect;
    }

    public Point computeSize(int wHint, int hHint) {
        if (this.vertical) {
            int width = this.w1 + this.framedControl.getSize().x + this.w3;
            int height = this.h1 + this.handleHeight + this.framedControl.getSize().y + this.h3;
            return new Point(width, height);
        }
        int width = this.w1 + this.handleWidth + this.framedControl.getSize().x + this.w3;
        int height = this.h1 + this.framedControl.getSize().y + this.h3;
        return new Point(width, height);
    }

    protected void drawFrame(PaintEvent e) {
        Point inner = this.framedControl.getSize();
        int handleWidth = this.handle != null && !this.vertical ? this.handle.getBounds().width : 0;
        int handleHeight = this.handle != null && this.vertical ? this.handle.getBounds().height : 0;
        Rectangle srcRect = new Rectangle(0, 0, 0, 0);
        Rectangle dstRect = new Rectangle(0, 0, 0, 0);
        srcRect.x = 0;
        srcRect.y = 0;
        srcRect.width = this.w1;
        srcRect.height = this.h1;
        dstRect.x = 0;
        dstRect.y = 0;
        dstRect.width = this.w1;
        dstRect.height = this.h1;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        srcRect.x = this.w1;
        srcRect.y = 0;
        srcRect.width = this.w2;
        srcRect.height = this.h1;
        dstRect.x = this.w1;
        dstRect.y = 0;
        dstRect.width = inner.x + handleWidth;
        dstRect.height = this.h1;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        if (handleHeight > 0) {
            srcRect.x = 0;
            srcRect.y = 0;
            srcRect.width = this.handle.getBounds().width;
            srcRect.height = this.handle.getBounds().height;
            dstRect.x = this.w1;
            dstRect.y = this.h1;
            dstRect.width = inner.x;
            dstRect.height = handleHeight;
            e.gc.drawImage(this.handle, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        }
        srcRect.x = this.w1 + this.w2;
        srcRect.y = 0;
        srcRect.width = this.w3;
        srcRect.height = this.h1;
        dstRect.x = this.w1 + handleWidth + inner.x;
        dstRect.y = 0;
        dstRect.width = this.w3;
        dstRect.height = this.h3;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        srcRect.x = 0;
        srcRect.y = this.h1;
        srcRect.width = this.w1;
        srcRect.height = this.h2;
        dstRect.x = 0;
        dstRect.y = this.h1;
        dstRect.width = this.w1;
        dstRect.height = inner.y + handleHeight;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        if (handleWidth > 0) {
            srcRect.x = 0;
            srcRect.y = 0;
            srcRect.width = this.handle.getBounds().width;
            srcRect.height = this.handle.getBounds().height;
            dstRect.x = this.w1;
            dstRect.y = this.h1;
            dstRect.width = handleWidth;
            dstRect.height = inner.y;
            e.gc.drawImage(this.handle, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        }
        srcRect.x = this.w1 + this.w2;
        srcRect.y = this.h1;
        srcRect.width = this.w3;
        srcRect.height = this.h2;
        dstRect.x = this.w1 + handleWidth + inner.x;
        dstRect.y = this.h1;
        dstRect.width = this.w3;
        dstRect.height = inner.y + handleHeight;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        srcRect.x = 0;
        srcRect.y = this.h1 + this.h2;
        srcRect.width = this.w1;
        srcRect.height = this.h3;
        dstRect.x = 0;
        dstRect.y = this.h1 + handleHeight + inner.y;
        dstRect.width = this.w1;
        dstRect.height = this.h3;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        srcRect.x = this.w1;
        srcRect.y = this.h1 + this.h2;
        srcRect.width = this.w2;
        srcRect.height = this.h3;
        dstRect.x = this.w1;
        dstRect.y = this.h1 + handleHeight + inner.y;
        dstRect.width = handleWidth + inner.x;
        dstRect.height = this.h3;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        srcRect.x = this.w1 + this.w2;
        srcRect.y = this.h1 + this.h2;
        srcRect.width = this.w3;
        srcRect.height = this.h3;
        dstRect.x = this.w1 + handleWidth + inner.x;
        dstRect.y = this.h1 + handleHeight + inner.y;
        dstRect.width = this.w3;
        dstRect.height = this.h3;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
        srcRect.x = this.w1;
        srcRect.y = this.h1;
        srcRect.width = this.w2;
        srcRect.height = this.h2;
        dstRect.x = this.w1 + handleWidth;
        dstRect.y = this.h1 + handleHeight;
        dstRect.width = inner.x;
        dstRect.height = inner.y;
        e.gc.drawImage(this.imageCache, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x, dstRect.y, dstRect.width, dstRect.height);
    }

    public Image getImageCache() {
        return this.imageCache;
    }

    public Image getHandleImage() {
        return this.handle;
    }

    public void setImages(Image frameImage, Integer[] frameInts, Image handleImage) {
        if (frameImage != null) {
            this.imageCache = frameImage;
        }
        if (handleImage != null) {
            this.handle = handleImage;
        }
        if (frameInts != null) {
            this.w1 = frameInts[0];
            this.w2 = frameInts[1];
            this.h1 = frameInts[2];
            this.h2 = frameInts[3];
            this.w3 = this.imageCache.getBounds().width - (this.w1 + this.w2);
            this.h3 = this.imageCache.getBounds().height - (this.h1 + this.h2);
        }
        this.handleWidth = this.handle != null && !this.vertical ? this.handle.getBounds().width : 0;
        int n = this.handleHeight = this.handle != null && this.vertical ? this.handle.getBounds().height : 0;
        if (this.vertical) {
            this.framedControl.setLocation(this.w1, this.h1 + this.handleHeight);
        } else {
            this.framedControl.setLocation(this.w1 + this.handleWidth, this.h1);
        }
        this.setSize(this.computeSize(-1, -1));
    }
}

