/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.koneki.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Parameter;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Index;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.completion.Messages;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaHeuristicScanner;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaSymbols;

public class LuaCompletionEngine
extends ScriptCompletionEngine {
    public void complete(IModuleSource module, int position, int k) {
        IModelElement modelElement = module.getModelElement();
        if (!(modelElement instanceof ISourceModule)) {
            Activator.logWarning("Unable to perform completion proposal. Module [" + module.getFileName() + "] has not source module associated.");
            return;
        }
        ISourceModule sourceModule = (ISourceModule)modelElement;
        String sourceContent = module.getSourceContents();
        if (position <= 0 || Character.isWhitespace(sourceContent.charAt(position - 1))) {
            this.addLocalDeclarations(sourceModule, "", position);
            this.addGlobalDeclarations(sourceModule, "", position);
            this.addKeywords("", position);
            return;
        }
        Document document = new Document(sourceContent);
        LuaHeuristicScanner luaHeuristicScanner = new LuaHeuristicScanner((IDocument)document);
        int previousToken = luaHeuristicScanner.previousToken(position - 1, -2);
        if (LuaSymbols.isKeywords(previousToken)) {
            try {
                int start = Math.max(luaHeuristicScanner.getPosition(), 0);
                int end = position;
                String keyword = document.get(start, end - start).trim();
                this.addLocalDeclarations(sourceModule, keyword, position);
                this.addGlobalDeclarations(sourceModule, keyword, position);
                this.addKeywords(keyword, position);
            }
            catch (BadLocationException e) {
                Activator.logWarning("LuaCompletionEngine : Unable to extract keyword. ", e);
            }
            return;
        }
        LuaExpression luaExpression = luaHeuristicScanner.guessLuaExpression(position);
        this.requestor.beginReporting();
        if (luaExpression == null) {
            this.addLocalDeclarations(sourceModule, "", position);
            this.addGlobalDeclarations(sourceModule, "", position);
            this.addKeywords("", position);
        } else if (luaExpression instanceof Identifier) {
            Item definition = ((Identifier)luaExpression).getDefinition();
            String start = definition.getName();
            this.addLocalDeclarations(sourceModule, start, position);
            this.addGlobalDeclarations(sourceModule, start, position);
            this.addKeywords(start, position);
        } else if (luaExpression instanceof Index) {
            LuaExpression left = ((Index)luaExpression).getLeft();
            LuaASTUtils.TypeResolution resolveType = LuaASTUtils.resolveType((ISourceModule)sourceModule, (LuaExpression)left);
            String right = ((Index)luaExpression).getRight();
            this.addFields(resolveType, right, position);
        } else if (luaExpression instanceof Invoke) {
            LuaExpression record = ((Invoke)luaExpression).getRecord();
            LuaASTUtils.TypeResolution resolveType = LuaASTUtils.resolveType((ISourceModule)sourceModule, (LuaExpression)record);
            String right = ((Invoke)luaExpression).getFunctionName();
            if (luaExpression.isIncomplete()) {
                this.addInvocableFields(resolveType, right, position);
            }
        }
        this.requestor.endReporting();
    }

    private void addGlobalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        ArrayList globalvars = new ArrayList();
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule((ISourceModule)sourceModule);
        if (preloadedSourceModule != null) {
            globalvars.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition((ISourceModule)preloadedSourceModule, (String)start));
        }
        for (LuaASTUtils.Definition definition : globalvars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            List othersglobalvars = LuaASTUtils.getAllInternalGlobalVarsDefinition((ISourceModule)sourceModule, (String)start);
            othersglobalvars.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition((ISourceModule)sourceModule, (String)start));
            for (LuaASTUtils.Definition definition : othersglobalvars) {
                IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
                if (member == null) continue;
                this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition, false, 25);
            }
        }
    }

    private void addKeywords(String start, int cursorPosition) {
        String[] keywords = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"};
        int j = 0;
        while (j < keywords.length) {
            if (start.isEmpty() || keywords[j].startsWith(start)) {
                this.createKeyWordProposal(keywords[j], cursorPosition - start.length(), cursorPosition);
            }
            ++j;
        }
    }

    private void addLocalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
        if (luaSourceRoot == null) {
            return;
        }
        Collection localVars = LuaASTUtils.getLocalVars((LuaSourceRoot)luaSourceRoot, (int)(cursorPosition - start.length()), (String)start);
        for (Item var : localVars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)sourceModule, (Item)var);
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
        }
    }

    private void addFields(LuaASTUtils.TypeResolution recordTypeResolution, String fieldName, int position) {
        if (recordTypeResolution == null) {
            return;
        }
        if (recordTypeResolution.getTypeDef() instanceof RecordTypeDef) {
            RecordTypeDef currentRecordTypeDef = (RecordTypeDef)recordTypeResolution.getTypeDef();
            ISourceModule currentSourceModule = recordTypeResolution.getModule();
            for (Map.Entry entry : currentRecordTypeDef.getFields().entrySet()) {
                Item item = (Item)entry.getValue();
                boolean goodStart = item.getName().toLowerCase().startsWith(fieldName.toLowerCase());
                boolean nostart = fieldName.isEmpty();
                if (!goodStart && !nostart) continue;
                this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, false);
            }
        }
    }

    private void addInvocableFields(LuaASTUtils.TypeResolution recordTypeResolution, String fieldName, int position) {
        if (recordTypeResolution == null) {
            return;
        }
        if (recordTypeResolution.getTypeDef() instanceof RecordTypeDef) {
            RecordTypeDef currentRecordTypeDef = (RecordTypeDef)recordTypeResolution.getTypeDef();
            ISourceModule currentSourceModule = recordTypeResolution.getModule();
            for (Map.Entry entry : currentRecordTypeDef.getFields().entrySet()) {
                LuaASTUtils.TypeResolution parameterTypeResolution;
                List parameters;
                LuaASTUtils.TypeResolution fieldTypeResolution;
                Item item = (Item)entry.getValue();
                boolean goodStart = item.getName().toLowerCase().startsWith(fieldName.toLowerCase());
                boolean nostart = fieldName.isEmpty();
                if (!goodStart && !nostart || (fieldTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)item.getType())) == null || !(fieldTypeResolution.getTypeDef() instanceof FunctionTypeDef) || (parameters = ((FunctionTypeDef)fieldTypeResolution.getTypeDef()).getParameters()).size() == 0) continue;
                Parameter firstParamter = (Parameter)parameters.get(0);
                if ("self".equals(firstParamter.getName()) && firstParamter.getType() == null) {
                    this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, true);
                }
                if (!recordTypeResolution.equals((Object)(parameterTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)firstParamter.getType())))) continue;
                this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, true);
            }
        }
    }

    private void createKeyWordProposal(String keyword, int startIndex, int endIndex) {
        CompletionProposal proposal = CompletionProposal.create((int)2, (int)0);
        proposal.setRelevance(1);
        proposal.setName(keyword);
        proposal.setCompletion(keyword);
        proposal.setReplaceRange(startIndex, endIndex);
        this.requestor.accept(proposal);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex) {
        this.createMemberProposal(member, startIndex, endIndex, false);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex, boolean invocation) {
        this.createMemberProposal(member, startIndex, endIndex, invocation, 50);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex, boolean invocation, int relevance) {
        try {
            CompletionProposal proposal = null;
            if (member == null) {
                NullPointerException e = new NullPointerException("the given IMember is null");
                Activator.logWarning("Unable to perform completion", e);
                return;
            }
            switch (member.getElementType()) {
                case 9: {
                    proposal = CompletionProposal.create((int)5, (int)0);
                    IMethod method = (IMethod)member;
                    if (invocation) {
                        String[] parameterNames = method.getParameterNames();
                        if (parameterNames.length == 0) {
                            return;
                        }
                        String[] parameterNamesWithoutFirstOne = Arrays.copyOfRange(parameterNames, 1, parameterNames.length);
                        proposal.setParameterNames(parameterNamesWithoutFirstOne);
                        break;
                    }
                    proposal.setParameterNames(method.getParameterNames());
                    break;
                }
                case 8: {
                    proposal = CompletionProposal.create((int)1, (int)0);
                    break;
                }
                case 7: {
                    proposal = CompletionProposal.create((int)7, (int)0);
                    break;
                }
                default: {
                    return;
                }
            }
            proposal.setFlags(member.getFlags());
            proposal.setModelElement((IModelElement)member);
            proposal.setName(member.getElementName());
            proposal.setCompletion(member.getElementName());
            proposal.setReplaceRange(startIndex, endIndex);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
        }
        catch (ModelException e) {
            Activator.logWarning(Messages.LuaCompletionEngineProblemProcessingGlobals, e);
            return;
        }
    }
}

