/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security.preference;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityPlugin;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.internal.dstore.security.preference.UniversalSecurityPreferencePage;
import org.eclipse.rse.internal.dstore.security.preference.X509CertificateElement;
import org.eclipse.rse.internal.dstore.security.util.GridUtil;
import org.eclipse.rse.internal.dstore.security.util.StringModifier;
import org.eclipse.rse.internal.dstore.security.widgets.CertificateForm;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class NewCertDialog
extends SystemPromptDialog
implements Listener {
    private final UniversalSecurityPreferencePage page;
    private CertificateForm _certForm;
    private Certificate _certificate;
    private Shell _shell;

    public NewCertDialog(UniversalSecurityPreferencePage page, Shell shell) {
        super(shell, UniversalSecurityProperties.RESID_SECURITY_ADD_CERT_DLG_TITLE);
        this.page = page;
        this._shell = shell;
    }

    public Control getInitialFocusControl() {
        return this._certForm.getInitialFocusControl();
    }

    protected Control createInner(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        this._certForm = new CertificateForm(this._shell, this.getMessageLine());
        this._certForm.createContents(content);
        this._certForm.registerListener(this);
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getOkButton().setEnabled(false);
        return control;
    }

    protected boolean processOK() {
        try {
            this._certificate = this._certForm.loadCertificate(this.page._keyStore);
        }
        catch (FileNotFoundException e) {
            String text = UniversalSecurityProperties.RESID_SECURITY_KEY_IO_ERROR_;
            text = StringModifier.change(text, "%1", this._certForm.getPath());
            String msg = UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_LOAD_EXC_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        catch (IOException e) {
            String text = UniversalSecurityProperties.RESID_SECURITY_LOAD_IO_EXC_;
            text = StringModifier.change(text, "%1", this._certForm.getPath());
            text = StringModifier.change(text, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            String msg = UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_LOAD_EXC_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            String text = UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_EXC_;
            text = StringModifier.change(text, "%1", this._certForm.getPath());
            String msg = UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_LOAD_EXC_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            String text = UniversalSecurityProperties.RESID_SECURITY_KEY_STORE_ERROR_;
            text = StringModifier.change(text, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            String msg = UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_LOAD_EXC_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        if (this._certificate instanceof X509Certificate) {
            X509CertificateElement elem = new X509CertificateElement(this._certForm.getAliasName(), UniversalSecurityProperties.RESID_SECURITY_TRUSTED_CERTIFICATE, (X509Certificate)this._certificate);
            this.page._tableItems.add(elem);
        }
        return true;
    }

    public void handleEvent(Event e) {
        this.getButton(0).setEnabled(this._certForm.validateDialog());
    }

    public Certificate getCertificate() {
        return this._certificate;
    }
}

