/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class SystemFileActionUtility {
    static void openEditor(IFile localFile, boolean readOnly) throws PartInitException {
        IEditorDescriptor editorDescriptor = null;
        try {
            editorDescriptor = IDE.getEditorDescriptor((IFile)localFile);
        }
        catch (PartInitException e) {
            SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (editorDescriptor == null && PlatformUI.isWorkbenchRunning()) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            editorDescriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        ResourceAttributes attr = localFile.getResourceAttributes();
        if (attr != null) {
            attr.setReadOnly(readOnly);
            try {
                localFile.setResourceAttributes(attr);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String editorId = null;
        if (editorDescriptor != null) {
            editorId = editorDescriptor.getId();
        }
        IDE.setDefaultEditor((IFile)localFile, (String)editorId);
        if (!editorDescriptor.isOpenExternal()) {
            FileEditorInput finput = new FileEditorInput(localFile);
            if (editorDescriptor != null && editorDescriptor.isOpenExternal()) {
                ((WorkbenchPage)activePage).openEditorFromDescriptor((IEditorInput)new FileEditorInput(localFile), editorDescriptor, true, null);
            } else {
                activePage.openEditor((IEditorInput)finput, editorDescriptor.getId());
            }
            return;
        }
        SystemFileActionUtility.openSystemEditor(localFile);
    }

    static void openSystemEditor(IFile localFile) throws PartInitException {
        IEditorDescriptor editorDescriptor = null;
        try {
            editorDescriptor = IDE.getEditorDescriptor((IFile)localFile);
        }
        catch (PartInitException e) {
            SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (editorDescriptor == null && PlatformUI.isWorkbenchRunning()) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            editorDescriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        String editorId = null;
        if (editorDescriptor != null) {
            editorId = editorDescriptor.getId();
        }
        IDE.setDefaultEditor((IFile)localFile, (String)editorId);
        FileEditorInput fileInput = new FileEditorInput(localFile);
        activePage.openEditor((IEditorInput)fileInput, "org.eclipse.ui.systemExternalEditor");
    }

    public static void openInPlaceEditor(IFile localFile) throws PartInitException {
        IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        FileEditorInput fileInput = new FileEditorInput(localFile);
        activePage.openEditor((IEditorInput)fileInput, "org.eclipse.ui.systemInPlaceEditor");
    }

    public static void hackOpenEditor(IFile localFile, IEditorDescriptor descriptor, boolean readOnly) throws PartInitException {
        IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        ResourceAttributes attr = localFile.getResourceAttributes();
        if (attr != null) {
            attr.setReadOnly(readOnly);
            try {
                localFile.setResourceAttributes(attr);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String editorId = descriptor.getId();
        IDE.setDefaultEditor((IFile)localFile, (String)editorId);
        FileEditorInput finput = new FileEditorInput(localFile);
        if (descriptor.isOpenExternal()) {
            ((WorkbenchPage)activePage).openEditorFromDescriptor((IEditorInput)new FileEditorInput(localFile), descriptor, true, null);
        } else {
            activePage.openEditor((IEditorInput)finput, descriptor.getId());
        }
    }

    static IFile getProjectFileForLocation(String absolutePath) {
        Path workspacePath = new Path(absolutePath);
        IFile file = SystemBasePlugin.getWorkspaceRoot().getFileForLocation((IPath)workspacePath);
        return file;
    }
}

