/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2RGBColorImpl;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.ThemeElementDefinitionHelper;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;

public class CSSSWTColorHelper {
    public static final String COLOR_DEFINITION_MARKER = "#";
    private static final String HEX_COLOR_VALUE_PATTERN = "#[a-fA-F0-9]{6}";
    private static Field[] cachedFields;

    public static Color getSWTColor(RGBColor rgbColor, Display display) {
        RGB rgb = CSSSWTColorHelper.getRGB(rgbColor);
        return new Color((Device)display, rgb);
    }

    public static Color getSWTColor(CSSValue value, Display display) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        Color color = display.getSystemColor(2);
        RGB rgb = CSSSWTColorHelper.getRGB((CSSPrimitiveValue)value, display);
        if (rgb != null) {
            color = new Color((Device)display, rgb.red, rgb.green, rgb.blue);
        }
        return color;
    }

    private static RGB getRGB(CSSPrimitiveValue value, Display display) {
        RGB rgb = CSSSWTColorHelper.getRGB(value);
        if (rgb == null && display != null) {
            String name = value.getStringValue();
            if (CSSSWTColorHelper.hasColorDefinitionAsValue(name)) {
                rgb = CSSSWTColorHelper.findColorByDefinition(name);
            } else if (name.contains("-")) {
                name = name.replace('-', '_');
                rgb = CSSSWTColorHelper.process(display, name);
            }
        }
        return rgb;
    }

    public static boolean hasColorDefinitionAsValue(CSSValue value) {
        CSSPrimitiveValue primitiveValue;
        if (value.getCssValueType() == 1 && (primitiveValue = (CSSPrimitiveValue)value).getPrimitiveType() == 19) {
            return CSSSWTColorHelper.hasColorDefinitionAsValue(primitiveValue.getStringValue());
        }
        return false;
    }

    public static boolean hasColorDefinitionAsValue(String name) {
        if (name.startsWith(COLOR_DEFINITION_MARKER)) {
            return !name.matches(HEX_COLOR_VALUE_PATTERN);
        }
        return false;
    }

    private static RGB process(Display display, String value) {
        Field[] fields = CSSSWTColorHelper.getFields();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(value)) {
                    return display.getSystemColor(field.getInt(null)).getRGB();
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return display.getSystemColor(2).getRGB();
    }

    private static Field[] getFields() {
        if (cachedFields == null) {
            Class<SWT> clazz = SWT.class;
            Field[] allFields = clazz.getDeclaredFields();
            ArrayList<Field> applicableFields = new ArrayList<Field>(allFields.length);
            Field[] fieldArray = allFields;
            int n = allFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getName().startsWith("COLOR")) {
                    applicableFields.add(field);
                }
                ++n2;
            }
            cachedFields = applicableFields.toArray(new Field[applicableFields.size()]);
        }
        return cachedFields;
    }

    public static RGB getRGB(String name) {
        RGBColor color = CSS2ColorHelper.getRGBColor((String)name);
        if (color != null) {
            return CSSSWTColorHelper.getRGB(color);
        }
        return null;
    }

    public static RGB getRGB(RGBColor color) {
        return new RGB((int)color.getRed().getFloatValue((short)1), (int)color.getGreen().getFloatValue((short)1), (int)color.getBlue().getFloatValue((short)1));
    }

    public static RGB getRGB(CSSValue value) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        return CSSSWTColorHelper.getRGB((CSSPrimitiveValue)value);
    }

    public static RGB getRGB(CSSPrimitiveValue value) {
        RGB rgb = null;
        switch (value.getPrimitiveType()) {
            case 19: 
            case 21: {
                String string = value.getStringValue();
                rgb = CSSSWTColorHelper.getRGB(string);
                break;
            }
            case 25: {
                RGBColor rgbColor = value.getRGBColorValue();
                rgb = CSSSWTColorHelper.getRGB(rgbColor);
            }
        }
        return rgb;
    }

    public static Integer getPercent(CSSPrimitiveValue value) {
        int percent = 0;
        switch (value.getPrimitiveType()) {
            case 2: {
                percent = (int)value.getFloatValue((short)2);
            }
        }
        return new Integer(percent);
    }

    /*
     * Exception decompiling
     */
    public static Gradient getGradient(CSSValueList list, Display display) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Color[] getSWTColors(Gradient grad, Display display, CSSEngine engine) throws Exception {
        List values = grad.getValues();
        Color[] colors = new Color[values.size()];
        int i = 0;
        while (i < values.size()) {
            Color color;
            CSSPrimitiveValue value = (CSSPrimitiveValue)values.get(i);
            colors[i] = color = (Color)engine.convert((CSSValue)value, Color.class, (Object)display);
            ++i;
        }
        return colors;
    }

    public static int[] getPercents(Gradient grad) {
        if (grad.getRGBs().size() == grad.getPercents().size() + 1) {
            int[] percents = new int[grad.getPercents().size()];
            int i = 0;
            while (i < percents.length) {
                int value = (Integer)grad.getPercents().get(i);
                if (value < 0 || value > 100) {
                    return CSSSWTColorHelper.getDefaultPercents(grad);
                }
                percents[i] = value;
                ++i;
            }
            return percents;
        }
        return CSSSWTColorHelper.getDefaultPercents(grad);
    }

    private static int[] getDefaultPercents(Gradient grad) {
        if (grad.getRGBs().size() == 1) {
            return new int[0];
        }
        int[] percents = new int[grad.getRGBs().size() - 1];
        float increment = 100.0f / (float)(grad.getRGBs().size() - 1);
        int i = 0;
        while (i < percents.length) {
            percents[i] = Math.round((float)(i + 1) * increment);
            ++i;
        }
        return percents;
    }

    public static RGBColor getRGBColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new CSS2RGBColorImpl(red, green, blue);
    }

    public static RGBColor getRGBColor(RGB color) {
        int red = color.red;
        int green = color.green;
        int blue = color.blue;
        return new CSS2RGBColorImpl(red, green, blue);
    }

    private static RGB findColorByDefinition(String name) {
        IColorAndFontProvider provider = CSSActivator.getDefault().getColorAndFontProvider();
        if (provider != null) {
            return provider.getColor(ThemeElementDefinitionHelper.normalizeId(name.substring(1)));
        }
        return null;
    }
}

