/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.koneki.ldt.core.IProjectSourceRootFolderVisitor;
import org.eclipse.koneki.ldt.core.IProjectSourceRootFolderVisitor2;
import org.eclipse.koneki.ldt.core.IProjectSourceVisitor;
import org.eclipse.koneki.ldt.core.IProjectSourceVisitor2;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;

public final class LuaUtils {
    private LuaUtils() {
    }

    public static String getModuleName(ISourceModule module) {
        String moduleName = module.getElementName();
        if (moduleName.endsWith(".lua")) {
            moduleName = moduleName.replaceFirst("\\.lua$", "");
        } else if (moduleName.endsWith(".doclua")) {
            moduleName = moduleName.replaceFirst("\\.doclua$", "");
        }
        return moduleName;
    }

    public static String getModuleName(IModuleSource module) {
        IModelElement modelElement = module.getModelElement();
        if (modelElement instanceof ISourceModule) {
            return LuaUtils.getModuleName((ISourceModule)modelElement);
        }
        return module.getFileName();
    }

    public static String getModuleFullName(IModuleSource module) {
        IModelElement modelElement = module.getModelElement();
        if (modelElement instanceof ISourceModule) {
            return LuaUtils.getModuleFullName((ISourceModule)modelElement);
        }
        return module.getFileName();
    }

    public static String getModuleFullName(ISourceModule module) {
        IPath path = LuaUtils.getSourcePathRelativePath(module);
        String moduleName = LuaUtils.getModuleName(module);
        if ((path = path.removeLastSegments(1)).segmentCount() == 0 || !"init".equals(moduleName)) {
            path = path.append(moduleName);
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (fullNameBuilder.length() > 0) {
                fullNameBuilder.append(".");
            }
            fullNameBuilder.append(segment);
            ++n2;
        }
        return fullNameBuilder.toString();
    }

    public static IPath getSourcePathRelativePath(IModuleSource module) {
        IModelElement modelElement = module.getModelElement();
        if (modelElement instanceof ISourceModule) {
            return LuaUtils.getSourcePathRelativePath((ISourceModule)modelElement);
        }
        return new Path(module.getFileName());
    }

    public static IPath getSourcePathRelativePath(ISourceModule module) {
        String moduleName = module.getElementName();
        IPath prefix = null;
        if (module.getParent() instanceof IScriptFolder) {
            prefix = LuaUtils.getFolderSourcePathRelativePath((IScriptFolder)module.getParent());
        }
        if (prefix != null) {
            return prefix.append(moduleName);
        }
        return new Path(moduleName);
    }

    private static IPath getFolderSourcePathRelativePath(IScriptFolder folder) {
        if (!folder.isRootFolder()) {
            String folderName = folder.getElementName();
            IModelElement parent = folder.getParent();
            IPath prefix = null;
            if (parent instanceof IScriptFolder) {
                prefix = LuaUtils.getFolderSourcePathRelativePath((IScriptFolder)parent);
            }
            if (prefix != null) {
                return prefix.append(folderName);
            }
            return new Path(folderName);
        }
        return null;
    }

    public static IModuleSource getModuleSource(String name, IScriptProject project) {
        if (project == null && name == null || name.isEmpty()) {
            return null;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                IModuleSource moduleSource = LuaUtils.getModuleSource(name, (IParent)projectFragment);
                if (moduleSource != null) {
                    return moduleSource;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Activator.logError(MessageFormat.format("Unable to find module: {0}.", name), e);
            return null;
        }
        return null;
    }

    private static IModuleSource getModuleSource(String name, IParent parent) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleSource moduleSource;
            IModelElement child = iModelElementArray[n2];
            if (child instanceof IModuleSource) {
                if (name.equals(LuaUtils.getModuleFullName((IModuleSource)child))) {
                    return (IModuleSource)child;
                }
            } else if (child instanceof IParent && (moduleSource = LuaUtils.getModuleSource(name, (IParent)child)) != null) {
                return moduleSource;
            }
            ++n2;
        }
        return null;
    }

    public static ISourceModule getSourceModule(String name, IScriptProject project) {
        IModuleSource moduleSource = LuaUtils.getModuleSource(name, project);
        if (moduleSource instanceof ISourceModule) {
            return (ISourceModule)moduleSource;
        }
        return null;
    }

    public static IModuleSource getModuleSourceFromAbsoluteURI(URI absolutepath, IScriptProject project) {
        if (project == null || absolutepath == null) {
            return null;
        }
        ISourceModule sourceModule = LuaUtils.getSourceModuleFromAbsoluteURI(absolutepath, project);
        if (sourceModule instanceof IModuleSource) {
            return (IModuleSource)sourceModule;
        }
        return null;
    }

    public static ISourceModule getSourceModuleFromAbsoluteURI(URI absolutepath, IScriptProject project) {
        if (project == null || absolutepath == null) {
            return null;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                ISourceModule moduleSource = LuaUtils.getSourceModuleFromAbsolutePath(absolutepath, (IParent)projectFragment);
                if (moduleSource != null) {
                    return moduleSource;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Activator.logError(MessageFormat.format("Unable to find module: {0}.", absolutepath), e);
            return null;
        }
        return null;
    }

    private static ISourceModule getSourceModuleFromAbsolutePath(URI absolutepath, IParent parent) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceModule moduleSource;
            IModelElement child = iModelElementArray[n2];
            if (child instanceof ISourceModule) {
                if (URIUtil.sameURI((URI)absolutepath, (URI)LuaUtils.getModuleAbsolutePath((ISourceModule)child))) {
                    return (ISourceModule)child;
                }
            } else if (child instanceof IParent && (moduleSource = LuaUtils.getSourceModuleFromAbsolutePath(absolutepath, (IParent)child)) != null) {
                return moduleSource;
            }
            ++n2;
        }
        return null;
    }

    public static URI getModuleAbsolutePath(ISourceModule module) {
        if (module instanceof IExternalSourceModule) {
            String path = EnvironmentPathUtils.getLocalPath((IPath)module.getPath()).toString();
            if (path.length() != 0 && path.charAt(0) != '/') {
                path = String.valueOf('/') + path;
            }
            try {
                return new URI("file", "", path, null);
            }
            catch (URISyntaxException e) {
                String message = MessageFormat.format("Unable to get file uri for external module : {0}.", module.getPath());
                Activator.logWarning(message, e);
            }
        } else if (module.getResource() != null) {
            return module.getResource().getLocationURI();
        }
        return null;
    }

    public static List<IScriptProject> getDependencies(IScriptProject project) throws ModelException {
        ArrayList<IScriptProject> result = new ArrayList<IScriptProject>();
        IProjectFragment[] projectFragments = project.getAllProjectFragments();
        int i = 0;
        while (i < projectFragments.length) {
            IProjectFragment projectFragment = projectFragments[i];
            if (LuaUtils.isProjectDependencyFragment(project, projectFragment)) {
                IScriptProject currentScriptProject = projectFragment.getScriptProject();
                result.add(currentScriptProject);
            }
            ++i;
        }
        return result;
    }

    public static boolean isProjectDependencyFragment(IScriptProject project, IProjectFragment projectFragment) throws ModelException {
        IScriptProject fragmentProject = projectFragment.getScriptProject();
        if (fragmentProject != null && fragmentProject != project) {
            return !projectFragment.isArchive() && !projectFragment.isBinary() && !projectFragment.isExternal();
        }
        return false;
    }

    public static boolean isExecutionEnvironmentFragment(IProjectFragment projectFragment) throws ModelException {
        IBuildpathEntry rawBuildpathEntry = projectFragment.getRawBuildpathEntry();
        return rawBuildpathEntry != null && LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(rawBuildpathEntry.getPath());
    }

    private static List<IProjectFragment> getProjectFragments(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, IProgressMonitor monitor) throws ModelException {
        ArrayList<IProjectFragment> filteredProjecFragment = new ArrayList<IProjectFragment>();
        IProjectFragment[] projectFragments = project.getAllProjectFragments();
        SubMonitor filteredLoopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)projectFragments.length);
        int i = 0;
        while (i < projectFragments.length && !monitor.isCanceled()) {
            IProjectFragment projectFragment = projectFragments[i];
            if (LuaUtils.isProjectDependencyFragment(project, projectFragment)) {
                if (filter.contains((Object)ProjectFragmentFilter.DEPENDENT_PROJECT)) {
                    filteredProjecFragment.add(projectFragment);
                }
            } else if (LuaUtils.isExecutionEnvironmentFragment(projectFragment)) {
                if (filter.contains((Object)ProjectFragmentFilter.EXECUTION_ENVIRONMENT)) {
                    filteredProjecFragment.add(projectFragment);
                }
            } else if (projectFragment.isArchive()) {
                if (filter.contains((Object)ProjectFragmentFilter.ARCHIVE)) {
                    filteredProjecFragment.add(projectFragment);
                }
            } else {
                filteredProjecFragment.add(projectFragment);
            }
            filteredLoopMonitor.worked(1);
            ++i;
        }
        return filteredProjecFragment;
    }

    public static void visitRootSourceFolder(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, IProjectSourceRootFolderVisitor2 visitor, IProgressMonitor monitor) throws CoreException {
        LuaUtils.visitRootSourceFolder(project, filter, (Object)visitor, monitor);
    }

    public static void visitRootSourceFolder(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, IProjectSourceRootFolderVisitor visitor, IProgressMonitor monitor) throws CoreException {
        LuaUtils.visitRootSourceFolder(project, filter, (Object)visitor, monitor);
    }

    private static void visitRootSourceFolder(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, Object visitor, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        List<IProjectFragment> filteredProjecFragments = LuaUtils.getProjectFragments(project, filter, (IProgressMonitor)subMonitor.newChild(1));
        SubMonitor visitLoopMonitor = subMonitor.newChild(9).setWorkRemaining(filteredProjecFragments.size());
        for (IProjectFragment projectFragment : filteredProjecFragments) {
            if (monitor.isCanceled()) {
                return;
            }
            IPath absolutePathFromModelElement = LuaUtils.getAbsolutePathFromModelElement((IModelElement)projectFragment);
            SubMonitor subMonitor2 = visitLoopMonitor.newChild(1);
            if (visitor instanceof IProjectSourceRootFolderVisitor2) {
                ((IProjectSourceRootFolderVisitor2)visitor).processSourceRootFolder(projectFragment, absolutePathFromModelElement, (IProgressMonitor)subMonitor2);
                continue;
            }
            if (!(visitor instanceof IProjectSourceRootFolderVisitor)) continue;
            ((IProjectSourceRootFolderVisitor)visitor).processSourceRootFolder(absolutePathFromModelElement, (IProgressMonitor)subMonitor2);
        }
    }

    public static void visitSourceFiles(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, IProjectSourceVisitor2 visitor, IProgressMonitor monitor) throws CoreException {
        LuaUtils.visitSourceFiles(project, filter, (Object)visitor, monitor);
    }

    public static void visitSourceFiles(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, IProjectSourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
        LuaUtils.visitSourceFiles(project, filter, (Object)visitor, monitor);
    }

    private static void visitSourceFiles(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, Object visitor, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        List<IProjectFragment> filteredProjecFragments = LuaUtils.getProjectFragments(project, filter, (IProgressMonitor)subMonitor.newChild(1));
        SubMonitor visitLoopMonitor = subMonitor.newChild(9).setWorkRemaining(filteredProjecFragments.size());
        for (IProjectFragment projectFragment : filteredProjecFragments) {
            if (monitor.isCanceled()) {
                return;
            }
            LuaUtils.visitSourceFiles((IParent)projectFragment, visitor, (IProgressMonitor)visitLoopMonitor.newChild(1), (IPath)Path.EMPTY);
        }
    }

    private static void visitSourceFiles(IParent parent, Object visitor, IProgressMonitor monitor, IPath currentPath) throws CoreException {
        IModelElement[] children = parent.getChildren();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
        int i = 0;
        while (i < children.length && !monitor.isCanceled()) {
            IModelElement modelElement = children[i];
            if (modelElement instanceof ISourceModule) {
                IPath absolutePath = LuaUtils.getAbsolutePathFromModelElement(modelElement);
                String charset = LuaUtils.getCharsetOfModelElement(modelElement);
                IPath relativeFilePath = currentPath.append(absolutePath.lastSegment());
                if (visitor instanceof IProjectSourceVisitor2) {
                    ((IProjectSourceVisitor2)visitor).processFile((ISourceModule)modelElement, absolutePath, relativeFilePath, charset, (IProgressMonitor)subMonitor.newChild(1));
                } else if (visitor instanceof IProjectSourceVisitor) {
                    ((IProjectSourceVisitor)visitor).processFile(absolutePath, relativeFilePath, charset, (IProgressMonitor)subMonitor.newChild(1));
                }
            } else if (modelElement instanceof IScriptFolder) {
                IScriptFolder innerSourceFolder = (IScriptFolder)modelElement;
                if (!innerSourceFolder.isRootFolder()) {
                    IPath absolutePath = LuaUtils.getAbsolutePathFromModelElement(modelElement);
                    IPath newPath = currentPath.append(innerSourceFolder.getElementName());
                    if (visitor instanceof IProjectSourceVisitor2) {
                        ((IProjectSourceVisitor2)visitor).processDirectory(innerSourceFolder, absolutePath, newPath, (IProgressMonitor)subMonitor.newChild(1));
                    } else if (visitor instanceof IProjectSourceVisitor) {
                        ((IProjectSourceVisitor)visitor).processDirectory(absolutePath, newPath, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    LuaUtils.visitSourceFiles((IParent)innerSourceFolder, visitor, (IProgressMonitor)subMonitor.newChild(1), newPath);
                } else {
                    LuaUtils.visitSourceFiles((IParent)innerSourceFolder, visitor, (IProgressMonitor)subMonitor.newChild(1), (IPath)Path.EMPTY);
                }
            }
            ++i;
        }
    }

    private static IPath getAbsolutePathFromModelElement(IModelElement modelElement) throws CoreException {
        IResource resource = modelElement.getResource();
        if (resource != null) {
            return resource.getLocation();
        }
        IPath folderPath = modelElement.getPath();
        if (EnvironmentPathUtils.isFull((IPath)folderPath)) {
            return EnvironmentPathUtils.getLocalPath((IPath)folderPath);
        }
        String message = MessageFormat.format("Unable to get absolute location for {0}.", modelElement.getElementName());
        Status status = new Status(4, "org.eclipse.koneki.ldt", message);
        throw new CoreException((IStatus)status);
    }

    private static String getCharsetOfModelElement(IModelElement modelElement) throws CoreException {
        IResource resource = modelElement.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return file.getCharset();
        }
        return Charset.defaultCharset().toString();
    }

    public static final IProject[] getLuaProjects() {
        IProject[] projects;
        LinkedList<IProject> luaProjects = new LinkedList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            try {
                if (iProject.isAccessible() && iProject.hasNature("org.eclipse.koneki.ldt.nature")) {
                    luaProjects.add(iProject);
                }
            }
            catch (CoreException e) {
                Activator.logWarning("Unexcepted error when collecting Lua project", e);
            }
            ++n2;
        }
        return luaProjects.toArray(new IProject[luaProjects.size()]);
    }

    public static boolean isLuaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.koneki.ldt.nature");
        }
        catch (CoreException e) {
            Activator.logWarning("Unexcepted error when checking if project is a Lua project", e);
            return false;
        }
    }

    public static enum ProjectFragmentFilter {
        EXECUTION_ENVIRONMENT,
        DEPENDENT_PROJECT,
        ARCHIVE;

    }
}

