/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryTreeContentManager;
import org.eclipse.equinox.internal.p2.ui.viewers.IDeferredQueryTreeListener;
import org.eclipse.equinox.internal.p2.ui.viewers.IInputChangeListener;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class DeferredQueryContentProvider
extends ProvElementContentProvider {
    DeferredQueryTreeContentManager manager;
    Object currentInput;
    HashMap<Object, Object> alreadyQueried = new HashMap();
    HashSet<Object> queryCompleted = new HashSet();
    AbstractTreeViewer viewer = null;
    ListenerList listeners = new ListenerList();
    boolean synchronous = false;

    public void addListener(IInputChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IInputChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        super.inputChanged(v, oldInput, newInput);
        if (this.manager != null) {
            this.manager.cancel(oldInput);
        }
        if (v instanceof AbstractTreeViewer) {
            this.manager = new DeferredQueryTreeContentManager((AbstractTreeViewer)v);
            this.viewer = (AbstractTreeViewer)v;
            this.manager.setListener(new IDeferredQueryTreeListener(){

                @Override
                public void fetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.alreadyQueried.put(parent, placeholder);
                }

                @Override
                public void finishedFetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.queryCompleted.add(parent);
                }
            });
        } else {
            this.viewer = null;
        }
        this.alreadyQueried = new HashMap();
        this.queryCompleted = new HashSet();
        this.currentInput = newInput;
        Object[] inputListeners = this.listeners.getListeners();
        int i = 0;
        while (i < inputListeners.length) {
            ((IInputChangeListener)inputListeners[i]).inputChanged(v, oldInput, newInput);
            ++i;
        }
    }

    @Override
    public Object[] getElements(Object input) {
        if (input instanceof QueriedElement) {
            return this.getChildren(input);
        }
        return super.getElements(input);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
    }

    @Override
    public boolean hasChildren(Object element) {
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object parent) {
        if (parent instanceof RemoteQueriedElement) {
            RemoteQueriedElement element = (RemoteQueriedElement)parent;
            if (element.hasQueryable()) {
                return element.getChildren(element);
            }
            if (this.manager != null && !this.synchronous) {
                return this.manager.getChildren(parent);
            }
        }
        return super.getChildren(parent);
    }

    public void setSynchronous(boolean sync) {
        if (sync && this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
        this.synchronous = sync;
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }
}

