/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.ui.internal.launch.tab;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class LuaRemoteEnvironmentTab
extends AbstractLaunchConfigurationTab {
    private static final String NAME_LABEL = LaunchConfigurationsMessages.EnvironmentTab_8;
    private static final String VALUE_LABEL = LaunchConfigurationsMessages.EnvironmentTab_9;
    private String[] envTableColumnHeaders = new String[]{LaunchConfigurationsMessages.EnvironmentTab_Variable_1, LaunchConfigurationsMessages.EnvironmentTab_Value_2};
    private TableViewer environmentTable;
    private Button envAddButton;
    private Button envEditButton;
    private Button envRemoveButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        comp.setFont(parent.getFont());
        this.createEnvironmentTable(comp);
        this.createTableButtons(comp);
        Label l2 = new Label(comp, 0);
        l2.setText(LaunchConfigurationsMessages.EnvironmentTab_16);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)l2);
    }

    private void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(buttonComposite);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)buttonComposite);
        this.envAddButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_New_4, null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LuaRemoteEnvironmentTab.this.handleEnvAddButtonSelected();
            }
        });
        this.envEditButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Edit_5, null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LuaRemoteEnvironmentTab.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Remove_6, null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LuaRemoteEnvironmentTab.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    private void createEnvironmentTable(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(LaunchConfigurationsMessages.EnvironmentTab_Environment_variables_to_set__3);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)l);
        Composite tableComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(tableComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        this.environmentTable = new TableViewer(tableComposite, 68354);
        Table table = this.environmentTable.getTable();
        GridLayoutFactory.swtDefaults().applyTo((Composite)table);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentVariableContentProvider());
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LuaRemoteEnvironmentTab.this.handleTableSelectionChanged(event);
            }
        });
        this.environmentTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!LuaRemoteEnvironmentTab.this.environmentTable.getSelection().isEmpty()) {
                    LuaRemoteEnvironmentTab.this.handleEnvEditButtonSelected();
                }
            }
        });
        final TableColumn tc1 = new TableColumn(table, 0, 0);
        tc1.setText(this.envTableColumnHeaders[0]);
        final TableColumn tc2 = new TableColumn(table, 0, 1);
        tc2.setText(this.envTableColumnHeaders[1]);
        final Table tref = table;
        final Composite comp = tableComposite;
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = comp.getClientArea();
                Point size = tref.computeSize(-1, -1);
                ScrollBar vBar = tref.getVerticalBar();
                int width = area.width - tref.computeTrim((int)0, (int)0, (int)0, (int)0).width - 2;
                if (size.y > area.height + tref.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tref.getSize();
                if (oldSize.x > area.width) {
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                    tref.setSize(area.width, area.height);
                } else {
                    tref.setSize(area.width, area.height);
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                }
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.environmentTable.setInput((Object)configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TableItem[] items = this.environmentTable.getTable().getItems();
        HashMap<String, String> map = new HashMap<String, String>(items.length);
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
            map.put(var.getName(), var.getValue());
            ++i;
        }
        if (map.size() == 0) {
            configuration.removeAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES);
        } else {
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
        }
    }

    public String getName() {
        return LaunchConfigurationsMessages.EnvironmentTab_Environment_7;
    }

    public Image getImage() {
        return DebugPluginImages.getImage((String)"IMG_OBJS_ENVIRONMENT");
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    protected void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        this.environmentTable.getControl().setRedraw(false);
        for (EnvironmentVariable var : sel) {
            this.environmentTable.remove((Object)var);
        }
        this.environmentTable.getControl().setRedraw(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void handleEnvAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_22);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addTextField(VALUE_LABEL, null, false);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value.trim()));
        }
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        String name = variable.getName();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)items[i].getData();
            if (existingVariable.getName().equals(name)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_12, (String)MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_13, name));
                if (!overWrite) {
                    return false;
                }
                this.environmentTable.remove((Object)existingVariable);
                break;
            }
            ++i;
        }
        this.environmentTable.add((Object)variable);
        this.updateLaunchConfigurationDialog();
        return true;
    }

    protected void handleEnvEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_11);
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addTextField(VALUE_LABEL, value, false);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name, value))) {
                this.environmentTable.remove((Object)var);
            }
        } else {
            var.setValue(value);
            this.environmentTable.update((Object)var, null);
            this.updateLaunchConfigurationDialog();
        }
    }

    protected static class EnvironmentVariableContentProvider
    implements IStructuredContentProvider {
        protected EnvironmentVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Map m;
            ArrayList<EnvironmentVariable> elements = new ArrayList<EnvironmentVariable>();
            ILaunchConfiguration config = (ILaunchConfiguration)inputElement;
            try {
                m = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.EMPTY_MAP);
            }
            catch (CoreException e) {
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 4, "Error reading configuration", (Throwable)e));
                return elements.toArray();
            }
            if (m != null && !m.isEmpty()) {
                Iterator iterator = m.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry oEntry;
                    Map.Entry entry = oEntry = iterator.next();
                    elements.add(new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue()));
                }
            }
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                    }
                });
            }
        }
    }

    public static class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                        break;
                    }
                    default: {
                        result = "";
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return DebugPluginImages.getImage((String)"IMG_OBJS_ENV_VAR");
            }
            return null;
        }
    }
}

