/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class MozillaDelegate {
    Browser browser;
    Shell eventShell;
    Listener listener;
    boolean hasFocus;
    static Boolean IsXULRunner24;
    static final String LIB_XPCOM = "libxpcom.dylib";
    static final String LIB_XUL = "XUL";
    static final String MOZILLA_RUNNING = "org.eclipse.swt.internal.mozillaRunning";

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(long handle) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(handle);
    }

    static String getCacheParentPath() {
        NSArray array;
        if (OS.VERSION >= 4192 && (array = NSFileManager.defaultManager().URLsForDirectory(13L, 1L)).count() > 0L) {
            NSURL url = new NSURL(array.objectAtIndex(0L));
            return String.valueOf(url.path().getString()) + Mozilla.SEPARATOR_OS + "eclipse";
        }
        String baseDir = System.getProperty("user.home");
        return String.valueOf(baseDir) + "/Library/Caches/eclipse";
    }

    static String[] getJSLibraryNames() {
        return new String[]{LIB_XPCOM};
    }

    static String getJSLibraryName_Pre4() {
        return "libmozjs.dylib";
    }

    static String getLibraryName(String mozillaPath) {
        if (IsXULRunner24 == null) {
            IsXULRunner24 = new File(mozillaPath, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
        }
        return IsXULRunner24 != false ? LIB_XUL : LIB_XPCOM;
    }

    static String getProfilePath() {
        String baseDir = System.getProperty("user.home");
        return String.valueOf(baseDir) + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    static void loadAdditionalLibraries(String mozillaPath, boolean isGlued) {
        if (!isGlued) {
            String utilsPath = String.valueOf(mozillaPath) + Mozilla.SEPARATOR_OS + "libmozutils.dylib";
            byte[] bytes = MozillaDelegate.wcsToMbcs(null, utilsPath, true);
            OS.NSAddImage(bytes, 9);
        }
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        return new String(buffer).toCharArray();
    }

    static boolean needsSpinup() {
        return false;
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        if (terminate) {
            string = String.valueOf(string) + "\u0000";
        }
        return string.getBytes();
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow baseWindow) {
        this.browser.getDisplay().setData(MOZILLA_RUNNING, Boolean.TRUE);
        NSApplication application = NSApplication.sharedApplication();
        NSMenu mainMenu = application.mainMenu();
        if (mainMenu != null) {
            mainMenu.retain();
        }
        int rc = baseWindow.Create();
        application.setMainMenu(mainMenu);
        if (mainMenu != null) {
            mainMenu.release();
        }
        ((Mozilla)this.browser.webBrowser).Activate();
        return rc;
    }

    long getHandle() {
        return this.browser.view.id;
    }

    Point getNativeSize(int width, int height) {
        if (IsXULRunner24.booleanValue()) {
            NSScreen screen = this.browser.view.window().screen();
            double scaling = screen.backingScaleFactor();
            return new Point((int)((double)width * scaling), (int)((double)height * scaling));
        }
        return new Point(width, height);
    }

    long getSiteWindow() {
        return this.browser.view.id;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        ((Mozilla)this.browser.webBrowser).Activate();
        this.browser.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                if (event.type != 12) {
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                    MozillaDelegate.this.hasFocus = false;
                }
                MozillaDelegate.this.eventShell.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.eventShell.removeListener(27, this);
                MozillaDelegate.this.eventShell.removeListener(12, this);
                MozillaDelegate.this.eventShell = null;
                MozillaDelegate.this.listener = null;
            }
        };
        this.eventShell = this.browser.getShell();
        this.eventShell.getDisplay().addFilter(15, this.listener);
        this.eventShell.addListener(27, this.listener);
        this.eventShell.addListener(12, this.listener);
    }

    void handleMouseDown() {
        Mozilla mozilla = (Mozilla)this.browser.webBrowser;
        if (!mozilla.isActive) {
            mozilla.Activate();
        }
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
    }

    void onDispose(long embedHandle) {
        if (this.listener != null) {
            this.eventShell.getDisplay().removeFilter(15, this.listener);
            this.eventShell.removeListener(27, this.listener);
            this.eventShell.removeListener(12, this.listener);
            this.eventShell = null;
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(long embedHandle, int width, int height) {
    }
}

