/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.MessageFormat;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.ProductInfo;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroRegistry;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.WorkbenchOperationSupport;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.internal.wizards.ExportWizardRegistry;
import org.eclipse.ui.internal.wizards.ImportWizardRegistry;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.testing.TestableObject;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static final String DATA_SPLASH_SHELL = "org.eclipse.ui.workbench.splashShell";
    private static final String PROP_SPLASH_HANDLE = "org.eclipse.equinox.launcher.splash.handle";
    private static final String LEFT_TO_RIGHT = "ltr";
    private static final String RIGHT_TO_LEFT = "rtl";
    private static final String ORIENTATION_COMMAND_LINE = "-dir";
    private static final String ORIENTATION_PROPERTY = "eclipse.orientation";
    private static final String NL_USER_PROPERTY = "osgi.nl.user";
    private static final String BIDI_COMMAND_LINE = "-bidi";
    private static final String BIDI_SUPPORT_OPTION = "on";
    private static final String BIDI_TEXTDIR_OPTION = "textDir";
    private static WorkbenchPlugin inst;
    private EditorRegistry editorRegistry;
    private DecoratorManager decoratorManager;
    private ThemeRegistry themeRegistry;
    private WorkingSetManager workingSetManager;
    private WorkingSetRegistry workingSetRegistry;
    private BundleContext bundleContext;
    private Collection<Bundle> startingBundles = new HashSet<Bundle>();
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    public static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private WorkbenchPreferenceManager preferenceManager;
    private ViewRegistry viewRegistry;
    private PerspectiveRegistry perspRegistry;
    private ActionSetRegistry actionSetRegistry;
    private SharedImages sharedImages;
    private ProductInfo productInfo = null;
    private IntroRegistry introRegistry;
    private WorkbenchOperationSupport operationSupport;
    private BundleListener bundleListener;
    private IEclipseContext e4Context;
    private ServiceTracker debugTracker = null;
    private ServiceTracker testableTracker = null;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin() {
        inst = this;
    }

    void reset() {
        this.editorRegistry = null;
        if (this.decoratorManager != null) {
            this.decoratorManager.dispose();
            this.decoratorManager = null;
        }
        ProgressManager.shutdownProgressManager();
        this.themeRegistry = null;
        if (this.workingSetManager != null) {
            this.workingSetManager.dispose();
            this.workingSetManager = null;
        }
        this.workingSetRegistry = null;
        this.preferenceManager = null;
        if (this.viewRegistry != null) {
            this.viewRegistry.dispose();
            this.viewRegistry = null;
        }
        if (this.perspRegistry != null) {
            this.perspRegistry.dispose();
            this.perspRegistry = null;
        }
        this.actionSetRegistry = null;
        this.sharedImages = null;
        this.productInfo = null;
        this.introRegistry = null;
        if (this.operationSupport != null) {
            this.operationSupport.dispose();
            this.operationSupport = null;
        }
        DEBUG = false;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (BundleUtility.isActivated(element.getContributor().getName())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PI_WORKBENCH, 4, WorkbenchMessages.WorkbenchPlugin_extension, (Throwable)e));
        }
    }

    public static boolean hasExecutableExtension(IConfigurationElement element, String extensionName) {
        if (element.getAttribute(extensionName) != null) {
            return true;
        }
        String elementText = element.getValue();
        if (elementText != null && !elementText.equals("")) {
            return true;
        }
        IConfigurationElement[] children = element.getChildren(extensionName);
        return children.length == 1 && children[0].getAttribute("class") != null;
    }

    public static boolean isBundleLoadedForExecutableExtension(IConfigurationElement element, String extensionName) {
        Bundle bundle = WorkbenchPlugin.getBundleForExecutableExtension(element, extensionName);
        if (bundle == null) {
            return true;
        }
        return bundle.getState() == 32;
    }

    public static Bundle getBundleForExecutableExtension(IConfigurationElement element, String extensionName) {
        String prop = null;
        String contributorName = null;
        if (extensionName != null) {
            prop = element.getAttribute(extensionName);
        } else {
            prop = element.getValue();
            if (prop != null && (prop = prop.trim()).equals("")) {
                prop = null;
            }
        }
        if (prop == null) {
            IConfigurationElement[] exec = element.getChildren(extensionName);
            if (exec.length != 0) {
                contributorName = exec[0].getAttribute("plugin");
            }
        } else {
            int i = prop.indexOf(58);
            String executable = i != -1 ? prop.substring(0, i).trim() : prop;
            i = executable.indexOf(47);
            if (i != -1) {
                contributorName = executable.substring(0, i).trim();
            }
        }
        if (contributorName == null) {
            contributorName = element.getContributor().getName();
        }
        return Platform.getBundle(contributorName);
    }

    @Override
    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        return (ActionSetRegistry)this.e4Context.get(ActionSetRegistry.class.getName());
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        return (IEditorRegistry)this.e4Context.get(IEditorRegistry.class.getName());
    }

    public IElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, "elementFactories");
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + targetID);
            return null;
        }
        IElementFactory factory = null;
        try {
            factory = (IElementFactory)WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create element factory.", e.getStatus());
            factory = null;
        }
        return factory;
    }

    public AbstractPresentationFactory getPresentationFactory(String targetID) {
        Object o = this.createExtension("presentationFactories", "factory", targetID);
        if (o instanceof AbstractPresentationFactory) {
            return (AbstractPresentationFactory)o;
        }
        WorkbenchPlugin.log("Error creating presentation factory: " + targetID + " -- class is not an AbstractPresentationFactory");
        return null;
    }

    private Object createExtension(String extensionPointId, String elementName, String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, extensionPointId);
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find extension. Extension point: " + extensionPointId + " not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            String strID;
            IConfigurationElement element = elements[j];
            if ((elementName == null || elementName.equals(element.getName())) && targetID.equals(strID = element.getAttribute("id"))) {
                targetElement = element;
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find extension: " + targetID + " in extension point: " + extensionPointId);
            return null;
        }
        try {
            return WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create extension: " + targetID + " in extension point: " + extensionPointId + ", status: ", e.getStatus());
            return null;
        }
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        return (IPerspectiveRegistry)this.e4Context.get(IPerspectiveRegistry.class.getName());
    }

    public IWorkingSetManager getWorkingSetManager() {
        return (IWorkingSetManager)this.e4Context.get(IWorkingSetManager.class.getName());
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        return (WorkingSetRegistry)this.e4Context.get(WorkingSetRegistry.class.getName());
    }

    public IIntroRegistry getIntroRegistry() {
        return (IIntroRegistry)this.e4Context.get(IIntroRegistry.class.getName());
    }

    public IWorkbenchOperationSupport getOperationSupport() {
        IWorkbenchOperationSupport op = (IWorkbenchOperationSupport)this.e4Context.get(IWorkbenchOperationSupport.class);
        if (op == null) {
            op = new WorkbenchOperationSupport();
        }
        return op;
    }

    public PreferenceManager getPreferenceManager() {
        return (PreferenceManager)this.e4Context.get(PreferenceManager.class.getName());
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        if (this.e4Context == null) {
            return this.sharedImages;
        }
        return (ISharedImages)this.e4Context.get(ISharedImages.class.getName());
    }

    public IThemeRegistry getThemeRegistry() {
        return (IThemeRegistry)this.e4Context.get(IThemeRegistry.class.getName());
    }

    public IViewRegistry getViewRegistry() {
        return (IViewRegistry)this.e4Context.get(IViewRegistry.class.getName());
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    public static void log(String message) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
    }

    public static void log(Throwable t) {
        WorkbenchPlugin.getDefault().getLog().log(WorkbenchPlugin.getStatus(t));
    }

    public static IStatus getStatus(Throwable t) {
        String message = StatusUtil.getLocalizedMessage(t);
        return WorkbenchPlugin.newError(message, t);
    }

    public static IStatus newError(String message, Throwable t) {
        String pluginId = "org.eclipse.ui.workbench";
        int errorCode = 0;
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            pluginId = ce.getStatus().getPlugin();
            errorCode = ce.getStatus().getCode();
        }
        return new Status(4, pluginId, errorCode, message, StatusUtil.getCause(t));
    }

    public static void log(String message, Throwable t) {
        IStatus status = StatusUtil.newStatus(4, message, t);
        WorkbenchPlugin.log(message, status);
    }

    public static void log(Class clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format((String)"Exception in {0}.{1}: {2}", (Object[])new Object[]{clazz.getName(), methodName, t});
        WorkbenchPlugin.log(msg, t);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        }
        WorkbenchPlugin.getDefault().getLog().log(status);
    }

    public static void log(IStatus status) {
        WorkbenchPlugin.getDefault().getLog().log(status);
    }

    public DecoratorManager getDecoratorManager() {
        return (DecoratorManager)this.e4Context.get(IDecoratorManager.class.getName());
    }

    @Override
    public void start(BundleContext context) throws Exception {
        context.addBundleListener(this.getBundleListener());
        super.start(context);
        this.bundleContext = context;
        JFaceUtil.initializeJFace();
        this.parseBidiArguments();
        Window.setDefaultOrientation((int)this.getDefaultOrientation());
        Bundle uiBundle = Platform.getBundle((String)"org.eclipse.ui");
        try {
            if (uiBundle != null) {
                uiBundle.start(1);
            }
        }
        catch (BundleException e) {
            WorkbenchPlugin.log("Unable to load UI activator", e);
        }
    }

    private void parseBidiArguments() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        String bidiParams = null;
        int i = 0;
        while (i < commandLineArgs.length - 1) {
            if (commandLineArgs[i].equals(BIDI_COMMAND_LINE)) {
                bidiParams = commandLineArgs[i + 1];
            }
            ++i;
        }
        if (bidiParams != null) {
            String[] bidiProps = Util.getArrayFromList(bidiParams, ";");
            int i2 = 0;
            while (i2 < bidiProps.length) {
                int eqPos = bidiProps[i2].indexOf("=");
                if (eqPos > 0 && eqPos < bidiProps[i2].length() - 1) {
                    String nameProp = bidiProps[i2].substring(0, eqPos);
                    String valProp = bidiProps[i2].substring(eqPos + 1);
                    if (nameProp.equals(BIDI_SUPPORT_OPTION)) {
                        BidiUtils.setBidiSupport((boolean)"y".equals(valProp));
                    } else if (nameProp.equalsIgnoreCase(BIDI_TEXTDIR_OPTION)) {
                        try {
                            BidiUtils.setTextDirection((String)valProp.intern());
                        }
                        catch (IllegalArgumentException e) {
                            WorkbenchPlugin.log(e);
                        }
                    }
                }
                ++i2;
            }
        }
    }

    private int getDefaultOrientation() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int orientation = this.getCommandLineOrientation(commandLineArgs);
        if (orientation != 0) {
            return orientation;
        }
        orientation = this.getSystemPropertyOrientation();
        if (orientation != 0) {
            return orientation;
        }
        return this.checkCommandLineLocale();
    }

    private Boolean isBidiMessageText() {
        String message = WorkbenchMessages.Startup_Loading_Workbench;
        if (message == null) {
            return null;
        }
        try {
            boolean isBidi = Bidi.requiresBidi((char[])message.toCharArray(), (int)0, (int)message.length());
            return new Boolean(isBidi);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private int checkCommandLineLocale() {
        if (System.getProperty(NL_USER_PROPERTY) == null) {
            Boolean needRTL = this.isBidiMessageText();
            if (needRTL != null && needRTL.booleanValue()) {
                return 0x4000000;
            }
        } else {
            boolean bidiLangauage;
            String lang = Locale.getDefault().getLanguage();
            boolean bl = bidiLangauage = "iw".equals(lang) || "he".equals(lang) || "ar".equals(lang) || "fa".equals(lang) || "ur".equals(lang);
            if (bidiLangauage) {
                Boolean needRTL = this.isBidiMessageText();
                if (needRTL == null) {
                    return 0x4000000;
                }
                if (needRTL.booleanValue()) {
                    return 0x4000000;
                }
            }
        }
        return 0;
    }

    private int getSystemPropertyOrientation() {
        String orientation = System.getProperty(ORIENTATION_PROPERTY);
        if (RIGHT_TO_LEFT.equals(orientation)) {
            return 0x4000000;
        }
        if (LEFT_TO_RIGHT.equals(orientation)) {
            return 0x2000000;
        }
        return 0;
    }

    private int getCommandLineOrientation(String[] commandLineArgs) {
        int i = 0;
        while (i < commandLineArgs.length - 1) {
            if (commandLineArgs[i].equalsIgnoreCase(ORIENTATION_COMMAND_LINE)) {
                String orientation = commandLineArgs[i + 1];
                if (orientation.equals(RIGHT_TO_LEFT)) {
                    System.setProperty(ORIENTATION_PROPERTY, RIGHT_TO_LEFT);
                    return 0x4000000;
                }
                if (orientation.equals(LEFT_TO_RIGHT)) {
                    System.setProperty(ORIENTATION_PROPERTY, LEFT_TO_RIGHT);
                    return 0x2000000;
                }
            }
            ++i;
        }
        return 0;
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getAppName() {
        return this.getProductInfo().getAppName();
    }

    public String getProductName() {
        return this.getProductInfo().getProductName();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.getProductInfo().getWindowImages();
    }

    private ProductInfo getProductInfo() {
        if (this.productInfo == null) {
            this.productInfo = new ProductInfo(Platform.getProduct());
        }
        return this.productInfo;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        if (this.bundleListener != null) {
            context.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.testableTracker != null) {
            this.testableTracker.close();
            this.testableTracker = null;
        }
        super.stop(context);
    }

    public IWizardRegistry getNewWizardRegistry() {
        return (IWizardRegistry)this.e4Context.get(NewWizardRegistry.class.getName());
    }

    public IWizardRegistry getImportWizardRegistry() {
        return (IWizardRegistry)this.e4Context.get(ImportWizardRegistry.class.getName());
    }

    public IWizardRegistry getExportWizardRegistry() {
        return (IWizardRegistry)this.e4Context.get(ExportWizardRegistry.class.getName());
    }

    public IPath getDataLocation() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    void addBundleListener(BundleListener bundleListener) {
        this.bundleContext.addBundleListener(bundleListener);
    }

    void removeBundleListener(BundleListener bundleListener) {
        this.bundleContext.removeBundleListener(bundleListener);
    }

    int getBundleCount() {
        return this.bundleContext.getBundles().length;
    }

    OutputStream getSplashStream() {
        ServiceReference[] ref;
        try {
            ref = this.bundleContext.getServiceReferences(OutputStream.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (ref == null) {
            return null;
        }
        int i = 0;
        while (i < ref.length) {
            String name = (String)ref[i].getProperty("name");
            if (name != null && name.equals("splashstream")) {
                Object result = this.bundleContext.getService(ref[i]);
                this.bundleContext.ungetService(ref[i]);
                return (OutputStream)result;
            }
            ++i;
        }
        return null;
    }

    private BundleListener getBundleListener() {
        if (this.bundleListener == null) {
            this.bundleListener = new SynchronousBundleListener(){

                public void bundleChanged(BundleEvent event) {
                    WorkbenchPlugin.this.bundleChanged(event);
                }
            };
        }
        return this.bundleListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bundleChanged(BundleEvent event) {
        int eventType = event.getType();
        Collection<Bundle> collection = this.startingBundles;
        synchronized (collection) {
            switch (eventType) {
                case 128: {
                    this.startingBundles.add(event.getBundle());
                    break;
                }
                case 2: 
                case 4: {
                    this.startingBundles.remove(event.getBundle());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarting(Bundle bundle) {
        Collection<Bundle> collection = this.startingBundles;
        synchronized (collection) {
            return this.startingBundles.contains(bundle);
        }
    }

    public static boolean isSplashHandleSpecified() {
        return System.getProperty(PROP_SPLASH_HANDLE) != null;
    }

    public static Shell getSplashShell(Display display) throws NumberFormatException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Shell splashShell = (Shell)display.getData(DATA_SPLASH_SHELL);
        if (splashShell != null) {
            return splashShell;
        }
        String splashHandle = System.getProperty(PROP_SPLASH_HANDLE);
        if (splashHandle == null) {
            return null;
        }
        try {
            Method method = Shell.class.getMethod("internal_new", Display.class, Integer.TYPE);
            splashShell = (Shell)method.invoke(null, display, new Integer(splashHandle));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = Shell.class.getMethod("internal_new", Display.class, Long.TYPE);
                splashShell = (Shell)method.invoke(null, display, new Long(splashHandle));
            }
            catch (NoSuchMethodException noSuchMethodException2) {}
        }
        display.setData(DATA_SPLASH_SHELL, (Object)splashShell);
        return splashShell;
    }

    public static void unsetSplashShell(Display display) {
        Shell splashShell = (Shell)display.getData(DATA_SPLASH_SHELL);
        if (splashShell != null) {
            if (!splashShell.isDisposed()) {
                splashShell.dispose();
            }
            display.setData(DATA_SPLASH_SHELL, null);
        }
    }

    public void initializeContext(IEclipseContext context) {
        this.e4Context = context;
        this.e4Context.set(IPerspectiveRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.perspRegistry == null) {
                    WorkbenchPlugin.this.perspRegistry = (PerspectiveRegistry)ContextInjectionFactory.make(PerspectiveRegistry.class, (IEclipseContext)WorkbenchPlugin.this.e4Context);
                }
                return WorkbenchPlugin.this.perspRegistry;
            }
        });
        this.e4Context.set(IViewRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.viewRegistry == null) {
                    WorkbenchPlugin.this.viewRegistry = (ViewRegistry)ContextInjectionFactory.make(ViewRegistry.class, (IEclipseContext)WorkbenchPlugin.this.e4Context);
                }
                return WorkbenchPlugin.this.viewRegistry;
            }
        });
        this.e4Context.set(ActionSetRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.actionSetRegistry == null) {
                    WorkbenchPlugin.this.actionSetRegistry = new ActionSetRegistry();
                }
                return WorkbenchPlugin.this.actionSetRegistry;
            }
        });
        context.set(IDecoratorManager.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.decoratorManager == null) {
                    WorkbenchPlugin.this.decoratorManager = new DecoratorManager();
                }
                return WorkbenchPlugin.this.decoratorManager;
            }
        });
        context.set(ExportWizardRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ExportWizardRegistry.getInstance();
            }
        });
        context.set(ImportWizardRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ImportWizardRegistry.getInstance();
            }
        });
        context.set(IIntroRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.introRegistry == null) {
                    WorkbenchPlugin.this.introRegistry = new IntroRegistry();
                }
                return WorkbenchPlugin.this.introRegistry;
            }
        });
        context.set(NewWizardRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return NewWizardRegistry.getInstance();
            }
        });
        context.set(IWorkbenchOperationSupport.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.operationSupport == null) {
                    WorkbenchPlugin.this.operationSupport = new WorkbenchOperationSupport();
                }
                return WorkbenchPlugin.this.operationSupport;
            }
        });
        context.set(PreferenceManager.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.preferenceManager == null) {
                    WorkbenchPlugin.this.preferenceManager = new WorkbenchPreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);
                    PreferencePageRegistryReader registryReader = new PreferencePageRegistryReader(WorkbenchPlugin.this.getWorkbench());
                    registryReader.loadFromRegistry(Platform.getExtensionRegistry());
                    WorkbenchPlugin.this.preferenceManager.addPages(registryReader.getTopLevelNodes());
                }
                return WorkbenchPlugin.this.preferenceManager;
            }
        });
        context.set(ISharedImages.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.sharedImages == null) {
                    WorkbenchPlugin.this.sharedImages = new SharedImages();
                }
                return WorkbenchPlugin.this.sharedImages;
            }
        });
        context.set(IThemeRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.themeRegistry == null) {
                    WorkbenchPlugin.this.themeRegistry = new ThemeRegistry();
                    ThemeRegistryReader reader = new ThemeRegistryReader();
                    reader.readThemes(Platform.getExtensionRegistry(), WorkbenchPlugin.this.themeRegistry);
                }
                return WorkbenchPlugin.this.themeRegistry;
            }
        });
        context.set(IWorkingSetManager.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.workingSetManager == null) {
                    WorkbenchPlugin.this.workingSetManager = new WorkingSetManager(WorkbenchPlugin.this.bundleContext);
                    WorkbenchPlugin.this.workingSetManager.restoreState();
                }
                return WorkbenchPlugin.this.workingSetManager;
            }
        });
        context.set(WorkingSetRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.workingSetRegistry == null) {
                    WorkbenchPlugin.this.workingSetRegistry = new WorkingSetRegistry();
                    WorkbenchPlugin.this.workingSetRegistry.load();
                }
                return WorkbenchPlugin.this.workingSetRegistry;
            }
        });
        context.set(IEditorRegistry.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (WorkbenchPlugin.this.editorRegistry == null) {
                    WorkbenchPlugin.this.editorRegistry = new EditorRegistry();
                }
                return WorkbenchPlugin.this.editorRegistry;
            }
        });
    }

    public DebugOptions getDebugOptions() {
        if (this.bundleContext == null) {
            return null;
        }
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(this.bundleContext, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public TestableObject getTestableObject() {
        if (this.bundleContext == null) {
            return null;
        }
        if (this.testableTracker == null) {
            this.testableTracker = new ServiceTracker(this.bundleContext, TestableObject.class.getName(), null);
            this.testableTracker.open();
        }
        return (TestableObject)this.testableTracker.getService();
    }
}

