/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.caching.cache.CacheEntry;
import org.eclipse.dltk.core.caching.cache.CacheEntryAttribute;
import org.eclipse.dltk.core.caching.cache.CacheFactory;
import org.eclipse.dltk.core.caching.cache.CacheIndex;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class ArchiveCacheIndexBuilder {
    private ZipOutputStream zip;
    private CacheIndex index = CacheFactory.eINSTANCE.createCacheIndex();
    private long version;

    public ArchiveCacheIndexBuilder(OutputStream stream, long version) throws IOException {
        this.zip = new ZipOutputStream(new BufferedOutputStream(stream, 8096));
        this.version = version;
    }

    public void addEntry(String fileName, long timeStamp, String attribute, InputStream value) throws IOException {
        CacheEntry entry = this.getEntry(fileName, timeStamp);
        EList<CacheEntryAttribute> attributes = entry.getAttributes();
        String location = this.generateLocation(fileName, attribute);
        CacheEntryAttribute attr = CacheFactory.eINSTANCE.createCacheEntryAttribute();
        attr.setName(attribute);
        attr.setLocation(location);
        attributes.add((Object)attr);
        ZipEntry zipEntry = new ZipEntry(location);
        this.zip.putNextEntry(zipEntry);
        Util.copy(value, this.zip);
        this.zip.closeEntry();
    }

    public void done() throws IOException {
        XMIResourceImpl res = new XMIResourceImpl();
        res.getContents().add((Object)this.index);
        ZipEntry entry = new ZipEntry(".index");
        this.zip.putNextEntry(entry);
        res.save((OutputStream)this.zip, null);
        this.zip.closeEntry();
        this.zip.close();
    }

    private String generateLocation(String path, String attribute) {
        return "_" + path + "_" + attribute;
    }

    private CacheEntry getEntry(String path, long timeStamp) {
        EList<CacheEntry> entries = this.index.getEntries();
        for (CacheEntry cacheEntry : entries) {
            if (!cacheEntry.getPath().equals(path)) continue;
            return cacheEntry;
        }
        CacheEntry entry = CacheFactory.eINSTANCE.createCacheEntry();
        entry.setLastAccessTime(this.version);
        entry.setPath(path);
        entry.setTimestamp(timeStamp);
        this.index.getEntries().add((Object)entry);
        return entry;
    }
}

