/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.ui.IWorkingSet;

class SearchScopeWorkingSetAction
extends SearchScopeAction {
    private IWorkingSet[] fWorkingSets;
    SearchScopeActionGroup group;

    public SearchScopeWorkingSetAction(SearchScopeActionGroup group, IWorkingSet[] workingSets, String name) {
        super(group, name);
        this.group = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_workingset_tooltip);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        this.fWorkingSets = workingSets;
    }

    public IDLTKSearchScope getSearchScope() {
        return DLTKSearchScopeFactory.getInstance().createSearchScope(this.fWorkingSets, true, this.group.getLangaugeToolkit());
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSets;
    }

    public int getSearchScopeType() {
        return 4;
    }

    public String getFullDescription() {
        return DLTKSearchScopeFactory.getInstance().getWorkingSetScopeDescription(this.fWorkingSets, true);
    }
}

