/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.GenericMApplicationElementFactoryImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.EPlaceholderResolver;
import org.eclipse.e4.ui.workbench.modeling.ElementMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ModelServiceImpl
implements EModelService {
    private static String HOSTED_ELEMENT = "HostedElement";
    private IEclipseContext appContext;
    private GenericMApplicationElementFactoryImpl mApplicationElementFactory;
    private EventHandler hostedElementHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!changedElement.getTags().contains(HOSTED_ELEMENT)) {
                return;
            }
            if (changedElement.getWidget() != null) {
                return;
            }
            EObject eObj = (EObject)changedElement;
            if (!(eObj.eContainer() instanceof MWindow)) {
                return;
            }
            MWindow hostingWindow = (MWindow)eObj.eContainer();
            hostingWindow.getSharedElements().remove(changedElement);
            changedElement.getTags().remove(HOSTED_ELEMENT);
        }
    };

    public ModelServiceImpl(IEclipseContext appContext) {
        if (appContext == null) {
            throw new NullPointerException("No application context given!");
        }
        this.appContext = appContext;
        IEventBroker eventBroker = (IEventBroker)appContext.get(IEventBroker.class);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.hostedElementHandler);
        this.mApplicationElementFactory = new GenericMApplicationElementFactoryImpl((IExtensionRegistry)appContext.get(IExtensionRegistry.class));
    }

    @Override
    public final <T extends MApplicationElement> T createModelElement(Class<T> elementType) {
        if (elementType == null) {
            throw new NullPointerException("Argument cannot be null.");
        }
        MApplicationElement back = (MApplicationElement)this.mApplicationElementFactory.createEObject(elementType);
        if (back != null) {
            return (T)back;
        }
        throw new IllegalArgumentException("Unsupported model object type: " + elementType.getCanonicalName());
    }

    private <T> void findElementsRecursive(MApplicationElement searchRoot, Selector matcher, List<T> elements, int searchFlags) {
        MPlaceholder ph;
        Assert.isLegal((searchRoot != null ? 1 : 0) != 0);
        if (searchFlags == 0) {
            return;
        }
        if (matcher.select(searchRoot) && !elements.contains(searchRoot)) {
            elements.add(searchRoot);
        }
        if (searchRoot instanceof MElementContainer) {
            List children;
            MElementContainer container;
            if (searchRoot instanceof MPerspectiveStack) {
                if ((searchFlags & 4) != 0) {
                    container = (MElementContainer)searchRoot;
                    children = container.getChildren();
                    for (Object child : children) {
                        this.findElementsRecursive((MApplicationElement)child, matcher, elements, searchFlags);
                    }
                } else if ((searchFlags & 2) != 0) {
                    MPerspective active = (MPerspective)((MPerspectiveStack)searchRoot).getSelectedElement();
                    if (active != null) {
                        this.findElementsRecursive((MApplicationElement)active, matcher, elements, searchFlags);
                    }
                } else if ((searchFlags & 8) != 0 && searchRoot instanceof MUIElement) {
                    List<MArea> areas = this.findElements((MUIElement)searchRoot, null, MArea.class, null);
                    for (MArea area : areas) {
                        this.findElementsRecursive((MApplicationElement)area, matcher, elements, searchFlags);
                    }
                }
            } else {
                container = (MElementContainer)searchRoot;
                children = container.getChildren();
                for (Object child : children) {
                    this.findElementsRecursive((MApplicationElement)child, matcher, elements, searchFlags);
                }
            }
        }
        if (searchRoot instanceof MTrimmedWindow && (searchFlags & 0x10) != 0) {
            MTrimmedWindow tw = (MTrimmedWindow)searchRoot;
            List bars = tw.getTrimBars();
            for (MTrimBar bar : bars) {
                this.findElementsRecursive((MApplicationElement)bar, matcher, elements, searchFlags);
            }
        }
        if (searchRoot instanceof MWindow) {
            MWindow window = (MWindow)searchRoot;
            for (MWindow dw : window.getWindows()) {
                this.findElementsRecursive((MApplicationElement)dw, matcher, elements, searchFlags);
            }
            MMenu menu = window.getMainMenu();
            if (menu != null && (searchFlags & 0x20) != 0) {
                this.findElementsRecursive((MApplicationElement)menu, matcher, elements, searchFlags);
            }
        }
        if (searchRoot instanceof MPerspective) {
            MPerspective persp = (MPerspective)searchRoot;
            for (MWindow dw : persp.getWindows()) {
                this.findElementsRecursive((MApplicationElement)dw, matcher, elements, searchFlags);
            }
        }
        if (searchRoot instanceof MPlaceholder && (ph = (MPlaceholder)searchRoot).getRef() != null && (!(ph.getRef() instanceof MArea) || (searchFlags & 8) != 0)) {
            this.findElementsRecursive((MApplicationElement)ph.getRef(), matcher, elements, searchFlags);
        }
        if (searchRoot instanceof MPart && (searchFlags & 0x40) != 0) {
            MPart part = (MPart)searchRoot;
            for (MMenu menu : part.getMenus()) {
                this.findElementsRecursive((MApplicationElement)menu, matcher, elements, searchFlags);
            }
            MToolBar toolBar = part.getToolbar();
            if (toolBar != null) {
                this.findElementsRecursive((MApplicationElement)toolBar, matcher, elements, searchFlags);
            }
        }
    }

    @Override
    public <T> List<T> findElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch) {
        ElementMatcher matcher = new ElementMatcher(id, clazz, tagsToMatch);
        return this.findElements((MApplicationElement)searchRoot, 29, matcher);
    }

    @Override
    public <T> List<T> findElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch, int searchFlags) {
        ElementMatcher matcher = new ElementMatcher(id, clazz, tagsToMatch);
        return this.findElements((MApplicationElement)searchRoot, searchFlags, matcher);
    }

    @Override
    public <T> List<T> findElements(MApplicationElement searchRoot, int searchFlags, Selector matcher) {
        ArrayList elements = new ArrayList();
        this.findElementsRecursive(searchRoot, matcher, elements, searchFlags);
        return elements;
    }

    private <T> List<T> findPerspectiveElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch) {
        ArrayList elements = new ArrayList();
        ElementMatcher matcher = new ElementMatcher(id, clazz, tagsToMatch);
        this.findElementsRecursive((MApplicationElement)searchRoot, matcher, elements, 11);
        return elements;
    }

    @Override
    public MUIElement find(String id, MUIElement searchRoot) {
        if (id == null || id.length() == 0) {
            return null;
        }
        List<MUIElement> elements = this.findElements(searchRoot, id, MUIElement.class, null);
        if (elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    @Override
    public int countRenderableChildren(MUIElement element) {
        if (!(element instanceof MElementContainer)) {
            return 0;
        }
        MElementContainer container = (MElementContainer)element;
        int count = 0;
        List kids = container.getChildren();
        for (MUIElement kid : kids) {
            if (!kid.isToBeRendered()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public IEclipseContext getContainingContext(MUIElement element) {
        return ModelUtils.getContainingContext((MApplicationElement)element);
    }

    @Override
    public MUIElement cloneElement(MUIElement element, MSnippetContainer snippetContainer) {
        EObject eObj = (EObject)element;
        MUIElement clone = (MUIElement)EcoreUtil.copy((EObject)eObj);
        List<MPlaceholder> phList = this.findElements(clone, null, MPlaceholder.class, null);
        for (MPlaceholder ph : phList) {
            int location = this.getElementLocation((MUIElement)ph);
            if ((location & 8) != 0) continue;
            ph.setRef(null);
        }
        if (snippetContainer != null) {
            MUIElement snippet = this.findSnippet(snippetContainer, element.getElementId());
            if (snippet != null) {
                snippetContainer.getSnippets().remove(snippet);
            }
            snippetContainer.getSnippets().add(clone);
        }
        clone.getTransientData().put("Cloned From", element);
        return clone;
    }

    @Override
    public MUIElement cloneSnippet(MSnippetContainer snippetContainer, String snippetId, MWindow refWin) {
        MElementContainer appElement;
        if (snippetContainer == null || snippetId == null || snippetId.length() == 0) {
            return null;
        }
        MApplicationElement elementToClone = null;
        for (MApplicationElement snippet : snippetContainer.getSnippets()) {
            if (!snippetId.equals(snippet.getElementId())) continue;
            elementToClone = snippet;
            break;
        }
        if (elementToClone == null) {
            return null;
        }
        EObject eObj = (EObject)elementToClone;
        MUIElement element = (MUIElement)EcoreUtil.copy((EObject)eObj);
        MElementContainer mElementContainer = appElement = refWin == null ? null : refWin.getParent();
        if (appElement instanceof MApplication) {
            EPlaceholderResolver resolver = (EPlaceholderResolver)((MApplication)appElement).getContext().get(EPlaceholderResolver.class);
            List<MPlaceholder> phList = this.findElements(element, null, MPlaceholder.class, null);
            for (MPlaceholder ph : phList) {
                resolver.resolvePlaceholderRef(ph, refWin);
            }
        }
        return element;
    }

    @Override
    public MUIElement findSnippet(MSnippetContainer snippetContainer, String id) {
        if (snippetContainer == null || id == null || id.length() == 0) {
            return null;
        }
        List snippets = snippetContainer.getSnippets();
        for (MUIElement snippet : snippets) {
            if (!id.equals(snippet.getElementId())) continue;
            return snippet;
        }
        return null;
    }

    @Override
    public MHandler findHandler(MHandlerContainer handlerContainer, String id) {
        if (handlerContainer == null || id == null || id.length() == 0) {
            return null;
        }
        for (MHandler handler : handlerContainer.getHandlers()) {
            if (!id.equals(handler.getElementId())) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void bringToTop(MUIElement element) {
        if (element instanceof MApplication) {
            return;
        }
        MWindow window = this.getTopLevelWindowFor(element);
        if (window == element) {
            if (!element.isToBeRendered()) {
                element.setToBeRendered(true);
            }
            window.getParent().setSelectedElement((MUIElement)window);
        } else {
            this.showElementInWindow(window, element);
        }
        UIEvents.publishEvent("org/eclipse/e4/ui/LifeCycle/bringToTop", element);
    }

    private void showElementInWindow(MWindow window, MUIElement element) {
        MPlaceholder ph;
        MElementContainer parent = element.getParent();
        if (parent == null && (ph = this.findPlaceholderFor(window, element)) != null) {
            element = ph;
            parent = element.getParent();
        }
        if (parent == null && element instanceof MWindow) {
            parent = (MUIElement)((EObject)element).eContainer();
            if (parent != null) {
                if (!element.isToBeRendered()) {
                    element.setToBeRendered(true);
                }
                if (window != parent) {
                    this.showElementInWindow(window, (MUIElement)parent);
                }
            }
        } else if (parent != null) {
            if (!element.isToBeRendered()) {
                element.setToBeRendered(true);
            }
            parent.setSelectedElement(element);
            if (window != parent) {
                this.showElementInWindow(window, (MUIElement)parent);
            }
        }
    }

    @Override
    public MPlaceholder findPlaceholderFor(MWindow window, MUIElement element) {
        List<MPlaceholder> phList = this.findPerspectiveElements((MUIElement)window, null, MPlaceholder.class, null);
        ArrayList<MPlaceholder> elementRefs = new ArrayList<MPlaceholder>();
        for (MPlaceholder ph : phList) {
            if (ph.getRef() != element) continue;
            elementRefs.add(ph);
        }
        if (elementRefs.size() == 0) {
            return null;
        }
        if (elementRefs.size() == 1) {
            return (MPlaceholder)elementRefs.get(0);
        }
        for (MPlaceholder refPh : elementRefs) {
            int loc = this.getElementLocation((MUIElement)refPh);
            if ((loc & 8) == 0) continue;
            return refPh;
        }
        return (MPlaceholder)elementRefs.get(0);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent) {
        this.move(element, newParent, -1, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, boolean leavePlaceholder) {
        this.move(element, newParent, -1, leavePlaceholder);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index) {
        this.move(element, newParent, index, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index, boolean leavePlaceholder) {
        MElementContainer curParent = element.getParent();
        int curIndex = curParent.getChildren().indexOf(element);
        newParent.getChildren().add(index, element);
        if (leavePlaceholder) {
            MPlaceholder ph = MAdvancedFactory.INSTANCE.createPlaceholder();
            ph.setRef(element);
            curParent.getChildren().add(curIndex, ph);
        }
    }

    private void combine(MPartSashContainerElement toInsert, MPartSashContainerElement relTo, MPartSashContainer newSash, boolean newFirst, float ratio) {
        MElementContainer curParent = relTo.getParent();
        int index = curParent.getChildren().indexOf(relTo);
        curParent.getChildren().remove(relTo);
        if (newFirst) {
            newSash.getChildren().add(toInsert);
            newSash.getChildren().add(relTo);
        } else {
            newSash.getChildren().add(relTo);
            newSash.getChildren().add(toInsert);
        }
        int adjustedPct = (int)(ratio * 10000.0f);
        toInsert.setContainerData(Integer.toString(adjustedPct));
        relTo.setContainerData(Integer.toString(10000 - adjustedPct));
        curParent.getChildren().add(index, newSash);
    }

    @Override
    public void insert(MPartSashContainerElement toInsert, MPartSashContainerElement relTo, int where, float ratio) {
        MPartSashContainer psc;
        boolean horizontal;
        assert (toInsert != null && relTo != null);
        assert (ratio > 0.0f && ratio < 100.0f);
        MElementContainer relToParent = relTo.getParent();
        boolean insertBefore = where == 0 || where == 2;
        boolean bl = horizontal = where == 2 || where == 3;
        if (relTo instanceof MPartSashContainer && this.directionsMatch((MPartSashContainer)relTo, horizontal)) {
            psc = (MPartSashContainer)relTo;
            int totalVisWeight = 0;
            for (MUIElement child : psc.getChildren()) {
                if (!child.isToBeRendered()) continue;
                totalVisWeight += this.getWeight(child);
            }
            int insertWeight = (int)((float)totalVisWeight * ratio / (1.0f - ratio));
            toInsert.setContainerData(Integer.toString(insertWeight));
            if (insertBefore) {
                psc.getChildren().add(0, toInsert);
            } else {
                psc.getChildren().add(toInsert);
            }
        } else if (relToParent instanceof MPartSashContainer && !(relToParent instanceof MArea) && this.directionsMatch((MPartSashContainer)relToParent, horizontal)) {
            psc = (MPartSashContainer)relToParent;
            int relToIndex = psc.getChildren().indexOf(relTo);
            int relToWeight = this.getWeight((MUIElement)relTo);
            int insertWeight = (int)((float)relToWeight * ratio);
            toInsert.setContainerData(Integer.toString(insertWeight));
            relTo.setContainerData(Integer.toString(relToWeight - insertWeight));
            if (insertBefore) {
                psc.getChildren().add(relToIndex, toInsert);
            } else {
                int insertIndex = relToIndex + 1;
                if (insertIndex < psc.getChildren().size()) {
                    psc.getChildren().add(insertIndex, toInsert);
                } else {
                    psc.getChildren().add(toInsert);
                }
            }
        } else {
            MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            newSash.setHorizontal(horizontal);
            newSash.setContainerData(relTo.getContainerData());
            this.combine(toInsert, relTo, newSash, insertBefore, ratio);
        }
        if (relToParent != null) {
            return;
        }
        MElementContainer insertRoot = relTo.getParent();
        if (insertRoot instanceof MPerspective) {
            insertRoot = relTo;
        }
        while (!(insertRoot == null || insertRoot instanceof MWindow || insertRoot instanceof MPerspective || insertRoot instanceof MPartSashContainer)) {
            relTo = (MPartSashContainerElement)insertRoot;
            insertRoot = insertRoot.getParent();
        }
        if (insertRoot instanceof MWindow || insertRoot instanceof MArea || insertRoot instanceof MPerspective) {
            MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            newSash.setHorizontal(where == 2 || where == 3);
            this.combine(toInsert, relTo, newSash, insertBefore, ratio);
        } else if (insertRoot instanceof MGenericTile) {
            MGenericTile curTile = (MGenericTile)insertRoot;
            if (curTile.isHorizontal() && (where == 0 || where == 1)) {
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(false);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, insertBefore, ratio);
            } else if (!(curTile.isHorizontal() || where != 2 && where != 3)) {
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(true);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, insertBefore, ratio);
            } else {
                int relToIndex = relTo.getParent().getChildren().indexOf(relTo);
                if (insertBefore) {
                    curTile.getChildren().add(relToIndex, toInsert);
                } else {
                    curTile.getChildren().add(relToIndex + 1, toInsert);
                }
                int relToWeight = 10000;
                if (relTo.getContainerData() != null) {
                    try {
                        relToWeight = Integer.parseInt(relTo.getContainerData());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                int toInsertWeight = (int)((double)ratio / 100.0 * (double)relToWeight + 0.5);
                relTo.setContainerData(Integer.toString(relToWeight -= toInsertWeight));
                toInsert.setContainerData(Integer.toString(toInsertWeight));
            }
        }
    }

    private int getWeight(MUIElement element) {
        int relToWeight = 10000;
        if (element.getContainerData() != null) {
            try {
                relToWeight = Integer.parseInt(element.getContainerData());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return relToWeight;
    }

    private boolean directionsMatch(MPartSashContainer psc, boolean horizontal) {
        boolean pscHorizontal = psc.isHorizontal();
        return pscHorizontal && horizontal || !pscHorizontal && !horizontal;
    }

    @Override
    public void detach(MPartSashContainerElement element, int x, int y, int width, int height) {
        if (element.getCurSharedRef() != null) {
            element = element.getCurSharedRef();
        }
        MWindow window = this.getTopLevelWindowFor((MUIElement)element);
        MPerspective thePersp = this.getPerspectiveFor((MUIElement)element);
        MTrimmedWindow newWindow = MBasicFactory.INSTANCE.createTrimmedWindow();
        newWindow.setX(x);
        newWindow.setY(y);
        newWindow.setWidth(width);
        newWindow.setHeight(height);
        element.getParent().getChildren().remove(element);
        MWindowElement uiRoot = this.wrapElementForWindow(element);
        newWindow.getChildren().add(uiRoot);
        if (thePersp != null) {
            thePersp.getWindows().add(newWindow);
        } else if (window != null) {
            window.getWindows().add(newWindow);
        }
    }

    private MWindowElement wrapElementForWindow(MPartSashContainerElement element) {
        if (element instanceof MPlaceholder) {
            MUIElement ref = ((MPlaceholder)element).getRef();
            if (ref instanceof MPart) {
                MPartStack newPS = MBasicFactory.INSTANCE.createPartStack();
                newPS.getChildren().add((MPlaceholder)element);
                return newPS;
            }
        } else {
            if (element instanceof MPart) {
                MPartStack newPS = MBasicFactory.INSTANCE.createPartStack();
                newPS.getChildren().add((MPart)element);
                return newPS;
            }
            if (element instanceof MWindowElement) {
                return (MWindowElement)element;
            }
        }
        return null;
    }

    @Override
    public MTrimBar getTrim(MTrimmedWindow window, SideValue sv) {
        List bars = window.getTrimBars();
        for (MTrimBar bar : bars) {
            if (bar.getSide() != sv) continue;
            return bar;
        }
        MTrimBar newBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        if (sv == SideValue.TOP) {
            newBar.setElementId("org.eclipse.ui.main.menu");
        } else if (sv == SideValue.BOTTOM) {
            newBar.setElementId("org.eclipse.ui.trim.status");
        } else if (sv == SideValue.LEFT) {
            newBar.setElementId("org.eclipse.ui.trim.vertical1");
        } else if (sv == SideValue.RIGHT) {
            newBar.setElementId("org.eclipse.ui.trim.vertical2");
        }
        newBar.setSide(sv);
        window.getTrimBars().add(newBar);
        return newBar;
    }

    @Override
    public MWindow getTopLevelWindowFor(MUIElement element) {
        EObject eObj = (EObject)element;
        while (eObj != null && !(eObj.eContainer() instanceof MApplication)) {
            eObj = eObj.eContainer();
        }
        if (eObj instanceof MWindow) {
            return (MWindow)eObj;
        }
        return null;
    }

    @Override
    public MPerspective getPerspectiveFor(MUIElement element) {
        while (true) {
            EObject container;
            MPlaceholder placeholder;
            if ((placeholder = element.getCurSharedRef()) != null) {
                element = placeholder;
            }
            if ((container = ((EObject)element).eContainer()) == null || container instanceof MApplication) {
                return null;
            }
            if (container instanceof MPerspectiveStack) {
                return (MPerspective)element;
            }
            element = (MUIElement)container;
        }
    }

    @Override
    public void resetPerspectiveModel(MPerspective persp, MWindow window) {
        this.resetPerspectiveModel(persp, window, true);
    }

    private void resetPerspectiveModel(MPerspective persp, MWindow window, boolean removeSharedPlaceholders) {
        if (persp == null) {
            return;
        }
        if (removeSharedPlaceholders) {
            EPartService ps = (EPartService)window.getContext().get(EPartService.class);
            List<MArea> areas = this.findElements((MUIElement)window, null, MArea.class, null);
            if (areas.size() == 1) {
                MArea area = areas.get(0);
                List<MPlaceholder> phList = this.findElements((MUIElement)area, null, MPlaceholder.class, null);
                for (MPlaceholder ph : phList) {
                    ps.hidePart((MPart)ph.getRef());
                    ph.getParent().getChildren().remove(ph);
                }
                List<MPartStack> stacks = this.findElements((MUIElement)area, null, MPartStack.class, null);
                for (MPartStack stack : stacks) {
                    String generatedId = "PartStack@" + Integer.toHexString(stack.hashCode());
                    stack.setElementId(generatedId);
                }
                MArea areaPresentation = area;
                if (area.getCurSharedRef() != null) {
                    areaPresentation = area.getCurSharedRef();
                }
                areaPresentation.getTags().remove("Maximized");
                areaPresentation.getTags().remove("Minimized");
                areaPresentation.getTags().remove("MinimizedByZoom");
            }
        }
        List<MTrimBar> bars = this.findElements((MUIElement)window, null, MTrimBar.class, null);
        ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
        for (MTrimBar bar : bars) {
            for (MUIElement barKid : bar.getChildren()) {
                String id;
                if (!(barKid instanceof MToolControl) || (id = barKid.getElementId()) == null || !id.contains(persp.getElementId())) continue;
                toRemove.add((MToolControl)barKid);
            }
        }
        for (MToolControl toolControl : toRemove) {
            toolControl.setToBeRendered(false);
            toolControl.getParent().getChildren().remove(toolControl);
        }
    }

    @Override
    public void removePerspectiveModel(MPerspective persp, MWindow window) {
        MElementContainer psElement = persp.getParent();
        MPerspectiveStack ps = (MPerspectiveStack)psElement;
        boolean foundNewSelection = false;
        if (ps.getSelectedElement() == persp) {
            for (MPerspective p : ps.getChildren()) {
                if (p == persp || !p.isToBeRendered()) continue;
                ps.setSelectedElement((MUIElement)p);
                foundNewSelection = true;
                break;
            }
            if (!foundNewSelection) {
                ps.setSelectedElement(null);
            }
        }
        this.resetPerspectiveModel(persp, window, false);
        persp.setToBeRendered(false);
        ps.getChildren().remove(persp);
    }

    @Override
    public MPerspective getActivePerspective(MWindow window) {
        List<MPerspectiveStack> pStacks = this.findElements((MUIElement)window, null, MPerspectiveStack.class, null);
        if (pStacks.size() == 1) {
            return (MPerspective)pStacks.get(0).getSelectedElement();
        }
        return null;
    }

    @Override
    public int toBeRenderedCount(MElementContainer<?> container) {
        int count = 0;
        for (MUIElement child : container.getChildren()) {
            if (!child.isToBeRendered()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public MUIElement getContainer(MUIElement element) {
        if (element == null) {
            return null;
        }
        return (MUIElement)((EObject)element).eContainer();
    }

    @Override
    public int getElementLocation(MUIElement element) {
        if (element == null) {
            return 0;
        }
        if (element.getCurSharedRef() != null) {
            element = element.getCurSharedRef();
        }
        MUIElement curElement = element;
        while (curElement != null) {
            EObject container;
            MElementContainer parent = curElement.getParent();
            if (parent instanceof MPerspective) {
                MElementContainer perspectiveParent = parent.getParent();
                if (perspectiveParent == null) {
                    return 0;
                }
                if (perspectiveParent.getSelectedElement() == parent) {
                    return 2;
                }
                return 4;
            }
            if (parent instanceof MApplication) {
                return 1;
            }
            if (parent instanceof MTrimBar) {
                return 16;
            }
            if (parent == null && (container = ((EObject)curElement).eContainer()) instanceof MWindow) {
                MWindow containerWin = (MWindow)container;
                if (containerWin.getSharedElements().contains(curElement)) {
                    return 8;
                }
                EObject containerParent = container.eContainer();
                if (containerParent instanceof MPerspective) {
                    MElementContainer perspectiveParent = ((MPerspective)containerParent).getParent();
                    if (perspectiveParent == null) {
                        return 0;
                    }
                    int location = 4;
                    if (perspectiveParent.getSelectedElement() == containerParent) {
                        location |= 2;
                    }
                    return location;
                }
                if (containerParent instanceof MWindow) {
                    return 1;
                }
                return 0;
            }
            curElement = parent;
        }
        return 0;
    }

    @Override
    public MPartDescriptor getPartDescriptor(String id) {
        MApplication application = (MApplication)this.appContext.get(MApplication.class);
        int colonIndex = id == null ? -1 : id.indexOf(58);
        String descId = colonIndex == -1 ? id : id.substring(0, colonIndex);
        for (MPartDescriptor descriptor : application.getDescriptors()) {
            if (!descriptor.getElementId().equals(descId)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public void hideLocalPlaceholders(MWindow window, MPerspective perspective) {
        List<MPlaceholder> globals = this.findElements((MUIElement)window, null, MPlaceholder.class, null, 9);
        List<MPerspective> persps = new ArrayList<MPerspective>();
        if (perspective != null) {
            persps.add(perspective);
        } else {
            persps = this.findElements((MUIElement)window, null, MPerspective.class, null);
        }
        for (MPerspective persp : persps) {
            List<MPlaceholder> locals = this.findElements((MUIElement)persp, null, MPlaceholder.class, null, 4);
            for (MPlaceholder local : locals) {
                for (MPlaceholder global : globals) {
                    if (global.getRef() != local.getRef()) continue;
                    local.setToBeRendered(false);
                    MElementContainer localParent = local.getParent();
                    this.setStackVisibility((MElementContainer<MUIElement>)localParent);
                }
            }
        }
    }

    private void setStackVisibility(MElementContainer<MUIElement> parent) {
        for (MUIElement child : parent.getChildren()) {
            if (!child.isToBeRendered() || !child.isVisible()) continue;
            parent.setToBeRendered(true);
            return;
        }
        parent.setToBeRendered(false);
        this.setStackVisibility((MElementContainer<MUIElement>)parent.getParent());
    }

    @Override
    public boolean isLastEditorStack(MUIElement stack) {
        if (!(stack instanceof MPartStack)) {
            return false;
        }
        MElementContainer parent = stack.getParent();
        while (parent != null && !(parent instanceof MArea)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return false;
        }
        MArea area = (MArea)parent;
        List<MPartStack> stacks = this.findElements((MUIElement)area, null, MPartStack.class, null);
        int count = 0;
        for (MPartStack aStack : stacks) {
            if (!aStack.isToBeRendered()) continue;
            ++count;
        }
        return count < 2 && stack.isToBeRendered();
    }

    @Override
    public void hostElement(MUIElement element, MWindow hostWindow, Object uiContainer, IEclipseContext hostContext) {
        hostWindow.getSharedElements().add(element);
        element.getTags().add(HOSTED_ELEMENT);
        IPresentationEngine renderer = (IPresentationEngine)hostWindow.getContext().get(IPresentationEngine.class);
        renderer.createGui(element, uiContainer, hostContext);
    }

    @Override
    public boolean isHostedElement(MUIElement element, MWindow hostWindow) {
        Object curElement = element;
        while (curElement != null && !curElement.getTags().contains(HOSTED_ELEMENT)) {
            curElement = curElement.getCurSharedRef() != null ? curElement.getCurSharedRef() : curElement.getParent();
        }
        if (curElement == null) {
            return false;
        }
        return hostWindow.getSharedElements().contains(curElement);
    }
}

