/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.model.binary;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.model.binary.IBinaryModule;

public class SourceMapper {
    private Map<IModelElement, Range> sourceRanges = new HashMap<IModelElement, Range>();
    private Map<IModelElement, Range> nameRanges = new HashMap<IModelElement, Range>();
    private IPath sourcePath;
    private Set<IBinaryModule> sourcesNotPressent = new HashSet<IBinaryModule>();
    private Map<IBinaryModule, String> sourcesMap = new WeakHashMap<IBinaryModule, String>();

    public SourceMapper(IPath sourcePath, IPath sourceAttachmentRootPath) {
        this.sourcePath = sourcePath;
    }

    private ISourceRange getRange(Range range) {
        if (range == null) {
            return SourceRange.UNKNOWN_RANGE;
        }
        return new SourceRange(range.start, range.end - range.start + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISourceRange getSourceRange(IModelElement element) {
        this.fetchRangesForElement(element);
        Range range = null;
        Map<IModelElement, Range> map = this.sourceRanges;
        synchronized (map) {
            range = this.sourceRanges.get(element);
        }
        return this.getRange(range);
    }

    protected void fetchRangesForElement(IModelElement element) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISourceRange getNameRange(IModelElement element) {
        this.fetchRangesForElement(element);
        Range range = null;
        Map<IModelElement, Range> map = this.sourceRanges;
        synchronized (map) {
            range = this.nameRanges.get(element);
        }
        return this.getRange(range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportType(IElementRequestor.TypeInfo info, IType type) {
        Map<IModelElement, Range> map = this.sourceRanges;
        synchronized (map) {
            this.nameRanges.put(type, new Range(info.nameSourceStart, info.nameSourceEnd));
            this.sourceRanges.put(type, new Range(info.declarationStart, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportField(IElementRequestor.FieldInfo info, IField field) {
        Map<IModelElement, Range> map = this.sourceRanges;
        synchronized (map) {
            this.nameRanges.put(field, new Range(info.nameSourceStart, info.nameSourceEnd));
            this.sourceRanges.put(field, new Range(info.declarationStart, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportMethod(IElementRequestor.MethodInfo info, IMethod method) {
        Map<IModelElement, Range> map = this.sourceRanges;
        synchronized (map) {
            this.nameRanges.put(method, new Range(info.nameSourceStart, info.nameSourceEnd));
            this.sourceRanges.put(method, new Range(info.declarationStart, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRangeEnd(IModelElement element, int declarationEnd) {
        Range range = null;
        Map<IModelElement, Range> map = this.sourceRanges;
        synchronized (map) {
            range = this.sourceRanges.get(element);
        }
        if (range != null) {
            range.end = declarationEnd;
        }
    }

    public String getSource(IBinaryModule binaryModule) {
        if (this.sourcesNotPressent.contains(binaryModule)) {
            return null;
        }
        String content = this.sourcesMap.get(binaryModule);
        if (content != null) {
            return content;
        }
        String source = this.findSource(binaryModule, binaryModule.getElementName());
        if (source != null) {
            this.sourcesMap.put(binaryModule, source);
        } else {
            this.sourcesNotPressent.add(binaryModule);
        }
        return source;
    }

    protected String findSource(IBinaryModule binaryModule, String filename) {
        File file = this.sourcePath.toFile();
        if (file.isDirectory()) {
            File result = this.traversePath(file, filename);
            if (result != null) {
                try {
                    return new String(Util.getFileByteContent(result));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.isArchive(file)) {
            return this.findSourceInArchive(file, filename);
        }
        return null;
    }

    protected String findSourceInArchive(File file, String filename) {
        return null;
    }

    public boolean isArchive(File file) {
        return false;
    }

    private File traversePath(File file, String filename) {
        File[] listFiles;
        File[] fileArray = listFiles = file.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                File result = this.traversePath(child, filename);
                if (result != null) {
                    return result;
                }
            } else if (this.isFileMatch(child, filename)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    protected boolean isFileMatch(File child, String filename) {
        return child.getName().equals(filename);
    }

    private static class Range {
        int start;
        int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

