/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.eclipse.e4.ui.internal.css.swt.ICTabRendering;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;

public class CTabRendering
extends CTabFolderRenderer
implements ICTabRendering {
    static final int LEFT_TOP = 0;
    static final int LEFT_BOTTOM = 1;
    static final int RIGHT_TOP = 2;
    static final int RIGHT_BOTTOM = 3;
    static final int SIDE_DROP_WIDTH = 3;
    static final int BOTTOM_DROP_WIDTH = 4;
    static final int OUTER_KEYLINE = 1;
    static final int INNER_KEYLINE = 0;
    static final int TOP_KEYLINE = 0;
    static final int ITEM_TOP_MARGIN = 2;
    static final int ITEM_BOTTOM_MARGIN = 6;
    static final int ITEM_LEFT_MARGIN = 4;
    static final int ITEM_RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final String E4_TOOLBAR_ACTIVE_IMAGE = "org.eclipse.e4.renderer.toolbar_background_active_image";
    static final String E4_TOOLBAR_INACTIVE_IMAGE = "org.eclipse.e4.renderer.toolbar_background_inactive_image";
    private static final String TOOLBAR_CONTAINER = "CTabRendering.toolbarContainer";
    int[] shape;
    Image shadowImage;
    Image toolbarActiveImage;
    Image toolbarInactiveImage;
    int cornerSize = 14;
    boolean shadowEnabled = true;
    Color shadowColor;
    Color outerKeyline;
    Color innerKeyline;
    Color[] activeToolbar;
    int[] activePercents;
    Color[] inactiveToolbar;
    int[] inactivePercents;
    boolean active;
    Color[] selectedTabFillColors;
    int[] selectedTabFillPercents;
    Color[] unselectedTabsColors;
    int[] unselectedTabsPercents;
    Color tabOutlineColor;
    int paddingLeft = 0;
    int paddingRight = 0;
    int paddingTop = 0;
    int paddingBottom = 0;
    private CTabFolderRendererWrapper rendererWrapper;
    private CTabFolderWrapper parentWrapper;

    @Inject
    public CTabRendering(CTabFolder parent) {
        super(parent);
        this.parentWrapper = new CTabFolderWrapper(parent);
        this.rendererWrapper = new CTabFolderRendererWrapper(this);
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        boolean onBottom = this.parent.getTabPosition() == 1024;
        int borderTop = onBottom ? 1 : 1;
        int borderBottom = onBottom ? 1 : 1;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int sideDropWidth = this.shadowEnabled ? 3 : 0;
        switch (part) {
            case -1: {
                if (state == 4) {
                    x = -1 - this.paddingLeft;
                    int tabHeight = this.parent.getTabHeight() + 1;
                    y = onBottom ? y - this.paddingTop - marginHeight - borderTop - this.cornerSize / 4 : y - this.paddingTop - marginHeight - tabHeight - borderTop - this.cornerSize / 4;
                    width = 2 + this.paddingLeft + this.paddingRight;
                    height += this.paddingTop + this.paddingBottom;
                    height += tabHeight + this.cornerSize / 4 + borderBottom + borderTop;
                    break;
                }
                x = x - marginWidth - 1 - 0 - sideDropWidth - this.cornerSize / 2;
                width = width + 2 + 0 + 2 * marginWidth + 2 * sideDropWidth + this.cornerSize;
                int tabHeight = this.parent.getTabHeight() + 1;
                if (this.parent.getMinimized()) {
                    y = onBottom ? y - borderTop - 5 : y - tabHeight - borderTop - 5;
                    height = borderTop + borderBottom + tabHeight;
                    break;
                }
                y = onBottom ? y - marginHeight - borderTop - this.cornerSize / 4 : y - marginHeight - tabHeight - borderTop - this.cornerSize / 4;
                height = height + borderBottom + borderTop + 2 * marginHeight + tabHeight + this.cornerSize / 2 + this.cornerSize / 4 + (this.shadowEnabled ? 4 : 0);
                break;
            }
            case -2: {
                x = x - 1 - sideDropWidth;
                width += 2 * (1 + sideDropWidth);
                break;
            }
            case -3: {
                x = x - 0 - 1 - sideDropWidth - this.cornerSize / 4;
                width = width + 2 * (1 + sideDropWidth) + this.cornerSize / 2;
                height = height + borderTop + borderBottom;
                y -= borderTop;
                if (!onBottom || !this.shadowEnabled) break;
                height += 3;
                break;
            }
            default: {
                if (part < 0 || part >= this.parent.getItemCount()) break;
                x -= 4;
                width = width + 4 + 4 + 1;
                y -= 2;
                height = height + 2 + 6;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        wHint += this.paddingLeft + this.paddingRight;
        hHint += this.paddingTop + this.paddingBottom;
        if (part >= 0 && part < this.parent.getItemCount()) {
            gc.setAdvanced(true);
            Point result = super.computeSize(part, state, gc, wHint, hHint);
            return result;
        }
        return super.computeSize(part, state, gc, wHint, hHint);
    }

    protected void dispose() {
        if (this.shadowImage != null && !this.shadowImage.isDisposed()) {
            this.shadowImage.dispose();
            this.shadowImage = null;
        }
        super.dispose();
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        switch (part) {
            case -4: {
                this.drawCustomBackground(gc, bounds, state);
                return;
            }
            case -1: {
                this.drawTabBody(gc, bounds, state);
                return;
            }
            case -2: {
                this.drawTabHeader(gc, bounds, state);
                return;
            }
        }
        if (part >= 0 && part < this.parent.getItemCount()) {
            gc.setAdvanced(true);
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            if ((state & 2) != 0) {
                this.drawSelectedTab(part, gc, bounds, state);
                super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
            } else {
                this.drawUnselectedTab(part, gc, bounds, state);
                if ((state & 0x20) == 0 && !this.active) {
                    gc.setAlpha(127);
                    super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
                    gc.setAlpha(255);
                } else {
                    super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
                }
            }
            return;
        }
        super.draw(part, state, bounds, gc);
    }

    void drawTabHeader(GC gc, Rectangle bounds, int state) {
        boolean onBottom = this.parent.getTabPosition() == 1024;
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 1 + 2 * (this.shadowEnabled ? 3 : 0) + 2 * marginWidth;
        int width = bounds.width - delta;
        int height = bounds.height - 0 - 1 - 2 * marginHeight - (this.shadowEnabled ? 4 : 0);
        int circX = bounds.x + delta / 2 + radius;
        int circY = bounds.y + radius;
        Region clipping = new Region();
        gc.getClipping(clipping);
        Region region = new Region();
        region.add(this.shape);
        region.intersect(clipping);
        gc.setClipping(region);
        int header = this.shadowEnabled ? (onBottom ? 6 : 3) : 1;
        Rectangle trim = this.computeTrim(-2, state, 0, 0, 0, 0);
        trim.width = bounds.width - trim.width;
        trim.height = this.parent.getTabHeight() + (onBottom ? 7 : 4) - trim.height;
        trim.x = -trim.x;
        trim.y = onBottom ? bounds.height - this.parent.getTabHeight() - 1 - header : -trim.y;
        this.draw(-4, 0, trim, gc);
        gc.setClipping(clipping);
        clipping.dispose();
        region.dispose();
        int[] ltt = CTabRendering.drawCircle(circX + 1, circY + 1, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = CTabRendering.drawCircle(circX + 1, circY + height - radius * 2 - 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = CTabRendering.drawCircle(circX + width - radius * 2 - 2, circY + height - radius * 2 - 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = CTabRendering.drawCircle(circX + width - radius * 2 - 2, circY + 1, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = points[0];
        points[index++] = points[1];
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        if (this.outerKeyline == null) {
            this.outerKeyline = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.outerKeyline);
        gc.drawPolyline(this.shape);
    }

    void drawTabBody(GC gc, Rectangle bounds, int state) {
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 1 + 2 * (this.shadowEnabled ? 3 : 0) + 2 * marginWidth;
        int width = bounds.width - delta;
        int height = Math.max(this.parent.getTabHeight() + 0 + 1 + (this.shadowEnabled ? 4 : 0), bounds.height - 0 - 1 - 2 * marginHeight - (this.shadowEnabled ? 4 : 0));
        int circX = bounds.x + delta / 2 + radius;
        int circY = bounds.y + radius;
        index = 0;
        int[] ltt = CTabRendering.drawCircle(circX, circY, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = CTabRendering.drawCircle(circX, circY + height - radius * 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = CTabRendering.drawCircle(circX + width - radius * 2, circY + height - radius * 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = CTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = circX;
        points[index++] = circY - radius;
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        gc.fillPolygon(tempPoints);
        Region r = new Region();
        r.add(bounds);
        r.subtract(tempPoints);
        gc.setBackground(this.parent.getParent().getBackground());
        Display display = this.parent.getDisplay();
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.intersect(clipping);
        gc.setClipping(r);
        Rectangle mappedBounds = display.map((Control)this.parent, (Control)this.parent.getParent(), bounds);
        this.parent.getParent().drawBackground(gc, bounds.x, bounds.y, bounds.width, bounds.height, mappedBounds.x, mappedBounds.y);
        if (this.shadowEnabled) {
            this.drawShadow(display, bounds, gc);
        }
        gc.setClipping(clipping);
        clipping.dispose();
        r.dispose();
        this.shape = tempPoints;
    }

    void drawSelectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        int selectionY2;
        int selectionX2;
        int[] rt;
        int[] ltt;
        int selectionY1;
        int selectionX1;
        int bottomY;
        if (this.parent.getSingle() && this.parent.getItem(itemIndex).isShowing()) {
            return;
        }
        boolean onBottom = this.parent.getTabPosition() == 1024;
        int header = this.shadowEnabled ? 2 : 0;
        int width = bounds.width;
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int circX = bounds.x + radius;
        int circY = onBottom ? bounds.y + bounds.height + 1 - header - radius : bounds.y - 1 + radius;
        int n = bottomY = onBottom ? bounds.y - header : bounds.y + bounds.height;
        if (itemIndex == 0 && bounds.x == -this.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).x) {
            points[index++] = --circX - radius;
            points[index++] = bottomY;
            points[index++] = selectionX1 = circX - radius;
            points[index++] = selectionY1 = bottomY;
        } else {
            if (this.active) {
                points[index++] = this.shadowEnabled ? 3 : 1;
                points[index++] = bottomY;
            }
            points[index++] = selectionX1 = bounds.x;
            points[index++] = selectionY1 = bottomY;
        }
        int startX = -1;
        int endX = -1;
        if (!onBottom) {
            ltt = CTabRendering.drawCircle(circX, circY, radius, 0);
            startX = ltt[6];
            int i = 0;
            while (i < ltt.length / 2) {
                int tmp = ltt[i];
                ltt[i] = ltt[ltt.length - i - 2];
                ltt[ltt.length - i - 2] = tmp;
                tmp = ltt[i + 1];
                ltt[i + 1] = ltt[ltt.length - i - 1];
                ltt[ltt.length - i - 1] = tmp;
                i += 2;
            }
            System.arraycopy(ltt, 0, points, index, ltt.length);
            index += ltt.length;
            rt = CTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
            endX = rt[rt.length - 4];
            int i2 = 0;
            while (i2 < rt.length / 2) {
                int tmp = rt[i2];
                rt[i2] = rt[rt.length - i2 - 2];
                rt[rt.length - i2 - 2] = tmp;
                tmp = rt[i2 + 1];
                rt[i2 + 1] = rt[rt.length - i2 - 1];
                rt[rt.length - i2 - 1] = tmp;
                i2 += 2;
            }
            System.arraycopy(rt, 0, points, index, rt.length);
            index += rt.length;
            points[index++] = selectionX2 = bounds.width + circX - radius;
            points[index++] = selectionY2 = bounds.y + bounds.height;
        } else {
            ltt = CTabRendering.drawCircle(circX, circY, radius, 1);
            startX = ltt[6];
            System.arraycopy(ltt, 0, points, index, ltt.length);
            rt = CTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 3);
            endX = rt[rt.length - 4];
            System.arraycopy(rt, 0, points, index += ltt.length, rt.length);
            index += rt.length;
            points[index++] = selectionX2 = bounds.width + circX - radius;
            points[index++] = selectionY2 = bottomY;
        }
        if (this.active) {
            points[index++] = this.parent.getSize().x - (this.shadowEnabled ? 3 : 1);
            points[index++] = bottomY;
        }
        gc.setClipping(0, onBottom ? bounds.y - header : bounds.y, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
        Pattern backgroundPattern = null;
        if (this.selectedTabFillColors == null) {
            this.setSelectedTabFill(gc.getDevice().getSystemColor(1));
        }
        if (this.selectedTabFillColors.length == 1) {
            gc.setBackground(this.selectedTabFillColors[0]);
            gc.setForeground(this.selectedTabFillColors[0]);
        } else if (!onBottom && this.selectedTabFillColors.length == 2) {
            backgroundPattern = new Pattern(gc.getDevice(), 0.0f, 0.0f, 0.0f, (float)(bounds.height + 1), this.selectedTabFillColors[0], this.selectedTabFillColors[1]);
            gc.setBackgroundPattern(backgroundPattern);
            gc.setForeground(this.selectedTabFillColors[1]);
        }
        int[] tmpPoints = new int[index];
        System.arraycopy(points, 0, tmpPoints, 0, index);
        gc.fillPolygon(tmpPoints);
        gc.drawLine(selectionX1, selectionY1, selectionX2, selectionY2);
        if (this.tabOutlineColor == null) {
            this.tabOutlineColor = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.tabOutlineColor);
        Color gradientLineTop = null;
        Pattern foregroundPattern = null;
        if (!this.active && !onBottom) {
            RGB blendColor = gc.getDevice().getSystemColor(19).getRGB();
            RGB topGradient = CTabRendering.blend(blendColor, this.tabOutlineColor.getRGB(), 40);
            gradientLineTop = new Color(gc.getDevice(), topGradient);
            foregroundPattern = new Pattern(gc.getDevice(), 0.0f, 0.0f, 0.0f, (float)(bounds.height + 1), gradientLineTop, gc.getDevice().getSystemColor(1));
            gc.setForegroundPattern(foregroundPattern);
        }
        gc.drawPolyline(tmpPoints);
        Rectangle rect = null;
        gc.setClipping(rect);
        if (this.active) {
            if (this.outerKeyline == null) {
                this.outerKeyline = gc.getDevice().getSystemColor(3);
            }
            gc.setForeground(this.outerKeyline);
            gc.drawPolyline(this.shape);
        } else if (!onBottom) {
            gc.drawLine(startX, 0, endX, 0);
        }
        if (backgroundPattern != null) {
            backgroundPattern.dispose();
        }
        if (gradientLineTop != null) {
            gradientLineTop.dispose();
        }
        if (foregroundPattern != null) {
            foregroundPattern.dispose();
        }
    }

    void drawUnselectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        if ((state & 0x20) != 0) {
            int[] rt;
            int[] ltt;
            int header = this.shadowEnabled ? 2 : 0;
            int width = bounds.width;
            boolean onBottom = this.parent.getTabPosition() == 1024;
            int[] points = new int[1024];
            int[] inactive = new int[8];
            int index = 0;
            int inactive_index = 0;
            int radius = this.cornerSize / 2;
            int circX = bounds.x + radius;
            int circY = onBottom ? bounds.y + bounds.height + 1 - header - radius : bounds.y - 1 + radius;
            int bottomY = onBottom ? bounds.y - header : bounds.y + bounds.height;
            int leftIndex = circX;
            if (itemIndex == 0) {
                if (this.parent.getSelectionIndex() != 0) {
                    --leftIndex;
                }
                points[index++] = leftIndex - radius;
                points[index++] = bottomY;
            } else {
                points[index++] = bounds.x;
                points[index++] = bottomY;
            }
            if (!this.active) {
                System.arraycopy(points, 0, inactive, 0, index);
                inactive_index += 2;
            }
            int rightIndex = circX - 1;
            if (!onBottom) {
                ltt = CTabRendering.drawCircle(leftIndex, circY, radius, 0);
                int i = 0;
                while (i < ltt.length / 2) {
                    int tmp = ltt[i];
                    ltt[i] = ltt[ltt.length - i - 2];
                    ltt[ltt.length - i - 2] = tmp;
                    tmp = ltt[i + 1];
                    ltt[i + 1] = ltt[ltt.length - i - 1];
                    ltt[ltt.length - i - 1] = tmp;
                    i += 2;
                }
                System.arraycopy(ltt, 0, points, index, ltt.length);
                index += ltt.length;
                if (!this.active) {
                    System.arraycopy(ltt, 0, inactive, inactive_index, 2);
                    inactive_index += 2;
                }
                rt = CTabRendering.drawCircle(rightIndex + width - radius * 2, circY, radius, 2);
                int i2 = 0;
                while (i2 < rt.length / 2) {
                    int tmp = rt[i2];
                    rt[i2] = rt[rt.length - i2 - 2];
                    rt[rt.length - i2 - 2] = tmp;
                    tmp = rt[i2 + 1];
                    rt[i2 + 1] = rt[rt.length - i2 - 1];
                    rt[rt.length - i2 - 1] = tmp;
                    i2 += 2;
                }
                System.arraycopy(rt, 0, points, index, rt.length);
                index += rt.length;
                if (!this.active) {
                    System.arraycopy(rt, rt.length - 4, inactive, inactive_index, 2);
                    int n = inactive_index;
                    inactive[n] = inactive[n] - 1;
                    inactive_index += 2;
                }
            } else {
                ltt = CTabRendering.drawCircle(leftIndex, circY, radius, 1);
                System.arraycopy(ltt, 0, points, index, ltt.length);
                index += ltt.length;
                if (!this.active) {
                    System.arraycopy(ltt, 0, inactive, inactive_index, 2);
                    inactive_index += 2;
                }
                rt = CTabRendering.drawCircle(rightIndex + width - radius * 2, circY, radius, 3);
                System.arraycopy(rt, 0, points, index, rt.length);
                index += rt.length;
                if (!this.active) {
                    System.arraycopy(rt, rt.length - 4, inactive, inactive_index, 2);
                    int n = inactive_index;
                    inactive[n] = inactive[n] - 1;
                    inactive_index += 2;
                }
            }
            points[index++] = bounds.width + rightIndex - radius;
            points[index++] = bottomY;
            if (!this.active) {
                System.arraycopy(points, index - 2, inactive, inactive_index, 2);
                int n = inactive_index;
                inactive[n] = inactive[n] - 1;
                inactive_index += 2;
            }
            gc.setClipping(points[0], onBottom ? bounds.y - header : bounds.y, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
            gc.setBackground(gc.getDevice().getSystemColor(1));
            int[] tmpPoints = new int[index];
            System.arraycopy(points, 0, tmpPoints, 0, index);
            gc.fillPolygon(tmpPoints);
            Color tempBorder = new Color(gc.getDevice(), 182, 188, 204);
            gc.setForeground(tempBorder);
            tempBorder.dispose();
            if (this.active) {
                gc.drawPolyline(tmpPoints);
            } else {
                gc.drawLine(inactive[0], inactive[1], inactive[2], inactive[3]);
                gc.drawLine(inactive[4], inactive[5], inactive[6], inactive[7]);
            }
            Rectangle rect = null;
            gc.setClipping(rect);
            if (this.outerKeyline == null) {
                this.outerKeyline = gc.getDevice().getSystemColor(2);
            }
        }
    }

    static int[] drawCircle(int xC, int yC, int r, int circlePart) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int e = 0;
        int[] points = new int[1024];
        int[] pointsMirror = new int[1024];
        int loop = 0;
        int loopMirror = 0;
        while (x < y) {
            if (circlePart == 3) {
                points[loop++] = xC + x;
                points[loop++] = yC + y;
            }
            if (circlePart == 2) {
                points[loop++] = xC + y;
                points[loop++] = yC - x;
            }
            if (circlePart == 0) {
                points[loop++] = xC - x;
                points[loop++] = yC - y;
            }
            if (circlePart == 1) {
                points[loop++] = xC - y;
                points[loop++] = yC + x;
            }
            ++x;
            if (v < 2 * (e += (u += 2))) {
                --y;
                e -= v;
                v -= 2;
            }
            if (x > y) break;
            if (circlePart == 3) {
                pointsMirror[loopMirror++] = xC + y;
                pointsMirror[loopMirror++] = yC + x;
            }
            if (circlePart == 2) {
                pointsMirror[loopMirror++] = xC + x;
                pointsMirror[loopMirror++] = yC - y;
            }
            if (circlePart == 0) {
                pointsMirror[loopMirror++] = xC - y;
                pointsMirror[loopMirror++] = yC - x;
            }
            if (circlePart == 1) {
                pointsMirror[loopMirror++] = xC - x;
                pointsMirror[loopMirror++] = yC + y;
            }
            if (loop + 1 <= points.length) continue;
            int length = points.length * 2;
            int[] newPointTable = new int[length];
            int[] newPointTableMirror = new int[length];
            System.arraycopy(points, 0, newPointTable, 0, points.length);
            points = newPointTable;
            System.arraycopy(pointsMirror, 0, newPointTableMirror, 0, pointsMirror.length);
            pointsMirror = newPointTableMirror;
        }
        int[] finalArray = new int[loop + loopMirror];
        System.arraycopy(points, 0, finalArray, 0, loop);
        int i = loopMirror - 1;
        int j = loop;
        while (i > 0) {
            int tempX;
            int tempY = pointsMirror[i];
            finalArray[j] = tempX = pointsMirror[i - 1];
            finalArray[j + 1] = tempY;
            i -= 2;
            j += 2;
        }
        return finalArray;
    }

    static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = CTabRendering.blend(c1.red, c2.red, ratio);
        int g = CTabRendering.blend(c1.green, c2.green, ratio);
        int b = CTabRendering.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    void drawShadow(Display display, Rectangle bounds, GC gc) {
        if (this.shadowImage == null) {
            this.createShadow(display);
        }
        int x = bounds.x;
        int y = bounds.y;
        int SIZE = this.shadowImage.getBounds().width / 3;
        int height = Math.max(bounds.height, SIZE * 2);
        int width = Math.max(bounds.width, SIZE * 2);
        gc.drawImage(this.shadowImage, 0, 0, SIZE, SIZE, 2, 10, SIZE, 20);
        int fillHeight = height - SIZE * 2;
        int fillWidth = width + 5 - SIZE * 2;
        int xFill = 0;
        int i = SIZE;
        while (i < fillHeight) {
            xFill = i;
            gc.drawImage(this.shadowImage, 0, SIZE, SIZE, SIZE, 2, i, SIZE, SIZE);
            i += SIZE;
        }
        gc.drawImage(this.shadowImage, 0, SIZE, SIZE, fillHeight - xFill, 2, xFill + SIZE, SIZE, fillHeight - xFill);
        gc.drawImage(this.shadowImage, 0, 40, 20, 20, 2, y + height - SIZE, 20, 20);
        int yFill = 0;
        int i2 = SIZE;
        while (i2 <= fillWidth) {
            yFill = i2;
            gc.drawImage(this.shadowImage, SIZE, SIZE * 2, SIZE, SIZE, i2, y + height - SIZE, SIZE, SIZE);
            i2 += SIZE;
        }
        gc.drawImage(this.shadowImage, SIZE, SIZE * 2, fillWidth - yFill, SIZE, yFill + SIZE, y + height - SIZE, fillWidth - yFill, SIZE);
        gc.drawImage(this.shadowImage, SIZE * 2, SIZE * 2, SIZE, SIZE, x + width - SIZE - 1, y + height - SIZE, SIZE, SIZE);
        gc.drawImage(this.shadowImage, SIZE * 2, 0, SIZE, SIZE, x + width - SIZE - 1, 10, SIZE, SIZE);
        xFill = 0;
        i2 = SIZE;
        while (i2 < fillHeight) {
            xFill = i2;
            gc.drawImage(this.shadowImage, SIZE * 2, SIZE, SIZE, SIZE, x + width - SIZE - 1, i2, SIZE, SIZE);
            i2 += SIZE;
        }
        gc.drawImage(this.shadowImage, SIZE * 2, SIZE, SIZE, fillHeight - xFill, x + width - SIZE - 1, xFill + SIZE, SIZE, fillHeight - xFill);
    }

    void createShadow(Display display) {
        if (this.shadowImage != null) {
            this.shadowImage.dispose();
            this.shadowImage = null;
        }
        ImageData data = new ImageData(60, 60, 32, new PaletteData(0xFF0000, 65280, 255));
        Image tmpImage = this.shadowImage = new Image((Device)display, data);
        GC gc = new GC((Drawable)tmpImage);
        if (this.shadowColor == null) {
            this.shadowColor = gc.getDevice().getSystemColor(15);
        }
        gc.setBackground(this.shadowColor);
        this.drawTabBody(gc, new Rectangle(0, 0, 60, 60), 0);
        ImageData blured = this.blur(tmpImage, 5, 25);
        this.shadowImage = new Image((Device)display, blured);
        tmpImage.dispose();
    }

    public ImageData blur(Image src, int radius, int sigma) {
        float[] kernel = this.create1DKernel(radius, sigma);
        ImageData imgPixels = src.getImageData();
        int width = imgPixels.width;
        int height = imgPixels.height;
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                RGB rgb = imgPixels.palette.getRGB(imgPixels.getPixel(x, y));
                inPixels[offset] = rgb.red == 255 && rgb.green == 255 && rgb.blue == 255 ? rgb.red << 16 | rgb.green << 8 | rgb.blue : imgPixels.getAlpha(x, y) << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue;
                ++offset;
                ++x;
            }
            ++y;
        }
        this.convolve(kernel, inPixels, outPixels, width, height, true);
        this.convolve(kernel, outPixels, inPixels, height, width, true);
        ImageData dst = new ImageData(imgPixels.width, imgPixels.height, 24, new PaletteData(0xFF0000, 65280, 255));
        dst.setPixels(0, 0, inPixels.length, inPixels, 0);
        offset = 0;
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                if (inPixels[offset] == -1) {
                    dst.setAlpha(x, y2, 0);
                } else {
                    int a = inPixels[offset] >> 24 & 0xFF;
                    dst.setAlpha(x, y2, a);
                }
                ++offset;
                ++x;
            }
            ++y2;
        }
        return dst;
    }

    private void convolve(float[] kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        int kernelWidth = kernel.length;
        int kernelMid = kernelWidth / 2;
        int y = 0;
        while (y < height) {
            int index = y;
            int currentLine = y * width;
            int x = 0;
            while (x < width) {
                float a = 0.0f;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                int k = -kernelMid;
                while (k <= kernelMid) {
                    float val = kernel[k + kernelMid];
                    int xcoord = x + k;
                    if (xcoord < 0) {
                        xcoord = 0;
                    }
                    if (xcoord >= width) {
                        xcoord = width - 1;
                    }
                    int pixel = inPixels[currentLine + xcoord];
                    a += val * (float)(pixel >> 24 & 0xFF);
                    r += val * (float)(pixel >> 16 & 0xFF);
                    g += val * (float)(pixel >> 8 & 0xFF);
                    b += val * (float)(pixel & 0xFF);
                    ++k;
                }
                int ia = alpha ? this.clamp((int)((double)a + 0.5)) : 255;
                int ir = this.clamp((int)((double)r + 0.5));
                int ig = this.clamp((int)((double)g + 0.5));
                int ib = this.clamp((int)((double)b + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
                ++x;
            }
            ++y;
        }
    }

    private int clamp(int value) {
        if (value > 255) {
            return 255;
        }
        if (value < 0) {
            return 0;
        }
        return value;
    }

    private float[] create1DKernel(int radius, int sigma) {
        int size = radius * 2 + 1;
        float[] kernel = new float[size];
        int radiusSquare = radius * radius;
        float sigmaSquare = 2 * sigma * sigma;
        float piSigma = (float)Math.PI * 2 * (float)sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(piSigma);
        int start = size / 2;
        int index = 0;
        float total = 0.0f;
        int i = -start;
        while (i <= start) {
            float d = i * i;
            kernel[index] = d > (float)radiusSquare ? 0.0f : (float)Math.exp(-d / sigmaSquare) / sqrtSigmaPi2;
            total += kernel[index];
            ++index;
            ++i;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            kernel[n] = kernel[n] / total;
        }
        return kernel;
    }

    public Rectangle getPadding() {
        return new Rectangle(this.paddingTop, this.paddingRight, this.paddingBottom, this.paddingLeft);
    }

    public void setPadding(int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.parent.redraw();
    }

    public void setCornerRadius(int radius) {
        this.cornerSize = radius;
        this.parent.redraw();
    }

    public void setShadowVisible(boolean visible) {
        this.shadowEnabled = visible;
        this.parent.redraw();
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        this.createShadow(this.parent.getDisplay());
        this.parent.redraw();
    }

    public void setOuterKeyline(Color color) {
        this.outerKeyline = color;
        if (color != null) {
            this.setActive(color.getRed() != 255 || color.getGreen() != 255 || color.getBlue() != 255);
        }
        this.parent.redraw();
    }

    public void setSelectedTabFill(Color color) {
        this.setSelectedTabFill(new Color[]{color}, new int[]{100});
    }

    public void setSelectedTabFill(Color[] colors, int[] percents) {
        this.selectedTabFillColors = colors;
        this.selectedTabFillPercents = percents;
        this.parent.redraw();
    }

    public void setUnselectedTabsColor(Color color) {
        this.setUnselectedTabsColor(new Color[]{color}, new int[]{100});
    }

    public void setUnselectedTabsColor(Color[] colors, int[] percents) {
        this.unselectedTabsColors = colors;
        this.unselectedTabsPercents = percents;
        this.parent.redraw();
    }

    public void setTabOutline(Color color) {
        this.tabOutlineColor = color;
        this.parent.redraw();
    }

    public void setInnerKeyline(Color color) {
        this.innerKeyline = color;
        this.parent.redraw();
    }

    public void setActiveToolbarGradient(Color[] color, int[] percents) {
        this.activeToolbar = color;
        this.activePercents = percents;
    }

    public void setInactiveToolbarGradient(Color[] color, int[] percents) {
        this.inactiveToolbar = color;
        this.inactivePercents = percents;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private void drawCustomBackground(GC gc, Rectangle bounds, int state) {
        boolean selected = (state & 2) != 0;
        Color defaultBackground = selected ? this.parent.getSelectionBackground() : this.parent.getBackground();
        boolean vertical = selected ? this.parentWrapper.isSelectionGradientVertical() : this.parentWrapper.isGradientVertical();
        Rectangle partHeaderBounds = this.computeTrim(-2, state, bounds.x, bounds.y, bounds.width, bounds.height);
        this.drawUnselectedTabBackground(gc, partHeaderBounds, state, vertical, defaultBackground);
        this.drawTabBackground(gc, partHeaderBounds, state, vertical, defaultBackground);
    }

    private void drawUnselectedTabBackground(GC gc, Rectangle partHeaderBounds, int state, boolean vertical, Color defaultBackground) {
        this.rendererWrapper.drawBackground(gc, partHeaderBounds.x, partHeaderBounds.y - 1, partHeaderBounds.width, partHeaderBounds.height, defaultBackground, this.getUnselectedTabsColors(state), this.getUnselectedTabsPercents(state), vertical);
    }

    private Color[] getUnselectedTabsColors(int state) {
        if (this.unselectedTabsColors == null) {
            return (state & 2) != 0 ? this.parentWrapper.getSelectionGradientColors() : this.parentWrapper.getGradientColors();
        }
        return this.unselectedTabsColors;
    }

    private int[] getUnselectedTabsPercents(int state) {
        if (this.unselectedTabsPercents == null) {
            return (state & 2) != 0 ? this.parentWrapper.getSelectionGradientPercents() : this.parentWrapper.getGradientPercents();
        }
        return this.unselectedTabsPercents;
    }

    private void drawTabBackground(GC gc, Rectangle partHeaderBounds, int state, boolean vertical, Color defaultBackground) {
        Control control;
        Color[] colors = this.selectedTabFillColors;
        int[] percents = this.selectedTabFillPercents;
        if (colors != null && colors.length == 2) {
            colors = new Color[]{colors[1], colors[1]};
        }
        if (colors == null) {
            boolean selected = (state & 2) != 0;
            colors = selected ? this.parentWrapper.getSelectionGradientColors() : this.parentWrapper.getGradientColors();
            int[] nArray = percents = selected ? this.parentWrapper.getSelectionGradientPercents() : this.parentWrapper.getGradientPercents();
        }
        if (colors == null) {
            colors = new Color[]{gc.getDevice().getSystemColor(1)};
            percents = new int[]{100};
        }
        this.rendererWrapper.drawBackground(gc, partHeaderBounds.x, partHeaderBounds.height - 1, partHeaderBounds.width, this.parent.getBounds().height, defaultBackground, colors, percents, vertical);
        int selectedItemWidth = this.parent.getBounds().width;
        if (this.parent.getSelectionIndex() > -1 && (control = this.parent.getSelection().getControl()) != null) {
            selectedItemWidth = control.getBounds().width;
        }
        int leftRightBorder = (this.parent.getBounds().width - selectedItemWidth) / 2;
        int topBorder = 1;
        Control toolbarContainer = this.findToolbarContainer();
        if (toolbarContainer != null && toolbarContainer.getBounds().height > 0) {
            int unselectedHeightToDraw = Math.max(toolbarContainer.getBounds().height, partHeaderBounds.height);
            this.rendererWrapper.drawBackground(gc, partHeaderBounds.x + leftRightBorder, partHeaderBounds.height + topBorder, partHeaderBounds.width - leftRightBorder * 2, unselectedHeightToDraw, defaultBackground, this.getUnselectedTabsColors(state), this.getUnselectedTabsPercents(state), vertical);
        }
    }

    private Control findToolbarContainer() {
        Control control;
        Object obj = this.parent.getData(TOOLBAR_CONTAINER);
        if (obj instanceof Control && !(control = (Control)obj).isDisposed()) {
            return control;
        }
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                Control[] controlArray2 = ((Composite)child).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control subChild = controlArray2[n4];
                    if (subChild instanceof ToolBar && subChild.isVisible()) {
                        this.parent.setData(TOOLBAR_CONTAINER, (Object)child);
                        return child;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private static class CTabFolderRendererWrapper
    extends ReflectionSupport<CTabFolderRenderer> {
        private Method drawBackgroundMethod;

        public CTabFolderRendererWrapper(CTabFolderRenderer instance) {
            super(instance);
        }

        public void drawBackground(GC gc, int x, int y, int width, int height, Color defaultBackground, Color[] colors, int[] percents, boolean vertical) {
            if (this.drawBackgroundMethod == null) {
                this.drawBackgroundMethod = this.getMethod("drawBackground", GC.class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, Image.class, Color[].class, int[].class, Boolean.TYPE);
            }
            Object[] objectArray = new Object[11];
            objectArray[0] = gc;
            objectArray[2] = x;
            objectArray[3] = y;
            objectArray[4] = width;
            objectArray[5] = height;
            objectArray[6] = defaultBackground;
            objectArray[8] = colors;
            objectArray[9] = percents;
            objectArray[10] = vertical;
            this.executeMethod(this.drawBackgroundMethod, objectArray);
        }
    }

    private static class CTabFolderWrapper
    extends ReflectionSupport<CTabFolder> {
        private Field selectionGradientVerticalField;
        private Field gradientVerticalField;
        private Field selectionGradientColorsField;
        private Field selectionGradientPercentsField;
        private Field gradientColorsField;
        private Field gradientPercentsField;

        public CTabFolderWrapper(CTabFolder instance) {
            super(instance);
        }

        public boolean isSelectionGradientVertical() {
            Boolean result;
            if (this.selectionGradientVerticalField == null) {
                this.selectionGradientVerticalField = this.getField("selectionGradientVertical");
            }
            return (result = (Boolean)this.getFieldValue(this.selectionGradientVerticalField)) != null ? result : true;
        }

        public boolean isGradientVertical() {
            Boolean result;
            if (this.gradientVerticalField == null) {
                this.gradientVerticalField = this.getField("gradientVertical");
            }
            return (result = (Boolean)this.getFieldValue(this.gradientVerticalField)) != null ? result : true;
        }

        public Color[] getSelectionGradientColors() {
            if (this.selectionGradientColorsField == null) {
                this.selectionGradientColorsField = this.getField("selectionGradientColorsField");
            }
            return (Color[])this.getFieldValue(this.selectionGradientColorsField);
        }

        public int[] getSelectionGradientPercents() {
            if (this.selectionGradientPercentsField == null) {
                this.selectionGradientPercentsField = this.getField("selectionGradientPercents");
            }
            return (int[])this.getFieldValue(this.selectionGradientPercentsField);
        }

        public Color[] getGradientColors() {
            if (this.gradientColorsField == null) {
                this.gradientColorsField = this.getField("gradientColors");
            }
            return (Color[])this.getFieldValue(this.gradientColorsField);
        }

        public int[] getGradientPercents() {
            if (this.gradientPercentsField == null) {
                this.gradientPercentsField = this.getField("gradientPercents");
            }
            return (int[])this.getFieldValue(this.gradientPercentsField);
        }
    }

    private static class ReflectionSupport<T> {
        private T instance;

        public ReflectionSupport(T instance) {
            this.instance = instance;
        }

        protected Object getFieldValue(Field field) {
            Object value = null;
            if (field != null) {
                boolean accessible = field.isAccessible();
                try {
                    try {
                        field.setAccessible(true);
                        value = field.get(this.instance);
                    }
                    catch (Exception exception) {
                        field.setAccessible(accessible);
                    }
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
            return value;
        }

        protected Field getField(String name) {
            Class<?> cls = this.instance.getClass();
            while (!cls.equals(Object.class)) {
                try {
                    return cls.getDeclaredField(name);
                }
                catch (Exception exception) {
                    cls = cls.getSuperclass();
                }
            }
            return null;
        }

        protected Object executeMethod(Method method, Object ... params) {
            Object value = null;
            if (method != null) {
                boolean accessible = method.isAccessible();
                try {
                    try {
                        method.setAccessible(true);
                        value = method.invoke(this.instance, params);
                    }
                    catch (Exception exception) {
                        method.setAccessible(accessible);
                    }
                }
                finally {
                    method.setAccessible(accessible);
                }
            }
            return value;
        }

        protected Method getMethod(String name, Class<?> ... params) {
            Class<?> cls = this.instance.getClass();
            while (!cls.equals(Object.class)) {
                try {
                    return cls.getDeclaredMethod(name, params);
                }
                catch (Exception exception) {
                    cls = cls.getSuperclass();
                }
            }
            return null;
        }
    }
}

