/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.core.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.launching.DebugSessionAcceptor;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.koneki.ldt.debug.core.internal.attach.LuaAttachDebuggingEngineRunner;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.LuaRemoteDebugTarget;
import org.eclipse.koneki.ldt.remote.debug.core.internal.sshprocess.SshProcess;

public class LuaRemoteDebuggingEngineRunner
extends LuaAttachDebuggingEngineRunner {
    private SshProcess process;
    private String sessionId;
    private String remoteFolder;

    public LuaRemoteDebuggingEngineRunner(SshProcess process, String sessionId, String remoteFolder) {
        this.process = process;
        this.sessionId = sessionId;
        this.remoteFolder = remoteFolder;
    }

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeLaunch(launch, config, this.createPreferencesLookupDelegate(launch));
            ScriptDebugTarget target = (ScriptDebugTarget)launch.getDebugTarget();
            new DebugSessionAcceptor(target, monitor);
            this.startProcess();
        }
        catch (CoreException e) {
            launch.terminate();
            throw e;
        }
    }

    protected void startProcess() throws CoreException {
        this.process.start();
    }

    protected IScriptDebugTarget createDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        return new LuaRemoteDebugTarget(this.getDebugModelId(), dbgpService, this.sessionId, launch, this.process){

            protected String folder() {
                return LuaRemoteDebuggingEngineRunner.this.remoteFolder;
            }
        };
    }
}

