/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.actions.SystemRemoteFileSearchOpenWithMenu;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.services.search.IHostSearchResult;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewRemoteSearchResultAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    protected IPropertyDescriptor[] _propertyDescriptors;
    private SystemCopyToClipboardAction _copyOutputAction = null;

    public void addCommonRemoteActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (selection != null && !selection.isEmpty()) {
            Iterator iter = selection.iterator();
            boolean found = false;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof IHostSearchResult)) continue;
                found = true;
                break;
            }
            if (!found) {
                super.addCommonRemoteActions(menu, selection, shell, menuGroup);
            }
        } else {
            super.addCommonRemoteActions(menu, selection, shell, menuGroup);
        }
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        Object firstSelection = selection.getFirstElement();
        if (firstSelection != null) {
            if (this._copyOutputAction == null) {
                this._copyOutputAction = new SystemCopyToClipboardAction(shell, RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard());
            }
            menu.add(menuGroup, (IAction)this._copyOutputAction);
            if (selection.size() == 1 && firstSelection instanceof IHostSearchResult) {
                MenuManager submenu = new MenuManager(FileResources.ResourceNavigator_openWith, "group.openwith");
                SystemRemoteFileSearchOpenWithMenu openWithMenu = new SystemRemoteFileSearchOpenWithMenu();
                openWithMenu.updateSelection(selection);
                submenu.add((IContributionItem)openWithMenu);
                menu.getMenuManager().appendToGroup("group.openwith", (IContributionItem)submenu);
            }
        } else {
            return;
        }
    }

    public Object getParent(Object element) {
        if (element instanceof IHostSearchResult) {
            IHostSearchResult output = (IHostSearchResult)element;
            return output.getParent();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IHostSearchResult) {
            IHostSearchResult output = (IHostSearchResult)element;
            return output.getText();
        }
        return null;
    }

    public String getType(Object element) {
        return null;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return null;
    }

    public boolean hasChildren(IAdaptable element) {
        return false;
    }

    public static IRemoteFile outputToFile(IHostSearchResult output) {
        return (IRemoteFile)output.getParent();
    }

    public boolean handleDoubleClick(Object element) {
        IHostSearchResult searchResult;
        IRemoteFile file;
        boolean result = false;
        if (element instanceof IHostSearchResult && (file = SystemViewRemoteSearchResultAdapter.outputToFile(searchResult = (IHostSearchResult)element)) != null && file.isFile()) {
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)((IAdaptable)file).getAdapter(ISystemViewElementAdapter.class);
            result = adapter.handleDoubleClick((Object)file);
            int line = searchResult.getLine();
            if (result) {
                if (line > 0) {
                    DelayedGotoSearchResult dgoto = new DelayedGotoSearchResult(file, searchResult);
                    Display.getDefault().asyncExec((Runnable)dgoto);
                }
                return true;
            }
        }
        return result;
    }

    public ISubSystem getSubSystem(Object element) {
        IHostSearchResult output;
        Object parent;
        if (element instanceof IHostSearchResult && (parent = (output = (IHostSearchResult)element).getParent()) instanceof IRemoteFile) {
            return ((IRemoteFile)parent).getParentRemoteFileSubSystem();
        }
        return null;
    }

    public String getAbsoluteName(Object element) {
        if (element instanceof IHostSearchResult) {
            IHostSearchResult searchResult = (IHostSearchResult)element;
            StringBuffer buf = new StringBuffer();
            String str = this.getAbsoluteParentName(element);
            if (str == null) {
                return null;
            }
            buf.append(str);
            buf.append(":SEARCH");
            buf.append("<");
            buf.append(searchResult.getMatchingSearchString().toString());
            buf.append(":");
            buf.append(searchResult.getIndex());
            buf.append(">");
            return buf.toString();
        }
        return null;
    }

    public String getAbsoluteParentName(Object element) {
        ISystemRemoteElementAdapter parentAdapter;
        Object parent = this.getParent(element);
        if (parent != null && parent instanceof IRemoteFile && (parentAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)parent)) != null) {
            return parentAdapter.getAbsoluteName(parent);
        }
        return null;
    }

    public String getSubSystemConfigurationId(Object element) {
        return null;
    }

    public String getRemoteTypeCategory(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        return null;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteSubSubType(Object element) {
        return null;
    }

    public String getRemoteSourceType(Object element) {
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        if (element instanceof IHostSearchResult) {
            return ((IHostSearchResult)element).getParent();
        }
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public IPropertyDescriptor[] getUniquePropertyDescriptors() {
        return new IPropertyDescriptor[0];
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (this._propertyDescriptors == null) {
            this._propertyDescriptors = new PropertyDescriptor[2];
            int idx = -1;
            this._propertyDescriptors[++idx] = SystemViewRemoteSearchResultAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            this._propertyDescriptors[++idx] = SystemViewRemoteSearchResultAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.search.line", (String)FileResources.RESID_PROPERTY_SEARCH_LINE_LABEL, (String)FileResources.RESID_PROPERTY_SEARCH_LINE_TOOLTIP);
        }
        return this._propertyDescriptors;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        if (this.propertySourceInput instanceof IHostSearchResult) {
            IHostSearchResult output = (IHostSearchResult)this.propertySourceInput;
            if (name.equals("org.eclipse.rse.ui.file.path")) {
                return output.getAbsolutePath();
            }
            if (name.equals("org.eclipse.rse.ui.search.line")) {
                return new Integer(output.getLine());
            }
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof IHostSearchResult) {
            ImageDescriptor imageDescriptor = null;
            imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemsearchresultIcon");
            return imageDescriptor;
        }
        ImageDescriptor imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemblankIcon");
        return imageDescriptor;
    }

    public boolean showDelete(Object element) {
        return false;
    }

    public boolean canDelete(Object element) {
        return false;
    }

    public boolean showRefresh(Object element) {
        return false;
    }

    public boolean showOpenViewActions(Object element) {
        return false;
    }

    public boolean showRename(Object element) {
        return false;
    }

    public boolean canRename(Object element) {
        return false;
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) throws Exception {
        return false;
    }

    public boolean canDrop(Object element) {
        return false;
    }

    public boolean canDrag(Object element) {
        return element instanceof IHostSearchResult;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        if (element instanceof List) {
            ArrayList<String> resultSet = new ArrayList<String>();
            List set = (List)element;
            int i = 0;
            while (i < set.size()) {
                resultSet.add(this.getText(set.get(i)));
                ++i;
            }
            return resultSet;
        }
        return this.getText(element);
    }

    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        return false;
    }

    public Object doDrop(Object src, Object target, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        IRemoteFile folder = SystemViewRemoteSearchResultAdapter.outputToFile((IHostSearchResult)target);
        if (folder != null) {
            ISystemDragDropAdapter adapter = (ISystemDragDropAdapter)((IAdaptable)folder).getAdapter(ISystemDragDropAdapter.class);
            return adapter.doDrop(src, (Object)folder, sameSystemType, sameSystem, srcType, monitor);
        }
        return null;
    }

    public boolean canEdit(Object element) {
        IHostSearchResult output;
        IRemoteFile file;
        return element instanceof IHostSearchResult && (file = SystemViewRemoteSearchResultAdapter.outputToFile(output = (IHostSearchResult)element)) != null && file.isFile();
    }

    public ISystemEditableRemoteObject getEditableRemoteObject(Object element) {
        IHostSearchResult output;
        IRemoteFile file;
        if (element instanceof IHostSearchResult && (file = SystemViewRemoteSearchResultAdapter.outputToFile(output = (IHostSearchResult)element)) != null && file.isFile()) {
            return new SystemEditableRemoteFile(file);
        }
        return null;
    }

    public String getFilterStringFor(Object object) {
        return null;
    }

    public Object getPropertyValue(Object property, boolean formatted) {
        String name = (String)property;
        if (this.propertySourceInput instanceof IRemoteCommandShell) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)this.propertySourceInput;
            if (name.equals("org.eclipse.rse.ui.shell.status")) {
                if (cmdShell.isActive()) {
                    return FileResources.RESID_PROPERTY_SEARCH_STATUS_ACTIVE_VALUE;
                }
                return FileResources.RESID_PROPERTY_SEARCH_STATUS_INACTIVE_VALUE;
            }
            if (name.equals("org.eclipse.rse.ui.shell.context")) {
                Object context = cmdShell.getContext();
                if (context instanceof IRemoteFile) {
                    IRemoteFile cwd = (IRemoteFile)context;
                    return cwd.getAbsolutePath();
                }
                return context;
            }
        }
        return "";
    }

    public class DelayedGotoSearchResult
    implements Runnable {
        private IRemoteFile _file;
        private IHostSearchResult _searchResult;

        public DelayedGotoSearchResult(IRemoteFile file, IHostSearchResult searchResult) {
            this._file = file;
            this._searchResult = searchResult;
        }

        public void run() {
            if (this.checkEditorOpen()) {
                SystemRemoteFileSearchOpenWithMenu.handleGotoLine(this._file, this._searchResult);
            } else {
                DelayedGotoSearchResultJob job = new DelayedGotoSearchResultJob(this);
                job.schedule();
            }
        }

        private boolean checkEditorOpen() {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchPage persp = desktop.getActiveWorkbenchWindow().getActivePage();
            String fileName = this._file.getAbsolutePath();
            IEditorReference[] editors = persp.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IFileEditorInput input;
                IFile efile;
                SystemIFileProperties properties;
                String comparePath;
                IEditorInput einput;
                IEditorReference ref = editors[i];
                IEditorPart editorp = ref.getEditor(false);
                if (editorp != null && (einput = editorp.getEditorInput()) instanceof IFileEditorInput && (comparePath = (properties = new SystemIFileProperties((IResource)(efile = (input = (IFileEditorInput)einput).getFile()))).getRemoteFilePath()) != null && comparePath.replace('\\', '/').equals(fileName.replace('\\', '/'))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public class DelayedGotoSearchResultJob
    extends Job {
        private DelayedGotoSearchResult _gotoLine;

        public DelayedGotoSearchResultJob(DelayedGotoSearchResult gotoLine) {
            super("Goto Line");
            this._gotoLine = gotoLine;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)this._gotoLine);
            return Status.OK_STATUS;
        }
    }
}

