/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.ILinkHelperExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkHelperManager {
    private static final LinkHelperManager instance = new LinkHelperManager();
    private static final LinkHelperDescriptor[] NO_DESCRIPTORS = new LinkHelperDescriptor[0];
    private List descriptors;

    public static LinkHelperManager getInstance() {
        return instance;
    }

    private LinkHelperManager() {
        new LinkHelperRegistry().readRegistry();
    }

    public LinkHelperDescriptor[] getLinkHelpersFor(Object anObject, INavigatorContentService aContentService) {
        ArrayList<LinkHelperDescriptor> helpersList = new ArrayList<LinkHelperDescriptor>();
        LinkHelperDescriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (LinkHelperDescriptor)itr.next();
            if (!aContentService.isVisible(descriptor.getId()) || !descriptor.isEnabledFor(anObject)) continue;
            helpersList.add(descriptor);
        }
        if (helpersList.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return helpersList.toArray(new LinkHelperDescriptor[helpersList.size()]);
    }

    public LinkHelperDescriptor[] getLinkHelpersFor(IEditorInput anInput, INavigatorContentService aContentService) {
        ArrayList<LinkHelperDescriptor> helpersList = new ArrayList<LinkHelperDescriptor>();
        LinkHelperDescriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (LinkHelperDescriptor)itr.next();
            if (!aContentService.isVisible(descriptor.getId()) || !descriptor.isEnabledFor(anInput)) continue;
            helpersList.add(descriptor);
        }
        if (helpersList.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return helpersList.toArray(new LinkHelperDescriptor[helpersList.size()]);
    }

    protected List getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }

    private class LinkHelperRegistry
    extends RegistryReader
    implements ILinkHelperExtPtConstants {
        private LinkHelperRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, "linkHelper");
        }

        public boolean readElement(IConfigurationElement element) {
            if ("linkHelper".equals(element.getName())) {
                boolean[] retValue = new boolean[1];
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this, element, element, retValue){
                    final /* synthetic */ LinkHelperRegistry this$1;
                    private final /* synthetic */ IConfigurationElement val$element;
                    private final /* synthetic */ boolean[] val$retValue;
                    {
                        this.this$1 = linkHelperRegistry;
                        this.val$element = iConfigurationElement;
                        this.val$retValue = blArray;
                    }

                    public void run() throws Exception {
                        LinkHelperRegistry.access$1(this.this$1).getDescriptors().add(new LinkHelperDescriptor(this.val$element));
                        this.val$retValue[0] = true;
                    }
                });
                return retValue[0];
            }
            return false;
        }

        static /* synthetic */ LinkHelperManager access$1(LinkHelperRegistry linkHelperRegistry) {
            return linkHelperRegistry.LinkHelperManager.this;
        }
    }
}

