/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.protocols.omadm.client.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

final class DMStatusManager {
    private final Map<CommandNode, Map<String, ItemsNode>> itemsNodes = new HashMap<CommandNode, Map<String, ItemsNode>>();
    private final Queue<CommandNode> commandNodes = new LinkedList<CommandNode>();
    private final Map<CommandNode, Queue<String>> statusCodeNodes = new HashMap<CommandNode, Queue<String>>();
    private final Map<CommandNode, Boolean> isUnique = new HashMap<CommandNode, Boolean>();

    public void putStatus(String msgID, String cmdID, String cmd, String targetURI, String sourceURI, String statusCode) {
        this.putStatus(msgID, cmdID, cmd, targetURI, sourceURI, statusCode, null, null, null);
    }

    public void putStatus(String msgID, String cmdID, String cmd, String targetURI, String sourceURI, String statusCode, String format, String type, String data) {
        CommandNode commandNode = new CommandNode(msgID, cmdID, cmd);
        if (!this.itemsNodes.containsKey(commandNode)) {
            this.itemsNodes.put(commandNode, new HashMap());
            this.commandNodes.offer(commandNode);
            this.statusCodeNodes.put(commandNode, new LinkedList());
            this.isUnique.put(commandNode, true);
        }
        if (!this.itemsNodes.get(commandNode).containsKey(statusCode)) {
            this.itemsNodes.get(commandNode).put(statusCode, new ItemsNode());
            this.statusCodeNodes.get(commandNode).offer(statusCode);
            if (this.isUnique.get(commandNode).booleanValue() && this.itemsNodes.get(commandNode).keySet().size() >= 2) {
                this.isUnique.put(commandNode, false);
            }
        }
        if (targetURI != null) {
            this.itemsNodes.get(commandNode).get(statusCode).getTargetURI().add(targetURI);
            if (format != null && type != null && data != null) {
                List<Results> results = this.itemsNodes.get(commandNode).get(statusCode).getResults();
                Results newResultsNode = new Results(targetURI, format, type, data);
                results.add(newResultsNode);
                if (results.size() == 1) {
                    this.itemsNodes.get(commandNode).get(statusCode).setFormat(format);
                    this.itemsNodes.get(commandNode).get(statusCode).setType(type);
                } else {
                    String globalType;
                    String globalFormat = this.itemsNodes.get(commandNode).get(statusCode).getFormat();
                    if (globalFormat != null && globalFormat != format) {
                        this.itemsNodes.get(commandNode).get(statusCode).setFormat(null);
                    }
                    if ((globalType = this.itemsNodes.get(commandNode).get(statusCode).getType()) != null && globalType != type) {
                        this.itemsNodes.get(commandNode).get(statusCode).setType(null);
                    }
                }
            }
        }
        if (sourceURI != null) {
            this.itemsNodes.get(commandNode).get(statusCode).getSourceURI().add(sourceURI);
        }
    }

    public boolean onlySyncHdrStatus() {
        return this.commandNodes.size() <= 1;
    }

    public boolean isValidStatus() {
        return this.commandNodes.size() != 0;
    }

    public void nextStatus() {
        Queue<String> statusCodeNodesQueue = this.statusCodeNodes.get(this.currentCommandNode());
        this.itemsNodes.get(this.currentCommandNode()).remove(statusCodeNodesQueue.poll());
        if (statusCodeNodesQueue.isEmpty()) {
            this.itemsNodes.remove(this.currentCommandNode());
            this.statusCodeNodes.remove(this.currentCommandNode());
            this.isUnique.remove(this.currentCommandNode());
            this.commandNodes.remove();
        }
    }

    public String getMsgRef() {
        return this.currentCommandNode().getMsgID();
    }

    public String getCmdRef() {
        return this.currentCommandNode().getCmdID();
    }

    public String getCmd() {
        return this.currentCommandNode().cmd;
    }

    public List<String> getTargetRef() {
        return this.currentIsUnique() ? new ArrayList(0) : this.currentItemNode().getTargetURI();
    }

    public List<String> getSourceRef() {
        return this.currentIsUnique() ? new ArrayList(0) : this.currentItemNode().getSourceURI();
    }

    public String getStatusCode() {
        return this.currentStatusCode();
    }

    public List<Results> getResults() {
        return this.currentItemNode().results;
    }

    public String getGlobalFormat() {
        return this.currentItemNode().getFormat();
    }

    public String getGlobalType() {
        return this.currentItemNode().getType();
    }

    private CommandNode currentCommandNode() {
        return this.commandNodes.peek();
    }

    private String currentStatusCode() {
        return this.statusCodeNodes.get(this.currentCommandNode()).peek();
    }

    private ItemsNode currentItemNode() {
        return this.itemsNodes.get(this.currentCommandNode()).get(this.currentStatusCode());
    }

    private boolean currentIsUnique() {
        return this.isUnique.get(this.currentCommandNode());
    }

    private static final class CommandNode {
        private final String msgID;
        private final String cmdID;
        private final String cmd;

        public CommandNode(String msgID, String cmdID, String cmd) {
            this.msgID = msgID;
            this.cmdID = cmdID;
            this.cmd = cmd;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.cmd.hashCode();
            result = 31 * result + this.cmdID.hashCode();
            result = 31 * result + this.msgID.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof CommandNode) {
                CommandNode other = (CommandNode)obj;
                return this.msgID.equals(other.msgID) && this.cmdID.equals(other.cmdID) && this.cmd.equals(other.cmd);
            }
            return false;
        }

        public String getMsgID() {
            return this.msgID;
        }

        public String getCmdID() {
            return this.cmdID;
        }
    }

    private static final class ItemsNode {
        private final List<String> targetURI = new LinkedList<String>();
        private final List<String> sourceURI = new LinkedList<String>();
        private String format;
        private String type;
        private final List<Results> results = new LinkedList<Results>();

        public List<String> getTargetURI() {
            return this.targetURI;
        }

        public List<String> getSourceURI() {
            return this.sourceURI;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<Results> getResults() {
            return this.results;
        }
    }

    public static final class Results {
        private final String sourceURI;
        private final String format;
        private final String type;
        private final String data;

        public Results(String sourceURI, String format, String type, String data) {
            this.sourceURI = sourceURI;
            this.format = format;
            this.type = type;
            this.data = data;
        }

        public String getFormat() {
            return this.format;
        }

        public String getType() {
            return this.type;
        }

        public String getSourceURI() {
            return this.sourceURI;
        }

        public String getData() {
            return this.data;
        }
    }
}

