/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.protocols.omadm;

import java.util.concurrent.Callable;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.Status;

public enum StatusCode implements Status
{
    OK(200, "OK"),
    ACCEPTED_FOR_PROCESSING(202, "Accepted for processing"),
    AUTHENTICATION_ACCEPTED(212, "Authentication accepted"),
    CHUNCKED_ITEM_ACCEPTED(213, "Chunked item accepted"),
    OPERATION_CANCELLED(214, "Operation Cancelled"),
    NOT_EXECUTED(215, "Not executed"),
    ATOMIC_ROLL_BACK_OK(216, "Atomic roll back OK"),
    NOT_MODIFIED(304, "Not modified"),
    UNAUTHORIZED(401, "Unauthorized"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not found"),
    COMMAND_NOT_ALLOWED(405, "Command not allowed"),
    OPTIONAL_FEATURE_NOT_SUPPORTED(406, "Optional Feature Not Supported"),
    AUTHENTICATION_REQUIRED(407, "Authentication required"),
    REQUEST_TIMEOUT(408, "Request timeout"),
    INCOMPLETE_COMMAND(412, "Incomplete command"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request entity too large"),
    URI_TOO_LONG(414, "URI too long"),
    UNSUPPORTED_MEDIA_TYPE_OR_FORMAT(415, "Unsupported media type or format"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested range not satisfiable"),
    ALREADY_EXISTS(418, "Already exists"),
    DEVICE_FULL(420, "Device full"),
    SIZE_MISMATCH(424, "Size mismatch"),
    PERMISSION_DENIED(425, "Permission denied"),
    COMMAND_FAILED(500, "Command failed"),
    DATA_STORE_FAILURE(510, "Data store failure"),
    ATOMIC_ROLL_BACK_FAILED(516, "Atomic roll back failed");

    public static final StatusCode[] ADD_CODES;
    public static final StatusCode[] COPY_CODES;
    public static final StatusCode[] DELETE_CODES;
    public static final StatusCode[] GET_CODES;
    public static final StatusCode[] REPLACE_CODES;
    public static final StatusCode[] EXEC_CODES;
    private final int code;
    private final String description;

    static {
        ADD_CODES = new StatusCode[]{OK, NOT_EXECUTED, ATOMIC_ROLL_BACK_OK, UNAUTHORIZED, NOT_FOUND, COMMAND_NOT_ALLOWED, AUTHENTICATION_REQUIRED, REQUEST_ENTITY_TOO_LARGE, URI_TOO_LONG, UNSUPPORTED_MEDIA_TYPE_OR_FORMAT, ALREADY_EXISTS, DEVICE_FULL, SIZE_MISMATCH, PERMISSION_DENIED, COMMAND_FAILED, ATOMIC_ROLL_BACK_FAILED};
        COPY_CODES = new StatusCode[]{OK, NOT_EXECUTED, ATOMIC_ROLL_BACK_OK, UNAUTHORIZED, FORBIDDEN, COMMAND_NOT_ALLOWED, OPTIONAL_FEATURE_NOT_SUPPORTED, AUTHENTICATION_REQUIRED, URI_TOO_LONG, ALREADY_EXISTS, DEVICE_FULL, PERMISSION_DENIED, COMMAND_FAILED, DATA_STORE_FAILURE, ATOMIC_ROLL_BACK_FAILED};
        DELETE_CODES = new StatusCode[]{OK, NOT_EXECUTED, ATOMIC_ROLL_BACK_OK, UNAUTHORIZED, FORBIDDEN, NOT_FOUND, COMMAND_NOT_ALLOWED, AUTHENTICATION_REQUIRED, URI_TOO_LONG, PERMISSION_DENIED, ATOMIC_ROLL_BACK_FAILED};
        GET_CODES = new StatusCode[]{OK, NOT_EXECUTED, UNAUTHORIZED, NOT_FOUND, COMMAND_NOT_ALLOWED, OPTIONAL_FEATURE_NOT_SUPPORTED, AUTHENTICATION_REQUIRED, REQUEST_ENTITY_TOO_LARGE, URI_TOO_LONG, UNSUPPORTED_MEDIA_TYPE_OR_FORMAT, PERMISSION_DENIED, COMMAND_FAILED};
        REPLACE_CODES = new StatusCode[]{OK, NOT_EXECUTED, ATOMIC_ROLL_BACK_OK, UNAUTHORIZED, FORBIDDEN, NOT_FOUND, COMMAND_NOT_ALLOWED, AUTHENTICATION_REQUIRED, REQUEST_ENTITY_TOO_LARGE, URI_TOO_LONG, UNSUPPORTED_MEDIA_TYPE_OR_FORMAT, ALREADY_EXISTS, DEVICE_FULL, SIZE_MISMATCH, PERMISSION_DENIED, COMMAND_FAILED, ATOMIC_ROLL_BACK_FAILED};
        EXEC_CODES = new StatusCode[]{NOT_EXECUTED, UNAUTHORIZED, FORBIDDEN, COMMAND_NOT_ALLOWED, OPTIONAL_FEATURE_NOT_SUPPORTED, AUTHENTICATION_REQUIRED, URI_TOO_LONG, DEVICE_FULL, PERMISSION_DENIED, COMMAND_FAILED, DATA_STORE_FAILURE};
    }

    private StatusCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DMNode getResult() {
        return null;
    }

    @Override
    public boolean haveResult() {
        return false;
    }

    @Override
    public Callable<DMGenericAlert> getDelayedProcessing() {
        return null;
    }

    @Override
    public boolean haveDelayedProcessing() {
        return false;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.code)) + " " + this.description;
    }

    public static StatusCode fromInt(int code) {
        StatusCode[] statusCodeArray = StatusCode.values();
        int n = statusCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatusCode dmCode = statusCodeArray[n2];
            if (dmCode.code == code) {
                return dmCode;
            }
            ++n2;
        }
        return null;
    }
}

