/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui;

import java.lang.reflect.Field;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.koneki.commons.ui.Activator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class CommonFonts {
    public static final Font BOLD = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    public static final Font ITALIC = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
    public static final Font BOLD_ITALIC = new Font((Device)Display.getCurrent(), CommonFonts.getModifiedFontData(ITALIC.getFontData(), 3));
    private static Font STRIKETHROUGH_FONT = null;

    static {
        if (Display.getCurrent() != null) {
            CommonFonts.init();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommonFonts.init();
                }
            });
        }
    }

    private CommonFonts() {
    }

    private static void init() {
        Font defaultFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        FontData[] defaultData = defaultFont.getFontData();
        if (defaultData != null && defaultData.length == 1) {
            FontData data = new FontData(defaultData[0].getName(), defaultData[0].getHeight(), defaultData[0].getStyle());
            if ("win32".equals(SWT.getPlatform())) {
                try {
                    Field dataField = data.getClass().getDeclaredField("data");
                    Object dataObject = dataField.get(data);
                    Class<?> clazz = dataObject.getClass().getSuperclass();
                    Field strikeOutFiled = clazz.getDeclaredField("lfStrikeOut");
                    strikeOutFiled.set(dataObject, (byte)1);
                    STRIKETHROUGH_FONT = new Font((Device)Display.getCurrent(), data);
                }
                catch (NoSuchFieldException e) {
                    Activator.log(e);
                }
                catch (IllegalArgumentException e) {
                    Activator.log(e);
                }
                catch (IllegalAccessException e) {
                    Activator.log(e);
                }
            }
        }
        if (CommonFonts.getStrikeThroughFont() == null) {
            STRIKETHROUGH_FONT = defaultFont;
        }
    }

    public static void dispose() {
        if (CommonFonts.getStrikeThroughFont() != null && !CommonFonts.getStrikeThroughFont().isDisposed()) {
            CommonFonts.getStrikeThroughFont().dispose();
        }
        if (BOLD_ITALIC != null && !BOLD_ITALIC.isDisposed()) {
            BOLD_ITALIC.dispose();
        }
    }

    private static FontData[] getModifiedFontData(FontData[] baseData, int style) {
        FontData[] styleData = new FontData[baseData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = baseData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | style);
            ++i;
        }
        return styleData;
    }

    public static Font getStrikeThroughFont() {
        return STRIKETHROUGH_FONT;
    }
}

