/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.dialogs;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.CommonFonts;
import org.eclipse.koneki.commons.ui.CommonImages;
import org.eclipse.koneki.commons.ui.dialogs.IShellTitleBarListener;
import org.eclipse.koneki.commons.ui.dialogs.ShellMover;
import org.eclipse.koneki.commons.ui.dialogs.ShellTitleBarSettings;
import org.eclipse.koneki.commons.ui.widgets.CButton;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShellTitleBar
extends Composite {
    private Label titleTextLabel;
    private Region lastUsedRegion;
    private ShellMover shellMover;
    private ShellTitleBarSettings settings;
    private IShellTitleBarListener listener;

    public ShellTitleBar(Shell parent, ShellTitleBarSettings settings, IShellTitleBarListener listener) {
        super((Composite)parent, 524288);
        this.settings = settings;
        this.listener = listener;
        this.configureShell(parent, settings);
        this.createContents(this);
    }

    private void configureShell(Shell parent, ShellTitleBarSettings shellSettings) {
        GridLayoutFactory.fillDefaults().spacing(0, 1).margins(1, 1).applyTo((Composite)parent);
        parent.setBackground(shellSettings.getBorderColor());
    }

    private void createContents(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 24).applyTo((Control)this);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        final Composite titleCircle = new Composite(parent, 524288);
        titleCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        titleCircle.setBackgroundMode(2);
        layout = new GridLayout(5, false);
        layout.marginWidth = 3;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 3;
        titleCircle.setLayout((Layout)layout);
        titleCircle.addControlListener((ControlListener)new ControlAdapter(){
            private Image lastUsedBgImage;

            public void controlResized(ControlEvent e) {
                Rectangle clArea = titleCircle.getClientArea();
                this.lastUsedBgImage = new Image((Device)titleCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)this.lastUsedBgImage);
                this.drawGradient(gc, clArea);
                this.fixRegion(gc, clArea);
                gc.dispose();
                Image oldBGImage = titleCircle.getBackgroundImage();
                titleCircle.setBackgroundImage(this.lastUsedBgImage);
                if (oldBGImage != null) {
                    oldBGImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setForeground(ShellTitleBar.this.settings.getGradientBegin());
                gc.setBackground(ShellTitleBar.this.settings.getGradientEnd());
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }

            private void fixRegion(GC gc, Rectangle clArea) {
                gc.setForeground(ShellTitleBar.this.settings.getBorderColor());
                gc.drawPoint(2, 0);
                gc.drawPoint(3, 0);
                gc.drawPoint(1, 1);
                gc.drawPoint(0, 2);
                gc.drawPoint(0, 3);
                gc.drawPoint(clArea.width - 4, 0);
                gc.drawPoint(clArea.width - 3, 0);
                gc.drawPoint(clArea.width - 2, 1);
                gc.drawPoint(clArea.width - 1, 2);
                gc.drawPoint(clArea.width - 1, 3);
            }
        });
        Label titleImageLabel = new Label(titleCircle, 0);
        Image titleImage = this.settings.getTitleImage();
        titleImageLabel.setImage(titleImage != null ? titleImage : this.getPopupShellImage(this.settings.getHeight(), this.getShell()));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(0, 2).applyTo((Control)titleImageLabel);
        this.titleTextLabel = new Label(titleCircle, 0);
        this.titleTextLabel.setText(this.getShell().getText());
        this.titleTextLabel.setFont(CommonFonts.BOLD);
        this.titleTextLabel.setForeground(this.settings.getTitleText());
        this.titleTextLabel.setAlignment(0x1000000);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).indent(0, 2).applyTo((Control)this.titleTextLabel);
        if (this.settings.isShowHelpIcon()) {
            this.addShowHelpButton(titleCircle);
        }
        if (this.settings.isMinimizeable()) {
            this.addMinimizeButton(titleCircle);
        }
        if (this.settings.isCloseable()) {
            this.addCloseButton(titleCircle);
        }
        if (this.settings.isMoveable()) {
            this.shellMover = new ShellMover(this.getShell(), (Control)this.titleTextLabel);
        }
    }

    protected Image getPopupShellImage(int maximumHeight, Shell shell) {
        Image image = shell.getImage();
        int diff = Integer.MAX_VALUE;
        if (image != null && image.getBounds().height <= maximumHeight) {
            diff = maximumHeight - image.getBounds().height;
        } else {
            image = null;
        }
        Image[] images = shell.getImages();
        if (images != null && images.length > 0) {
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image2 = imageArray[n2];
                int newDiff = maximumHeight - image2.getBounds().height;
                if (newDiff >= 0 && newDiff <= diff) {
                    diff = newDiff;
                    image = image2;
                }
                ++n2;
            }
        }
        return image;
    }

    private void addCloseButton(Composite parent) {
        CButton button = new CButton(parent, "", CommonImages.getImage("icons/obj16/button-close.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellTitleBar.this.listener.closeSelected();
            }
        });
    }

    private void addShowHelpButton(Composite parent) {
        CButton button = new CButton(parent, "", CommonImages.getImage("icons/obj16/button-help.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellTitleBar.this.listener.showHelpSelected();
            }
        });
    }

    private void addMinimizeButton(Composite parent) {
        CButton button = new CButton(parent, "", CommonImages.getImage("icons/obj16/button-minimize.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellTitleBar.this.listener.minimizeSelected();
            }
        });
    }

    public void initilize() {
        Shell shell = this.getShell();
        Region region = new Region();
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 5, 1);
        region.subtract(0, 1, 3, 1);
        region.subtract(0, 2, 2, 1);
        region.subtract(0, 3, 1, 1);
        region.subtract(0, 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
        this.lastUsedRegion = region;
    }

    public void dispose() {
        this.lastUsedRegion.dispose();
        if (this.shellMover != null) {
            this.shellMover.dispose();
        }
        super.dispose();
    }

    public Label getTitleTextLabel() {
        return this.titleTextLabel;
    }
}

