/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BorderedComposite
extends Composite {
    private static final int BORDER_WIDTH = 1;
    private Composite borderComposite;
    private Composite backgroundComposite;

    public BorderedComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.createBorderedContainer(this);
    }

    private Composite createBorderedContainer(Composite parent) {
        this.borderComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.borderComposite);
        GridLayoutFactory.fillDefaults().margins(1, 1).applyTo(this.borderComposite);
        this.borderComposite.setBackground(ColorRegistry.COLOR_GREY);
        this.borderComposite.setBackgroundMode(1);
        this.backgroundComposite = new Composite(this.borderComposite, 0);
        this.backgroundComposite.setBackground(ColorRegistry.INFO_TIP_BACKGROUND);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(this.backgroundComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.backgroundComposite);
        return this.backgroundComposite;
    }

    public Composite getBackgroundComposite() {
        return this.backgroundComposite;
    }

    public void setBorderColor(Color borderColor) {
        this.borderComposite.setBackground(borderColor);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundComposite.setBackground(backgroundColor);
    }
}

