/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.Activator;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormText;

public class InfoBanner
extends Composite {
    private static final int DEFAULT_BORDER_WIDTH = 1;
    private CLabel iconLbl;
    private FormText infoTxt;
    private Composite borderComposite;
    private Composite backgroundComposite;
    private int borderWidth = 1;

    public InfoBanner(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this);
        this.createInfoTipArea(this.createInfoTipContainer(this));
    }

    protected Control createInfoTipArea(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(10, 0).numColumns(2).applyTo(parent);
        this.iconLbl = new CLabel(parent, 0);
        this.iconLbl.setImage(Activator.getImage("icons/obj16/lightbulb.png"));
        this.iconLbl.setBackground(parent.getBackground());
        this.infoTxt = new FormText(parent, 524288);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.infoTxt);
        this.infoTxt.setBackground(parent.getBackground());
        this.infoTxt.setForeground(ColorRegistry.INFO_TIP_TEXT);
        this.infoTxt.setCursor(new Cursor(null, 0));
        this.infoTxt.setCaret(null);
        return parent;
    }

    private Composite createInfoTipContainer(Composite parent) {
        this.borderComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.borderComposite);
        GridLayoutFactory.fillDefaults().margins(this.borderWidth, this.borderWidth).applyTo(this.borderComposite);
        this.borderComposite.setBackground(ColorRegistry.COLOR_GREY);
        this.backgroundComposite = new Composite(this.borderComposite, 0);
        this.backgroundComposite.setBackground(ColorRegistry.INFO_TIP_BACKGROUND);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.backgroundComposite);
        return this.backgroundComposite;
    }

    public void setIcon(Image image) {
        this.iconLbl.setImage(image);
    }

    public CLabel getIconLabel() {
        return this.iconLbl;
    }

    public FormText getFormText() {
        return this.infoTxt;
    }

    public void setBorderColor(Color borderColor) {
        this.borderComposite.setBackground(borderColor);
    }

    public void setBorderWidth(int borderWidth) {
        ((GridLayout)this.borderComposite.getLayout()).marginHeight = borderWidth;
        ((GridLayout)this.borderComposite.getLayout()).marginWidth = borderWidth;
        this.borderComposite.layout();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundComposite.setBackground(backgroundColor);
        this.iconLbl.setBackground(backgroundColor);
        this.infoTxt.setBackground(backgroundColor);
    }

    public void setTextContents(String txt) {
        this.infoTxt.setText(txt, true, true);
        this.infoTxt.pack();
    }

    public boolean setFocus() {
        return false;
    }
}

