/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.internal.dashboard;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.simulators.omadm.editor.Messages;
import org.eclipse.koneki.simulators.omadm.editor.OMADMSimulatorEditor;
import org.eclipse.koneki.simulators.omadm.editor.internal.Activator;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.DashboardPage;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorPackage;
import org.eclipse.pde.emfforms.editor.EmfDetailsPart;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Section;

public class DashboardPart
extends EmfDetailsPart {
    private final DashboardPage page;
    private Label nameLabel;
    private Label formatLabel;
    private Label typeLabel;
    private Text dataText;
    private ToolItem monitoringToolItem;

    public DashboardPart(DashboardPage page) {
        super((EmfFormEditor)page.getEditor());
        this.page = page;
    }

    protected void createSpecificContent(Composite parent) {
        ANWRTToolkit toolkit = ((OMADMSimulatorEditor)this.getEditor()).getANWRTToolkit();
        Section nodePropertiesSection = toolkit.createSection(parent, 256);
        nodePropertiesSection.setText(Messages.PropertiesSection_Title);
        nodePropertiesSection.marginWidth = 5;
        nodePropertiesSection.marginHeight = 5;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)nodePropertiesSection);
        ToolBar nodePropertiesToolBar = new ToolBar((Composite)nodePropertiesSection, 0x800000);
        Composite nodePropertiesComposite = toolkit.createComposite((Composite)nodePropertiesSection);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(nodePropertiesComposite);
        toolkit.createTitleLabel(nodePropertiesComposite, Messages.PropertiesSection_Title_Name);
        this.nameLabel = toolkit.createLabel(nodePropertiesComposite, null);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.nameLabel);
        toolkit.createTitleLabel(nodePropertiesComposite, Messages.PropertiesSection_Title_Format);
        this.formatLabel = toolkit.createLabel(nodePropertiesComposite, null);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.formatLabel);
        toolkit.createTitleLabel(nodePropertiesComposite, Messages.PropertiesSection_Title_Type);
        this.typeLabel = toolkit.createLabel(nodePropertiesComposite, null);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.typeLabel);
        this.dataText = toolkit.createTitleLabelAndText(nodePropertiesComposite, Messages.PropertiesSection_Title_Data);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.dataText);
        this.monitoringToolItem = new ToolItem(nodePropertiesToolBar, 8);
        this.monitoringToolItem.setImage(Activator.getDefault().getImage("icons/obj16/monitoring_alert.png"));
        this.monitoringToolItem.setToolTipText("Monitoring alert");
        this.monitoringToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Node node = (Node)DashboardPart.this.getCurrentSelection().getValue();
                DashboardPart.this.page.addGenericAlert(new DMGenericAlert(node.getType(), node.getFormat().getLiteral(), "informational", node.getData(), null, node.getPath()));
            }
        });
        nodePropertiesSection.setClient((Control)nodePropertiesComposite);
        nodePropertiesSection.setTextClient((Control)nodePropertiesToolBar);
    }

    protected void bind(DataBindingContext dataBindingContext) {
        EditingDomain editingDomain = this.getEditingDomain();
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.nameLabel), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__NAME));
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.formatLabel), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__FORMAT));
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.typeLabel), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__TYPE));
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.dataText), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__DATA));
        dataBindingContext.bindValue((IObservableValue)new AbstractObservableValue(){

            public Object getValueType() {
                return Boolean.class;
            }

            protected Object doGetValue() {
                return DashboardPart.this.monitoringToolItem.isEnabled();
            }

            protected void doSetValue(Object value) {
                DashboardPart.this.monitoringToolItem.setEnabled(((Boolean)value).booleanValue());
            }
        }, (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                if (DashboardPart.this.getCurrentSelection() != null && DashboardPart.this.getCurrentSelection().getValue() != null) {
                    return ((Node)DashboardPart.this.getCurrentSelection().getValue()).isLeaf();
                }
                return false;
            }
        });
    }
}

