/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.internal.simulation;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.simulators.omadm.editor.Messages;
import org.eclipse.koneki.simulators.omadm.editor.OMADMSimulatorEditor;
import org.eclipse.koneki.simulators.omadm.model.CommandManagement;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorPackage;
import org.eclipse.pde.emfforms.editor.EmfDetailsPart;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Section;

public class SimulationPart
extends EmfDetailsPart {
    private Text nameText;
    private ComboViewer formatCombo;
    private Text typeText;
    private Text dataText;
    private ComboViewer getManagementCombo;
    private ComboViewer getCodeCombo;
    private ComboViewer addManagementCombo;
    private ComboViewer addCodeCombo;
    private ComboViewer deleteManagementCombo;
    private ComboViewer deleteCodeCombo;
    private ComboViewer copyManagementCombo;
    private ComboViewer copyCodeCombo;
    private ComboViewer replaceManagementCombo;
    private ComboViewer replaceCodeCombo;
    private ComboViewer execManagementCombo;
    private ComboViewer execCodeCombo;

    public SimulationPart(OMADMSimulatorEditor parentEditor) {
        super((EmfFormEditor)parentEditor);
    }

    protected void createSpecificContent(Composite parent) {
        ANWRTToolkit toolkit = ((OMADMSimulatorEditor)this.getEditor()).getANWRTToolkit();
        this.createNodePropertiesSection(parent, toolkit);
        this.createNodeManagementSection(parent, toolkit);
    }

    private void createNodePropertiesSection(Composite parent, ANWRTToolkit toolkit) {
        Section nodePropertiesSection = toolkit.createSection(parent, 256);
        nodePropertiesSection.setText(Messages.PropertiesSection_Title);
        nodePropertiesSection.marginWidth = 5;
        nodePropertiesSection.marginHeight = 5;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)nodePropertiesSection);
        Composite nodePropertiesComposite = toolkit.createComposite((Composite)nodePropertiesSection);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(nodePropertiesComposite);
        this.nameText = toolkit.createTitleLabelAndText(nodePropertiesComposite, Messages.PropertiesSection_Title_Name);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.nameText);
        this.formatCombo = toolkit.createTitleLabelAndComboViewer(nodePropertiesComposite, Messages.PropertiesSection_Title_Format, 8);
        this.formatCombo.setInput((Object)NodeFormat.VALUES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.formatCombo.getCombo());
        this.typeText = toolkit.createTitleLabelAndText(nodePropertiesComposite, Messages.PropertiesSection_Title_Type);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.typeText);
        this.dataText = toolkit.createTitleLabelAndText(nodePropertiesComposite, Messages.PropertiesSection_Title_Data);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.dataText);
        nodePropertiesSection.setClient((Control)nodePropertiesComposite);
    }

    private void createNodeManagementSection(Composite parent, ANWRTToolkit toolkit) {
        Section nodeManagementSection = toolkit.createSection(parent, 256);
        nodeManagementSection.setText(Messages.NodeManagementSection_Title);
        nodeManagementSection.marginWidth = 5;
        nodeManagementSection.marginHeight = 5;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)nodeManagementSection);
        Composite nodeManagementComposite = toolkit.createComposite((Composite)nodeManagementSection);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(nodeManagementComposite);
        this.getManagementCombo = toolkit.createTitleLabelAndComboViewer(nodeManagementComposite, Messages.NodeManagementSection_Get, 8);
        this.getManagementCombo.setInput((Object)CommandManagement.VALUES);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.getManagementCombo.getCombo());
        this.getCodeCombo = toolkit.createComboViewer(nodeManagementComposite, 8);
        this.getCodeCombo.setInput((Object)StatusCode.GET_CODES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.getCodeCombo.getCombo());
        this.addManagementCombo = toolkit.createTitleLabelAndComboViewer(nodeManagementComposite, Messages.NodeManagementSection_Add, 8);
        this.addManagementCombo.setInput((Object)CommandManagement.VALUES);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.addManagementCombo.getCombo());
        this.addCodeCombo = toolkit.createComboViewer(nodeManagementComposite, 8);
        this.addCodeCombo.setInput((Object)StatusCode.ADD_CODES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.addCodeCombo.getCombo());
        this.deleteManagementCombo = toolkit.createTitleLabelAndComboViewer(nodeManagementComposite, Messages.NodeManagementSection_Delete, 8);
        this.deleteManagementCombo.setInput((Object)CommandManagement.VALUES);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.deleteManagementCombo.getCombo());
        this.deleteCodeCombo = toolkit.createComboViewer(nodeManagementComposite, 8);
        this.deleteCodeCombo.setInput((Object)StatusCode.DELETE_CODES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.deleteCodeCombo.getCombo());
        this.copyManagementCombo = toolkit.createTitleLabelAndComboViewer(nodeManagementComposite, Messages.NodeManagementSection_Copy, 8);
        this.copyManagementCombo.setInput((Object)CommandManagement.VALUES);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.copyManagementCombo.getCombo());
        this.copyCodeCombo = toolkit.createComboViewer(nodeManagementComposite, 8);
        this.copyCodeCombo.setInput((Object)StatusCode.COPY_CODES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.copyCodeCombo.getCombo());
        this.replaceManagementCombo = toolkit.createTitleLabelAndComboViewer(nodeManagementComposite, Messages.NodeManagementSection_Replace, 8);
        this.replaceManagementCombo.setInput((Object)CommandManagement.VALUES);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.replaceManagementCombo.getCombo());
        this.replaceCodeCombo = toolkit.createComboViewer(nodeManagementComposite, 8);
        this.replaceCodeCombo.setInput((Object)StatusCode.REPLACE_CODES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.replaceCodeCombo.getCombo());
        this.execManagementCombo = toolkit.createTitleLabelAndComboViewer(nodeManagementComposite, Messages.NodeManagementSection_Exec, 8);
        this.execManagementCombo.setInput((Object)CommandManagement.VALUES);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.execManagementCombo.getCombo());
        this.execCodeCombo = toolkit.createComboViewer(nodeManagementComposite, 8);
        this.execCodeCombo.setInput((Object)StatusCode.EXEC_CODES);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.execCodeCombo.getCombo());
        nodeManagementSection.setClient((Control)nodeManagementComposite);
    }

    protected void bind(DataBindingContext dataBindingContext) {
        EditingDomain editingDomain = this.getEditingDomain();
        this.bindNodePropertiesSection(dataBindingContext, editingDomain);
        this.bindNodeManagementSection(dataBindingContext, editingDomain);
        this.hookListener();
    }

    private void bindNodePropertiesSection(DataBindingContext dataBindingContext, EditingDomain editingDomain) {
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameText), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__NAME));
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.formatCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__FORMAT));
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.typeText), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__TYPE));
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.dataText), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__DATA));
    }

    private void bindNodeManagementSection(DataBindingContext dataBindingContext, EditingDomain editingDomain) {
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(){

            public Object convert(Object value) {
                return Integer.parseInt(((String)value).split(" ")[0]);
            }
        };
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(){

            public Object convert(Object value) {
                return StatusCode.fromInt((int)((Integer)value)).toString();
            }
        };
        ManagementChangeListener getChangeListener = new ManagementChangeListener(this.getManagementCombo, this.getCodeCombo);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.getManagementCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__GET_MANAGEMENT)).getTarget().addChangeListener((IChangeListener)getChangeListener);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.getCodeCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__GET_CODE), targetToModel, modelToTarget);
        ManagementChangeListener addChangeListener = new ManagementChangeListener(this.addManagementCombo, this.addCodeCombo);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.addManagementCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__ADD_MANAGEMENT)).getTarget().addChangeListener((IChangeListener)addChangeListener);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.addCodeCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__ADD_CODE), targetToModel, modelToTarget);
        ManagementChangeListener deleteChangeListener = new ManagementChangeListener(this.deleteManagementCombo, this.deleteCodeCombo);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.deleteManagementCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__DELETE_MANAGEMENT)).getTarget().addChangeListener((IChangeListener)deleteChangeListener);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.deleteCodeCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__DELETE_CODE), targetToModel, modelToTarget);
        ManagementChangeListener copyChangeListener = new ManagementChangeListener(this.copyManagementCombo, this.copyCodeCombo);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.copyManagementCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__COPY_MANAGEMENT)).getTarget().addChangeListener((IChangeListener)copyChangeListener);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.copyCodeCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__COPY_CODE), targetToModel, modelToTarget);
        ManagementChangeListener replaceChangeListener = new ManagementChangeListener(this.replaceManagementCombo, this.replaceCodeCombo);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.replaceManagementCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__REPLACE_MANAGEMENT)).getTarget().addChangeListener((IChangeListener)replaceChangeListener);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.replaceCodeCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__REPLACE_CODE), targetToModel, modelToTarget);
        ManagementChangeListener execChangeListener = new ManagementChangeListener(this.execManagementCombo, this.execCodeCombo);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.execManagementCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__EXEC_MANAGEMENT)).getTarget().addChangeListener((IChangeListener)execChangeListener);
        dataBindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.execCodeCombo.getCombo()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)editingDomain, (IObservableValue)this.getCurrentSelection(), (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__EXEC_CODE), targetToModel, modelToTarget);
    }

    private void hookListener() {
        new ManagementChangeListener(this.getManagementCombo, this.getCodeCombo);
    }

    private static class ManagementChangeListener
    implements IChangeListener {
        private final ComboViewer managementCombo;
        private final ComboViewer codeCombo;

        public ManagementChangeListener(ComboViewer managementCombo, ComboViewer codeCombo) {
            this.managementCombo = managementCombo;
            this.codeCombo = codeCombo;
        }

        public void handleChange(ChangeEvent event) {
            this.codeCombo.getCombo().setEnabled(((StructuredSelection)this.managementCombo.getSelection()).getFirstElement() == CommandManagement.CONSTANT);
        }
    }
}

