/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.fumo.manual.internal;

import java.util.concurrent.Callable;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.DelayedProcessing;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.simulators.omadm.basic.DMCommandHelper;
import org.eclipse.koneki.simulators.omadm.basic.DMExecHandler;
import org.eclipse.koneki.simulators.omadm.fumo.FumoResultCode;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DMFumoManualExecHandler
implements DMExecHandler {
    private static final String FUMO = "FUMO";
    private static final String CHR = "chr";
    private static final String TEXT_PLAIN = "text/plain";
    private DMGenericAlert genericAlert;

    public Status exec(final Node nodeToExec, final EditingDomain editingDomain, String correlator, String format, String type, String data) {
        if (!nodeToExec.getParent().getType().equals("urn:oma:mo:oma-fumo:1.0")) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)DMFumoManualExecHandler.FUMO, (String)("Do you want to use FUMO for the Exec command on " + nodeToExec.getPath() + "?"))) {
                        DMCommandHelper.replace((Node)nodeToExec.getRoot(), (EditingDomain)editingDomain, (String)nodeToExec.getParent().getPath(), (String)NodeFormat.NODE.getLiteral(), (String)"urn:oma:mo:oma-fumo:1.0", (String)"", (boolean)true);
                    }
                }
            });
        }
        if (nodeToExec.getName().equals("Download") && nodeToExec.getParent().getType().equals("urn:oma:mo:oma-fumo:1.0")) {
            return this.download(nodeToExec, editingDomain, correlator, format, type, data);
        }
        if (nodeToExec.getName().equals("Update") && nodeToExec.getParent().getType().equals("urn:oma:mo:oma-fumo:1.0")) {
            return this.update(nodeToExec, editingDomain, correlator, format, type, data);
        }
        if (nodeToExec.getName().equals("DownloadAndUpdate") && nodeToExec.getParent().getType().equals("urn:oma:mo:oma-fumo:1.0")) {
            return this.downloadAndUpdate(nodeToExec, editingDomain, correlator, format, type, data);
        }
        return null;
    }

    private Status download(final Node nodeToExec, EditingDomain editingDomain, final String correlator, String format, String type, String data) {
        return new DelayedProcessing(StatusCode.ACCEPTED_FOR_PROCESSING, (Callable)new Callable<DMGenericAlert>(){

            @Override
            public DMGenericAlert call() throws Exception {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FumoDialog dialog = new FumoDialog(Display.getDefault().getActiveShell());
                        dialog.setText("FUMO download");
                        dialog.setExecText("FUMO download on " + nodeToExec.getPath());
                        dialog.setCodes(FumoResultCode.values());
                        dialog.setWithNewVersion(false);
                        dialog.setSelectionListener(new FumoDialog.OKSelectionListener(){

                            @Override
                            public void selected(FumoResultCode resultCode, String firmwareVersion, String softwareVersion) {
                                String mark = resultCode.getCode() < 300 ? "informational" : "critical";
                                DMFumoManualExecHandler.this.setGenericAlert(new DMGenericAlert("org.openmobilealliance.dm.firmwareupdate.download", "int", mark, String.valueOf(resultCode.getCode()), correlator, nodeToExec.getPath()));
                            }
                        });
                        dialog.open();
                    }
                });
                return DMFumoManualExecHandler.this.getGenericAlert();
            }
        });
    }

    private Status update(final Node nodeToExec, final EditingDomain editingDomain, final String correlator, String format, String type, String data) {
        return new DelayedProcessing(StatusCode.ACCEPTED_FOR_PROCESSING, (Callable)new Callable<DMGenericAlert>(){

            @Override
            public DMGenericAlert call() throws Exception {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FumoDialog dialog = new FumoDialog(Display.getDefault().getActiveShell());
                        dialog.setText("FUMO update");
                        dialog.setExecText("FUMO update on " + nodeToExec.getPath());
                        dialog.setCodes(FumoResultCode.values());
                        dialog.setWithNewVersion(true);
                        dialog.setFirmawareVersion(DMFumoManualExecHandler.getFwV(nodeToExec));
                        dialog.setSoftwareVersion(DMFumoManualExecHandler.getSwV(nodeToExec));
                        dialog.setSelectionListener(new FumoDialog.OKSelectionListener(){

                            @Override
                            public void selected(FumoResultCode resultCode, String firmwareVersion, String softwareVersion) {
                                String mark;
                                if (resultCode.getCode() < 300) {
                                    mark = "informational";
                                    DMCommandHelper.replace((Node)nodeToExec.getRoot(), (EditingDomain)editingDomain, (String)"./DevDetail/FwV", (String)DMFumoManualExecHandler.CHR, (String)DMFumoManualExecHandler.TEXT_PLAIN, (String)firmwareVersion, (boolean)true);
                                    DMCommandHelper.replace((Node)nodeToExec.getRoot(), (EditingDomain)editingDomain, (String)"./DevDetail/SwV", (String)DMFumoManualExecHandler.CHR, (String)DMFumoManualExecHandler.TEXT_PLAIN, (String)softwareVersion, (boolean)true);
                                } else {
                                    mark = "critical";
                                }
                                DMFumoManualExecHandler.this.setGenericAlert(new DMGenericAlert("org.openmobilealliance.dm.firmwareupdate.update", "int", mark, String.valueOf(resultCode.getCode()), correlator, nodeToExec.getPath()));
                            }
                        });
                        dialog.open();
                    }
                });
                return DMFumoManualExecHandler.this.getGenericAlert();
            }
        });
    }

    private Status downloadAndUpdate(final Node nodeToExec, final EditingDomain editingDomain, final String correlator, String format, String type, String data) {
        return new DelayedProcessing(StatusCode.ACCEPTED_FOR_PROCESSING, (Callable)new Callable<DMGenericAlert>(){

            @Override
            public DMGenericAlert call() throws Exception {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FumoDialog dialog = new FumoDialog(Display.getDefault().getActiveShell());
                        dialog.setText("FUMO download and update");
                        dialog.setExecText("FUMO download and update on " + nodeToExec.getPath());
                        dialog.setCodes(FumoResultCode.values());
                        dialog.setWithNewVersion(true);
                        dialog.setFirmawareVersion(DMFumoManualExecHandler.getFwV(nodeToExec));
                        dialog.setSoftwareVersion(DMFumoManualExecHandler.getSwV(nodeToExec));
                        dialog.setSelectionListener(new FumoDialog.OKSelectionListener(){

                            @Override
                            public void selected(FumoResultCode resultCode, String firmwareVersion, String softwareVersion) {
                                String mark;
                                if (resultCode.getCode() < 300) {
                                    mark = "informational";
                                    DMCommandHelper.replace((Node)nodeToExec.getRoot(), (EditingDomain)editingDomain, (String)"./DevDetail/FwV", (String)DMFumoManualExecHandler.CHR, (String)DMFumoManualExecHandler.TEXT_PLAIN, (String)firmwareVersion, (boolean)true);
                                    DMCommandHelper.replace((Node)nodeToExec.getRoot(), (EditingDomain)editingDomain, (String)"./DevDetail/SwV", (String)DMFumoManualExecHandler.CHR, (String)DMFumoManualExecHandler.TEXT_PLAIN, (String)softwareVersion, (boolean)true);
                                } else {
                                    mark = "critical";
                                }
                                DMFumoManualExecHandler.this.setGenericAlert(new DMGenericAlert("org.openmobilealliance.dm.firmwareupdate.downloadandupdate", "int", mark, String.valueOf(resultCode.getCode()), correlator, nodeToExec.getPath()));
                            }
                        });
                        dialog.open();
                    }
                });
                return DMFumoManualExecHandler.this.getGenericAlert();
            }
        });
    }

    public String getManagementObjectIdentifierSupported() {
        return "urn:oma:mo:oma-fumo:1.0";
    }

    public String[] getNodePathsSupported() {
        return new String[]{"./Download", "./Update", "./DownloadAndUpdate"};
    }

    public boolean requireUserInteraction() {
        return true;
    }

    private static String getFwV(Node node) {
        Node fwV = NodeHelpers.getNode((Node)node.getRoot(), (String)"./DevDetail/FwV");
        return fwV != null ? fwV.getData() : "";
    }

    private static String getSwV(Node node) {
        Node swV = NodeHelpers.getNode((Node)node.getRoot(), (String)"./DevDetail/SwV");
        return swV != null ? swV.getData() : "";
    }

    private DMGenericAlert getGenericAlert() {
        return this.genericAlert;
    }

    public void setGenericAlert(DMGenericAlert genericAlert) {
        this.genericAlert = genericAlert;
    }

    private static final class FumoDialog
    extends Dialog {
        private final ANWRTToolkit toolkit = new ANWRTToolkit(Display.getDefault());
        private String execText;
        private FumoResultCode[] codes;
        private boolean withNewVersion;
        private String firmawareVersion;
        private String softwareVersion;
        private OKSelectionListener selectionListener;

        public FumoDialog(Shell parent) {
            super(parent, 2080);
        }

        public void open() {
            Shell dialog = new Shell(this.getParent(), this.getStyle());
            dialog.setText(this.getText());
            this.createContents(dialog);
            dialog.pack();
            dialog.open();
            Display display = this.getParent().getDisplay();
            while (!dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }

        private void createContents(final Shell parent) {
            SelectionAdapter okListener;
            GridLayoutFactory.fillDefaults().numColumns(2).margins(20, 10).applyTo((Composite)parent);
            Label execLabel = this.toolkit.createLabel((Composite)parent, this.getExecText());
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)execLabel);
            this.toolkit.createLabel((Composite)parent, "Result code:");
            final ComboViewer resultCodeCombo = this.toolkit.createComboViewer((Composite)parent, 8);
            resultCodeCombo.setInput((Object)this.getCodes());
            resultCodeCombo.getCombo().select(0);
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)resultCodeCombo.getCombo());
            if (this.getWithNewVersion()) {
                this.toolkit.createLabel((Composite)parent, "Firmware version:");
                final Text firmwareVersionText = this.toolkit.createText((Composite)parent, this.getFirmawareVersion(), 2048);
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)firmwareVersionText);
                this.toolkit.createLabel((Composite)parent, "Software version:");
                final Text softwareVersionText = this.toolkit.createText((Composite)parent, this.getSoftwareVersion(), 2048);
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)softwareVersionText);
                resultCodeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        switch ((FumoResultCode)((StructuredSelection)event.getSelection()).getFirstElement()) {
                            case SUCCESSFUL: {
                                firmwareVersionText.setEnabled(true);
                                softwareVersionText.setEnabled(true);
                                break;
                            }
                            default: {
                                firmwareVersionText.setEnabled(false);
                                softwareVersionText.setEnabled(false);
                            }
                        }
                    }
                });
                okListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FumoResultCode resultCode = (FumoResultCode)((StructuredSelection)resultCodeCombo.getSelection()).getFirstElement();
                        FumoDialog.this.getSelectionListener().selected(resultCode, firmwareVersionText.getText(), softwareVersionText.getText());
                        parent.close();
                    }
                };
            } else {
                okListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FumoResultCode resultCode = (FumoResultCode)((StructuredSelection)resultCodeCombo.getSelection()).getFirstElement();
                        FumoDialog.this.getSelectionListener().selected(resultCode, null, null);
                        parent.close();
                    }
                };
            }
            Button okButton = this.toolkit.createButton((Composite)parent, "OK", 8);
            okButton.addSelectionListener((SelectionListener)okListener);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 4).applyTo((Control)okButton);
        }

        public String getExecText() {
            return this.execText;
        }

        public void setExecText(String execText) {
            this.execText = execText;
        }

        public FumoResultCode[] getCodes() {
            return this.codes;
        }

        public void setCodes(FumoResultCode[] codes) {
            this.codes = codes;
        }

        private String getFirmawareVersion() {
            return this.firmawareVersion;
        }

        public void setFirmawareVersion(String firmawareVersion) {
            this.firmawareVersion = firmawareVersion;
        }

        private String getSoftwareVersion() {
            return this.softwareVersion;
        }

        public void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        private boolean getWithNewVersion() {
            return this.withNewVersion;
        }

        public void setWithNewVersion(boolean withNewVersion) {
            this.withNewVersion = withNewVersion;
        }

        public OKSelectionListener getSelectionListener() {
            return this.selectionListener;
        }

        public void setSelectionListener(OKSelectionListener selectionListener) {
            this.selectionListener = selectionListener;
        }

        public static interface OKSelectionListener {
            public void selected(FumoResultCode var1, String var2, String var3);
        }
    }
}

